<?php
/**
 * @package Helix Ultimate Framework
 * @author JoomShaper https://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2021 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or Later
*/

defined ('JPATH_BASE') or die();

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\User\UserHelper;
use Joomla\CMS\Router\Route;

require_once JPATH_ROOT . '/components/com_spauthorarchive/helpers/helper.php';

$template = HelixUltimate\Framework\Platform\Helper::loadTemplateData();
$params = $template->params;
?>

<?php if($params->get('author_info', 0)) : ?>
	<div class="article-author-information">
		<?php 
			$author = Factory::getUser( (int) $displayData->created_by );
			$profile = UserHelper::getProfile( (int) $displayData->created_by );
			
			// Check for custom avatar from profilespaarchive plugin
			$authorImage = '';
			if (isset($profile->profilespaarchive['avatar'])) {
				$avatarData = $profile->profilespaarchive['avatar'];
				// If it's a string, decode it; if it's already an array, use it directly
				if (is_string($avatarData)) {
					$avatarData = json_decode($avatarData, true);
				}
				if (!empty($avatarData['avatar'])) {
					$authorImage = \Joomla\CMS\Uri\Uri::root(true) . $avatarData['avatar'];
				}
			}
			
			// Fall back to Gravatar if no custom avatar
			if (empty($authorImage)) {
				$authorImage = 'https://www.gravatar.com/avatar/' . md5($author->get('email')) . '?s=64&d=identicon&r=PG';
			}
			
			// Generate author page link
			$authorLink = Route::_('index.php?option=com_spauthorarchive&view=articles&uid=' . $author->id . ':' . $author->username . SpauthorarchiveHelper::getItemid('authors'));
		?>
		<div class="d-flex">
			<div class="flex-shrink-0">
				<a href="<?php echo $authorLink; ?>">
					<img class="me-3 rounded-circle" src="<?php echo $authorImage; ?>" alt="<?php echo $author->name; ?>" width="64" height="64" style="object-fit: cover;">
				</a>
			</div>
			<div class="flex-grow-1 ms-3">
				<h5 class="mt-0">
					<a href="<?php echo $authorLink; ?>"><?php echo $author->name; ?></a>
				</h5>
				<?php if(isset($profile->profile['aboutme']) && $profile->profile['aboutme']) : ?>
					<div class="author-bio">
						<?php echo $profile->profile['aboutme']; ?>
						<?php if(isset($profile->profile['website']) && $profile->profile['website']) : ?>
							<div class="author-website mt-2">
								<strong><?php echo Text::_('HELIX_ULTIMATE_BLOG_AUTHOR_WEBSITE'); ?>:</strong> <a target="_blank" rel="noopener noreferrer" href="<?php echo strip_tags($profile->profile['website'], ''); ?>"><?php echo strip_tags($profile->profile['website'], ''); ?></a>
							</div>
						<?php endif; ?>
					</div>
				<?php endif; ?>
			</div>
		</div>
	</div>
<?php endif; ?>
