<?php

/**
 * @package     Joomla.Administrator
 * @subpackage  com_easystore
 *
 * @copyright   (C) 2023 JoomShaper. <https://www.joomshaper.com>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace JoomShaper\Plugin\EasyStore\Stripe\Field;

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Form\FormField;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * EasystoreWebhookButton field
 *
 * @since   1.0.0
 */
class EasystoreWebhookButtonField extends FormField
{
    /**
     * Field type
     *
     * @var     string  $type
     * @since   1.0.0
     */
    protected $type = 'EasystoreWebhookButton';

    /**
     * Override getInput function form FormField
     *
     * @return  string  Field HTML string
     * @since   1.0.0
     */
    protected function getInput()
    {
        Text::script('PLG_EASYSTORE_STRIPE_WEBHOOK_ENDPOINT_EXISTS');
        Text::script('PLG_EASYSTORE_STRIPE_WEBHOOK_ENDPOINT_CREATED');
        Text::script('PLG_EASYSTORE_STRIPE_WEBHOOK_BUTTON_DESC');
        Text::script('PLG_EASYSTORE_STRIPE_WEBHOOK_BUTTON_CREATE');
        
        $app      = Factory::getApplication();
        $document = $app->getDocument();
        $document->addScriptOptions('easystore.base', rtrim(Uri::root(), '/'));

        $wa = Factory::getApplication()->getDocument()->getWebAssetManager();
        $wa->registerAndUseScript('plg_easystore_stripe.webhook.button', 'media/plg_easystore_stripe/js/webhook-button.js', [], ['defer' => true]);

        $text             = !empty($this->element['text']) ? $this->element['text'] : 'Button';
        $WebhookSecretKey = $this->form->getValue('stripe_webhook_secret_key', 'params');
        $buttonDisable    = !empty($WebhookSecretKey) ? 'disabled="disabled"' : '';

        return '<button type="submit" id="easystore-create-webhook" class="btn btn-success" ' . $buttonDisable . ' >' . Text::_($text) . '</button>';
    }
}
