<?php

/**
 * @package     EasyStore.Site
 * @subpackage  EasyStore.Stripe
 *
 * @copyright   Copyright (C) 2023 JoomShaper <https://www.joomshaper.com>. All rights reserved.
 * @license     GNU General Public License version 3; see LICENSE
 */

namespace JoomShaper\Plugin\EasyStore\Stripe\Utils;

class StripeHelper{

    /**
     * Get an array of shipping options based on product information.
     *
     * @param object $productInformation --- An object containing product information.
     *
     * @return array                     --- An array of shipping options or an empty array if no shipping charge is   
     *                                       applicable.
     * @since  1.0.0
     */
    public static function getShippingOptions($productInformation) {
        
        $shippingData = [];

        if (!is_null($productInformation->shipping_charge) && $productInformation->currency) {
            $shippingData[] = [
                'shipping_rate_data' => [
                    'display_name' => 'Shipping Charge',
                    'type'         => 'fixed_amount',
                    'fixed_amount' => [
                        'amount'   => $productInformation->shipping_charge * 100,
                        'currency' => $productInformation->currency
                    ]
                ]
            ];          
        }

        return $shippingData;
    }
}