/**
 * @package Helix3 Framework
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2015 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */
jQuery(function ($) {

    $('#offcanvas-toggler').on('click', function (event) {
        event.preventDefault();
        $('body').addClass('offcanvas');
    });

    $('<div class="offcanvas-overlay"></div>').insertBefore('.body-innerwrapper > .offcanvas-menu');

    $('.close-offcanvas, .offcanvas-overlay').on('click', function (event) {
        event.preventDefault();
        $('body').removeClass('offcanvas');
    });

    //Mega Menu
    $('.sp-megamenu-wrapper').parent().parent().css('position', 'static').parent().css('position', 'relative');
    $('.sp-menu-full').each(function () {
        $(this).parent().addClass('menu-justify');
    });

    //Sticky Menu
    $(document).ready(function () {
        $("body.sticky-header").find('#sp-main-menu').sticky({topSpacing: 0, center: true})
    });

    //Search
    var searchRow = $('.top-search-input-wrap').parent().closest('.row');
    $('.top-search-input-wrap').insertAfter(searchRow);

    $(".fa-search").on('click', function () {
        $(".top-search-input-wrap").slideDown(200);
        $(this).hide();
        $('.fa-times').show();
        $(".top-search-input-wrap").addClass('active');
    });

    $(".fa-times").on('click', function () {
        $(".top-search-input-wrap").slideUp(200);
        $(this).hide();
        $('.fa-search').show();
        $(".top-search-input-wrap").removeClass('active');
    });

    //Shopping cart
    var toggle = $('.cart-toggle'),
            hikashop_cart = $('.hikashop_cart_module');

    toggle.on('click', function () {
        hikashop_cart.slideToggle(200);
        $(this).parent().toggleClass('active');
    });

    // click outside slideup
    $(document).on('click', function (e) {

        //hikashop cart
        if (!toggle.is(e.target) && !$('.hikashop_cart_module').is(e.target) && !$('.hikashop_cart_module *').is(e.target) && toggle.has(e.target).length === 0) {
            hikashop_cart.slideUp(200);
            toggle.parent().removeClass('active');
        }

        //search hide
        if (!$(".fa-search").is(e.target) && !$('.top-search-input-wrap').is(e.target) && !$('.top-search-input-wrap *').is(e.target) && toggle.has(e.target).length === 0) {
            $(".top-search-input-wrap").slideUp(200);
            $(".fa-times").hide();
            $('.fa-search').show();
            $(".top-search-input-wrap").removeClass('active');
        }

    });

    // Slideshow disaper and conflict with motools
    var carousel = jQuery('.carousel');
    if (carousel) {
        if (typeof jQuery != 'undefined' && typeof MooTools != 'undefined') {
            Element.implement({
                slide: function (how, mode) {
                    return this;
                }
            });
        }
    }

    // testimonial pro
    if ($('.sppb-testimonial-pro .sppb-item').length) {
        $('.sppb-testimonial-pro .sppb-item').each(function () {
            var next = $(this).next();
            if (!next.length) {
                next = $(this).siblings(':first');
            }
            next.children(':first-child').clone().appendTo($(this));

            if (next.next().length > 0) {
                next.next().children(':first-child').clone().appendTo($(this));
            } else {
                $(this).siblings(':first').children(':first-child').clone().appendTo($(this));
            }
        });
    }
    //Tooltip
    $('[data-toggle="tooltip"]').tooltip();

    // fix conflicting with mootools
    if (typeof MooTools != 'undefined' && MooTools) {
      var mHide = Element.prototype.hide;
      Element.implement({
         hide: function() {
            if ($('[data-toggle="tooltip"]').attr('itemprop')) {
               return this;
            }
            mHide.apply(this, arguments);
         }
      });
    }

    // rating
    $(document).on('click', '.sp-rating .star', function (event) {
        event.preventDefault();

        var data = {
            'action': 'voting',
            'user_rating': $(this).data('number'),
            'id': $(this).closest('.post_rating').attr('id')
        };

        var request = {
            'option': 'com_ajax',
            'plugin': 'helix3',
            'data': data,
            'format': 'json'
        };

        $.ajax({
            type: 'POST',
            data: request,
            beforeSend: function () {
                $('.post_rating .ajax-loader').show();
            },
            success: function (response) {
                var data = $.parseJSON(response.data);

                $('.post_rating .ajax-loader').hide();

                if (data.status == 'invalid') {
                    $('.post_rating .voting-result').text('You have already rated this entry!').fadeIn('fast');
                } else if (data.status == 'false') {
                    $('.post_rating .voting-result').text('Somethings wrong here, try again!').fadeIn('fast');
                } else if (data.status == 'true') {
                    var rate = data.action;
                    $('.voting-symbol').find('.star').each(function (i) {
                        if (i < rate) {
                            $(".star").eq(-(i + 1)).addClass('active');
                        }
                    });

                    $('.post_rating .voting-result').text('Thank You!').fadeIn('fast');
                }

            },
            error: function () {
                $('.post_rating .ajax-loader').hide();
                $('.post_rating .voting-result').text('Failed to rate, try again!').fadeIn('fast');
            }
        });
    });
});

//For react template
jQuery(function ($) {
    'use strict';
    var observer = new MutationObserver(function (mutations) {
        mutations.forEach(function (mutation) {
            var newNodes = mutation.addedNodes;
            if (newNodes !== null) {
                var $nodes = $(newNodes);
                $nodes.each(function () {
                    var $node = $(this);
                    $node.find('#slider').each(function () {

                        if ($('#carousel').is('.flexslider')) {
                            // Thumb Gallery
                            var $sppbTgOptions = $('.sppb-tg-slider');
                            // Autoplay
                            var $autoplay = $sppbTgOptions.data('sppb-tg-autoplay');
                            // arrows
                            var $arrows = $sppbTgOptions.data('sppb-tg-arrows');
                            $('#carousel').flexslider({
                                animation: 'slide',
                                controlNav: false,
                                directionNav: $arrows,
                                animationLoop: false,
                                slideshow: $autoplay,
                                minItems: 5,
                                move: 1,
                                itemWidth: 129,
                                itemMargin: 15,
                                asNavFor: '#slider'
                            });
                            $('#slider').flexslider({
                                animation: "fade",
                                controlNav: false,
                                directionNav: $arrows,
                                animationLoop: false,
                                slideshow: $autoplay,
                                sync: "#carousel"
                            });
                        }
                    });
                });
            }
        });
    });

    var config = {
        childList: true,
        subtree: true
    };
    // Pass in the target node, as well as the observer options
    observer.observe(document.body, config);
});


