<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2022 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined ('_JEXEC') or die('Restricted Access');

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Language\Text;

$facilities   = $displayData['facilities'];
$tags         = $displayData['tags'];

$app        = Factory::getApplication();
$input      = $app->input;
$city       = $input->get('city', NULL, 'WORD');
$sdate      = $input->get('sdate', NULL, 'STRING');
$min_price  = $input->get('min-price', NULL, 'INT');
$max_price  = $input->get('max-price', NULL, 'INT');

$features = $input->get('facilities', '', 'STRING');
if (!empty($features)) {
    $features = explode(',', implode(' ', $features));
}

$tagids = $input->get('tags', '', 'STRING');
if (!empty($tagids)) {
    $tagids = explode(',', $tagids);
}

$menuItemId = SpbookingHelper::getItemId('packages');
$menuItemId = str_replace("&Itemid=", "", $menuItemId);

$view_style = $input->get('view_style', 'grid');
$doc = Factory::getDocument();
$doc->addScript(Uri::root(true) . '/components/com_spbooking/assets/js/jquery.nicescroll.min.js');

?>
<aside class="spbooking-sidebar">
    <!-- /.spbooking-packages-filters-form -->
    <form id="spbooking-packages-filters-form" class="spbooking-packages-filters-form">
        <!-- <div class="spbooking-search-city-wrap spbooking-input-wrap">
            <label for="city"><?php //echo JText::_('COM_SPBOOKING_FILTER_CITY'); ?></label>
            <input id="spbooking-search-city-input" type="text" class="start-date form-control" name="city" placeholder="<?php //echo JText::_('COM_SPBOOKING_PLACEHOLDER_INSERT_CITY_NAME'); ?>" value="<?php //echo $city; ?>">
        </div> -->
        <div class="reserve-box">
            <input type="hidden" name="option" value="com_spbooking">
            <input type="hidden" name="view" value="packages">
            <input type="hidden" name="Itemid" value="<?php echo $menuItemId; ?>">
        </div>
        <!-- search by price range -->
        <div class="content-price-range mt-10 spbooking-input-wrap spbooking-ranger">
            <p class="price-range-title is-uppercase"><?php echo Text::_('COM_SPBOOKING_ACCOMODATIONS_FILTERING_PRICE_RANGE'); ?></p>
            <div id="price-range"></div>
            <input type="hidden" name="min-price" id="min-price" class="spbooking-ranger" value="<?php echo $min_price; ?>">
            <input type="hidden" name="max-price" id="max-price" class="spbooking-ranger" value="<?php echo $max_price; ?>">
        </div>

        <?php if(count((array)$facilities) ) { // Facilities ?>
            <div class="spbooking-search-facilities spbooking-input-wrap">
                <h4><?php echo Text::_('COM_SPBOOKING_PACKAGES_FILTER_FACILITIES'); ?></h4>
                <ul id="spbooking-filter-facilities" class="nicescrol">
                    <?php foreach ($facilities as $facility) { ?>
                        <li>
                            <label class="custom-checkbox" for="<?php echo $facility->id; ?>">
                                <input type="checkbox" id="<?php echo $facility->id; ?>" value="<?php echo $facility->id; ?>" name="facilities[]" <?php echo (!empty($features) && in_array($facility->id, $features) ? 'checked' : ''); ?> >
                                <span class="checkmark"><?php echo $facility->title; ?></span>
                            </label>
                        </li>
                    <?php } ?>
                </ul>
            </div> <!-- //.spbooking-category-search -->
        <?php } ?>

        <?php if(count((array)$tags) ) { // Tags ?>
            <div class="spbooking-search-tags spbooking-input-wrap">
                <h4><?php echo Text::_('COM_SPBOOKING_PACKAGES_FILTER_TAGS'); ?></h4>
                <ul id="spbooking-filter-tags spbooking-checkbox" class="nicescrol">
                    <?php foreach ($tags as $tag) { ?>
                        <li>
                            <label class="custom-checkbox" for="<?php echo $tag->id; ?>">
                                <input type="checkbox" id="<?php echo $tag->id; ?>" value="<?php echo $tag->id; ?>" name="tags[]" <?php echo (!empty($tagids) && in_array($tag->id, $tagids) ? 'checked' : ''); ?> >
                                <span class="checkmark"><?php echo $tag->title; ?></span>
                            </label>
                        </li>
                    <?php } ?>
                </ul>
            </div> <!-- //.spbooking-category-search -->
        <?php } ?>

        <div class="mt-10 spbooking-input-wrap">
            <button class="spbooking-btn spbooking-btn-primary" type="submit"><?php echo Text::_('COM_SPBOOKING_ACCOMODATIONS_FILTERING_SEARCH_BTN'); ?></button>
            <button class="btn btn-link reset-button" type="reset" data-url="option=com_spbooking&view=packages&view_style=<?php echo $view_style . SpbookingHelper::getItemId('packages'); ?>">Reset</button>
        </div>

    </form>
</aside>

