<?php

/**
* @package com_splms
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2018 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

// No Direct Access
defined ('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Helper\ModuleHelper;
use Joomla\CMS\Layout\LayoutHelper;

JHtml::_('jquery.framework');
$input = Factory::getApplication()->input;
$doc = Factory::getDocument();
$user = Factory::getUser();
$doc->addScriptdeclaration('var splms_url="'. Uri::base() .'index.php?option=com_splms";');

$course_sidebar = $doc->countModules('splms-course-sidebar');
?>

<div id="splms" class="splms view-splms-course course-details">
	<div class="splms-course">
		<div class="splms-row splms-course-short-info">
			<div class="splms-col-sm-4">
				<div class="course-thumbnail">
					<?php if (!empty($this->freeLesson) || (isset($this->video_link) && $this->video_link) ) { ?>
					<div class="lesson-video">
						<div id="splms-lesson-video-<?php echo $this->id; ?>" class="lesson-video">
							<?php if ($this->id == 'remote-host') { ?>
								<!-- player markup -->
								<div id="MainWrapper"></div>
								<div id="playlist_list">
									<!-- local tracks -->
									<div id="playlist" data-address="playlist">
										<div class="playlistNonSelected" data-address="local1" data-type="local" data-mp4="<?php echo $this->src; ?>" data-preview="<?php echo Uri::root() . $this->item->image; ?>" data-thumb="<?php echo Uri::root() . $this->item->image; ?>">
										</div>
									</div>

								</div>
							<?php } else{ ?>
							<div class="embed-responsive embed-responsive-16by9">
								<iframe src="<?php echo $this->src; ?>" width="100%" height="400" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>
							</div>
							<?php } ?>
						</div>
						<script> </script>
					</div>
					<?php } elseif($this->item->image) { ?>
						<div class="course-banner-img">
							<img class="splms-img-responsive" src="<?php echo $this->item->image; ?>" alt="<?php echo $this->item->title; ?>">
						</div>
					<?php } ?>

					<?php
					if ($this->item->price == 0) {
						echo '<span class="splms-badge-free">' . Text::_('COM_SPLMS_FREE') . '</span>';
					} ?>
				</div>
			</div>
			
			<div class="splms-col-sm-8">
				<!-- start course-header -->
				<div class="course-header clearfix">
					<div class="course-short-info">
						<h2 class="course-title">
							<?php echo $this->item->title; ?>
							</h2>
						<div class="short-description">
							<?php echo $this->item->short_description; ?>
						</div>
						<?php
							$this->item->generated_price = ($this->item->price == 0) ? Text::_('MOD_SPLMS_COURSES_FREE') : SplmsHelper::generateCurrency($this->item->price, $this->item->sale_price);
							$discount_percentage = '';
							if( ($this->item->price > $this->item->sale_price) && ($this->item->sale_price != '0.00' && $this->item->price != '0.00') ) {
								$discount_percentage = (($this->item->price - $this->item->sale_price)*100) /$this->item->price;
							}
						?>
						<ul class="course-main-info">
							<li><?php echo $this->item->duration; ?><span class="info-title"><?php echo Text::_('COM_SPLMS_COURSE_DURATION'); ?></span></li>
							<li><?php echo $this->item->level; ?><span class="info-title"><?php echo Text::_('COM_SPLMS_COURSE_SKILL_LEVEL'); ?></span></li>
							<li>
								<div class="price_info">
									<?php echo $this->coursePrice; ?> 
									<?php if (isset($discount_percentage) && $discount_percentage) {?>
										( <span class="splms-course-price-discount"><?php echo round($discount_percentage) . Text::_('MOD_SPLMS_COURSES_PERCENT_OFF'); ?></span> )
									<?php }?>
								</div>
								<span class="info-title"><?php echo Text::_('COM_SPLMS_COURSE_PRICE'); ?></span>
							</li>
							<li><?php echo HTMLHelper::_('date', $this->item->admission_deadline, 'DATE_FORMAT_LC3'); ?><span class="info-title"><?php echo JTEXT::_('COM_SPLMS_COURSE_ADMISSION_DEADLINE'); ?></span></li>

						</ul>
					</div>
				</div> <!-- end course-header -->
			</div>
		</div>
		
		<div class="splms-row">
			<div class="splms-col-sm-<?php echo $course_sidebar ? "8" : "12"; ?>">
				<?php if ($this->item->description) {?>
				<div class="splms-course-description">
					<?php //echo JHTML::_('content.prepare', $this->item->description);
					echo $this->item->description;
					?>
					</div>
				<?php }?>

			<?php if (isset($this->item->course_schedules) && $this->item->course_schedules && count($this->item->course_schedules) && $this->item->course_schedules) {?>
					<div class="splms-course-class-rotuines">
						<div class="splms-class-routines">
							<h3 class="splms-title"><?php echo Text::_('COM_SPLMS_CLASS_TIMES'); ?></h3>
							<table class="table table-bordered">
								<thead>
									<tr>
										<?php foreach ($this->schedule_days_lang as $schedule_day) {?>
											<th><?php echo $schedule_day; ?></th>
										<?php }?>
									</tr>
								</thead>
								<tbody>
									<tr>
										<?php foreach ($this->schedule_days as $schedule_day) {?>
											<td class="splms-class-routines-day-<?php echo $schedule_day; ?>">
												<?php if (!in_array($schedule_day, $this->hasdays)) {?>
													<div class="splms-class-routines-text no-schedule"></div>
												<?php }?>
												<?php foreach ($this->item->course_schedules as $course_schedule) {?>
													<?php if ($schedule_day == $course_schedule['day']) {?>
														<div class="splms-class-routines-text has-schedule">
															<?php echo $course_schedule['text']; ?>
														</div>
													<?php }?>
												<?php } // foreach course_schedules?>
											</td>
										<?php } //foreach schedule_days ?>
									</tr>
								</tbody>
							</table>
						</div>
					</div> <!-- //.splms-course-class-rotuines -->
				<?php }?>

				<!-- Has teacher -->
				<?php if (!empty($this->teachers)) {?>
					<div class="splms-course-teachers">
						<h3><?php echo Text::_('COM_SPLMS_MEET_OUR_COURSE_INSTRUCTOR'); ?></h3>
						<?php foreach ($this->teachers as $teacher) {?>
							<div class="splms-course-teacher d-flex">
								<a href="<?php echo $teacher->url; ?>" class="teacher-img-wrap"><img src="<?php echo $teacher->image; ?>" alt="<?php echo $teacher->title; ?>"></a>
								<div class="teacher-desc-wrap">
									<h4 class="teacher-title"><a href="<?php echo $teacher->url; ?>"><?php echo $teacher->title; ?></a></h4>
									<p class="teacher-designation"><?php echo $teacher->designation;?></p>
									<?php if ((!empty($teacher->social_facebook)) || (!empty($teacher->social_linkedin)) || (!empty($teacher->social_twitter)) ||  (!empty($teacher->social_gplus))) {
									?>

									<ul class="splms-persion-social-icons">
										<?php if (!empty($teacher->social_facebook)) {?>
										<li class="facebook">
											<a href="http://facebook.com/<?php echo $teacher->social_facebook; ?>" target="_blank">
												<i class="splms-icon-facebook"></i>
											</a>
										</li>
										<?php }if (!empty($teacher->social_linkedin)) {?>
										<li class="linkedin">
											<a href="http://linkedin.com/<?php echo $teacher->social_linkedin; ?>" target="_blank">
												<i class="splms-icon-linkedin"></i>
											</a>
										</li>
										<?php }if (!empty($teacher->social_twitter)) {?>
										<li class="twitter">
											<a href="http://twitter.com/<?php echo $teacher->social_twitter; ?>" target="_blank">
												<i class="splms-icon-twitter"></i>
											</a>
										</li>
										<?php }if (!empty($teacher->social_gplus)) {?>
										<li class="gplus">
											<a href="https://plus.google.com/<?php echo $teacher->social_gplus; ?>" target="_blank">
												<i class="splms-icon-google-plus"></i>
											</a>
										</li>
										<?php }?>
									</ul>
								<?php }?>
							</div>
							<div class="teacher-desc"><?php echo $teacher->description;?></div>
							</div>
						<?php }?>
					</div>
				<?php }?> <!-- END::  teacher -->
			</div> <!-- //.splms-col-sm-8 -->

			<?php if ($course_sidebar) {?>
			<div class="splms-col-sm-4">
				<div class="splms-course-sidebar">
				<?php
					jimport('joomla.application.module.helper');
					$modules = ModuleHelper::getModules('splms-course-sidebar');
					$attribs['style'] = 'sp_xhtml';

					foreach ($modules as $key => $module) {
						echo ModuleHelper::renderModule($module, $attribs);
					}
				?>
				</div>
			</div><!-- //.splms-col-sm-4 -->
			<?php }?>
		</div><!-- END::  splms-row -->

	    <?php if($this->show_related_courses){
		    if (isset($this->related_courses) && is_array($this->related_courses)) { ?>
		        <div class="splms-similar-courses">
		            <h3 class="splms-title"><?php echo Text::_('COM_SPLMS_SIMILAR_CLASSES'); ?></h3>
		            <div class="splms-courses-list splms">
		                <div class="splms-row">
		                    <?php foreach ($this->related_courses as $related_course) { ?>
		                        <div class="splms-col-sm-4">
		                            <div class="splms-course">
		                                <a href="#">
		                                    <img src="<?php echo $related_course->thumb; ?>" class="splms-course-img splms-img-responsive" alt="Yoga for Pregnants">
		                                </a>
		                                <div class="splms-content-wrap">
		                                    <h4 class="splms-course-title">
		                                        <a href="<?php echo $related_course->url; ?>"><?php echo $related_course->title; ?></a>
		                                    </h4>
		                                    <div class="splms-course-cat">
		                                        <?php echo $related_course->category_name; ?>
		                                    </div>
		                                    <div class="splms-course-time">
		                                        <?php echo $related_course->course_time; ?>
		                                    </div>
		                                    <div class="splms-course-details-btn">
		                                        <a href="<?php echo $related_course->url; ?>" class="btn btn-primary"><?php echo Text::_('COM_SPLMS_DETAILS'); ?></a>
		                                    </div>
		                                </div> <!-- /.splms-content-wrap -->
		                            </div> <!-- /.splms-course -->
		                        </div> <!-- //.splms-col-sm-4 -->
		                    <?php } ?>
		                </div> <!-- /.splms-row -->
		            </div><!-- //.splms-courses-list -->
		        </div> <!-- //.splms-similar-courses -->
		    <?php } ?>
	    <?php } ?>

	    <?php if($this->review){ ?>
		    <div class="clearfix"></div>
			<div class="user-reviews">
				<div class="reviews-menu">
					<div class="title-wrap">
						<h3 class="title"><?php echo Text::_('COM_SPLMS_REVIEWS'); ?></h3>
						<div class="myreviews-wrap">
							<ul class="list-inline list-style-none">
								<?php if($this->myReview) { ?>
									<li><a id="splms-my-review" class="btn btn-primary" href="#"><i class="splms-icon-write"></i> <?php echo Text::_('COM_SPLMS_EDIT_REVIEW'); ?></a></li>
								<?php } ?>

								<?php if($user->guest) { ?>
									<li><a href="<?php echo Route::_('index.php?option=com_users&view=login&return=' . base64_encode('index.php?option=com_splms&view=course&id=' . $this->item->id . ':' . $this->item->alias . SplmsHelper::getItemid('courses'))); ?>" class="btn btn-primary"><i class="fa fa-pencil-square-o"></i> <?php echo Text::_('COM_SPLMS_LOGIN_TO_REVIEW'); ?></a></li>
								<?php } ?>
							</ul>
						</div>
					</div>

					<div class="reviews-wrapper">
						<div class="reviews-status">
							<?php if(isset($this->ratings) && $this->ratings->count) {
								$rating = round($this->ratings->total/$this->ratings->count);
							} else {
								$rating = 0;
							} ?>
							<span class="total"><?php echo $rating; ?></span>
							<div class="sp-lms-rating ">
								<?php echo LayoutHelper::render('review.ratings', array('rating'=>$rating)); ?>
							</div>
							<p class="avg-rating"><?php echo Text::_('COM_SPLMS_REVIEW_AVARAGE_RATING'); ?></p>
						</div>
						<div class="total-reviews">
							<div class="sp-lms-rating ">
								<?php echo LayoutHelper::render('review.ratings', array('rating'=>$rating)); ?>
							</div>
							<?php echo round($rating / (5 / 100),2); ?>% <span class="total-review"><?php echo count($this->reviews); ?> Ratings</span>
						</div>
					</div>
				</div> <!--/.reviews-menu -->
				<div class="clearfix"></div>

				<?php echo LayoutHelper::render('review.form', array('review'=>$this->myReview, 'item_id'=>$this->item->id, 'url'=>'index.php?option=com_splms&view=course&id=' . $this->item->id . ':' . $this->item->alias . SplmsHelper::getItemid('courses'))); ?>

				<div id="reviews">
					<?php foreach ($this->reviews as $key => $this->review) {
						echo LayoutHelper::render('review.review', array('review'=>$this->review));
					} ?>
				</div>

				<?php if($this->showLoadMore) { ?>
					<a id="splms-load-review" class="btn btn-link btn-lg btn-block" data-item_id="<?php echo $this->item->id; ?>" href="#"><i class="fa fa-refresh"></i> <?php echo Text::_('COM_SPLMS_REVIEW_LOAD_MORE'); ?></a>
				<?php } ?>
			</div><!--/.user-reviews-->
		<?php } ?>

	</div>
</div>