<?php

/**
 * @package SP Page Builder
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2021 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */
// No direct access
defined('_JEXEC') or die('Restricted access');

class SppagebuilderAddonDonation extends SppagebuilderAddons {

    public function render() {
        $class = isset($this->addon->settings->class) ? $this->addon->settings->class : '';
        $title = isset($this->addon->settings->title) ? $this->addon->settings->title : '';
        $desc = isset($this->addon->settings->desc) ? $this->addon->settings->desc : '';
        $more = isset($this->addon->settings->more) ? $this->addon->settings->more : '';
        $paypalid = isset($this->addon->settings->paypalid) ? $this->addon->settings->paypalid : '';
        $currency = isset($this->addon->settings->currency) ? $this->addon->settings->currency : '';
        $target = isset($this->addon->settings->target) ? $this->addon->settings->target : '_blank';

        $crcy_code = explode(':', $currency);
        $currency_symbol = $crcy_code[1]; // Extract currency symbol
        $currency_code = $crcy_code[0]; // Extract currency code

        // Ensure PayPal ID is provided
        if (empty($paypalid)) {
            return '<p style="color: red; font-weight: bold;">⚠️ Error: PayPal ID is missing. Please configure it in the settings.</p>';
        }

        // Output
        $output = '';
        $output .= '<div class="sppb-addon sppb-addon-donation ' . $class . '">';

        if ($title) {
            $output .= '<h2 class="sppb-title-heading">' . $title . '</h2>';
        }

        if (!empty($desc)) {
            // Decode any HTML entities to ensure proper rendering
            $desc = html_entity_decode($desc);
        
            // Add donation-type-btn class to all buttons inside $desc
            $buttonIndex = 0; // Track button order to set the first one as active
            $desc = preg_replace_callback('/<button(.*?)>(.*?)<\/button>/i', function ($matches) use (&$buttonIndex) {
                $isActive = $buttonIndex === 0 ? ' active' : ''; // First button is active by default
                $buttonIndex++;
                return '<button class="donation-type-btn' . $isActive . '"' . $matches[1] . ' data-type="' . strtolower(trim(strip_tags($matches[2]))) . '">' . $matches[2] . '</button>';
            }, $desc);
        
            // Append hidden input field
            $desc .= '<input type="hidden" id="donation_type" value="">';
        
            // Render $desc inside the output
            $output .= '<h2 class="sppb-title-heading">' . $desc . '</h2>';
        }
        
        // JavaScript to handle button selection
        $output .= '<script>
            document.addEventListener("DOMContentLoaded", function () {
                var buttons = document.querySelectorAll(".donation-type-btn");
                var donationTypeInput = document.getElementById("donation_type");
        
                if (buttons.length > 0) {
                    donationTypeInput.value = document.querySelector(".donation-type-btn.active").getAttribute("data-type");
        
                    buttons.forEach(button => {
                        button.addEventListener("click", function () {
                            buttons.forEach(btn => btn.classList.remove("active"));
                            this.classList.add("active");
                            donationTypeInput.value = this.getAttribute("data-type");
                        });
                    });
                }
            });
        
            document.getElementById("donate_now").addEventListener("click", function(event) {
                event.preventDefault();
        
                var selectedAmount = document.querySelector(".preset-amount.active");
                var customAmount = document.getElementById("custom_donation") ? document.getElementById("custom_donation").value : "";
                var donationTypeInput = document.getElementById("donation_type");
                var donationType = donationTypeInput ? donationTypeInput.value : "";
        
                var amount = customAmount && customAmount > 0 ? customAmount : 
                             (selectedAmount ? selectedAmount.value.replace("$", "") : 0);
        
                if (amount > 0) {
                    var paypalUrl = "https://www.paypal.com/donate?business=' . $paypalid . '&currency_code=' . $currency_code . '&amount=" + amount;
        
                    if (donationType) {
                        paypalUrl += "&custom_donation_type=" + encodeURIComponent(donationType);
                    }
        
                    window.open(paypalUrl, "_blank");
                } else {
                    alert("Please select or enter a donation amount.");
                }
            });
        </script>';

        $output .= '<div class="donation-ammount-wrap" data-currency="' . $currency_code . '" data-pid="' . $paypalid . '">';

        // Predefined donation amounts
        $firstAmount = true;
        foreach ($this->addon->settings->sp_donation_item as $key => $donation) {
            $amountValue = htmlspecialchars($donation->amount, ENT_QUOTES, 'UTF-8');
            $activeClass = $firstAmount ? 'active' : ''; // Set first amount as active
            $output .= '<input class="donation-input preset-amount ' . $activeClass . '" type="text" name="amount" value="' . $currency_symbol . $amountValue . '" readonly>';
            $firstAmount = false;
        }

        // Custom donation amount input
        if ($more) {
            $output .= '<input class="donation-input input-text" type="number" id="custom_donation" name="custom_amount" autocomplete="off" placeholder="More" min="1">';
        }

        $output .= '</div>'; //.donation-ammount-wrap

        // Donation button
        $output .= '<div class="donation-button">';
        $output .= '<a href="#" target="' . $target . '" class="btn btn-primary donation-button-link" id="donate_now">' . JText::_('COM_SPPAGEBUILDER_ADDON_DONATE_NOW') . '</a>';
        $output .= '</div>'; //.donation-button

        $output .= '</div>'; //.sppb-addon-donation

        // JavaScript for handling PayPal redirection and button selection
        $output .= '<script>
            document.addEventListener("DOMContentLoaded", function() {
                var donationTypeInput = document.getElementById("donation_type");
                var donationButtons = document.querySelectorAll(".donation-type-btn");
                var donateNowButton = document.getElementById("donate_now");

                // Ensure first amount is preselected
                var firstAmount = document.querySelector(".preset-amount");
                if (firstAmount) {
                    firstAmount.classList.add("active");
                }

                // Donation Type Button Click Event
                donationButtons.forEach(function(btn) {
                    btn.addEventListener("click", function() {
                        donationButtons.forEach(function(el) { el.classList.remove("active"); });
                        this.classList.add("active");
                        donationTypeInput.value = this.getAttribute("data-type");
                    });
                });

                // Donation Amount Click Event
                document.querySelectorAll(".preset-amount").forEach(function(input) {
                    input.addEventListener("click", function() {
                        document.querySelectorAll(".preset-amount").forEach(function(el) { el.classList.remove("active"); });
                        this.classList.add("active");
                    });
                });

                // Donation Submit Button Click Event
                donateNowButton.addEventListener("click", function(event) {
                    event.preventDefault();

                    var selectedAmount = document.querySelector(".preset-amount.active");
                    var customAmount = document.getElementById("custom_donation").value;
                    var donationType = donationTypeInput.value;

                    // Determine the amount to donate
                    var amount = customAmount && customAmount > 0 ? customAmount : 
                                 (selectedAmount ? selectedAmount.value.replace("' . $currency_symbol . '", "") : 0);
                    
                    if (amount > 0) {
                        var paypalUrl = "https://www.paypal.com/donate?business=' . $paypalid . '&currency_code=' . $currency_code . '&amount=" + amount;
                        
                        // Add recurring donation if selected
                        if (donationType === "monthly") {
                            paypalUrl += "&recurring=1";
                        }

                        window.open(paypalUrl, "' . $target . '");
                    } else {
                        alert("Please select or enter a donation amount.");
                    }
                });
            });
        </script>';

        return $output;
    }
}