jQuery(function ($) {
    // Top Search
    $(".search-open-icon").on('click', function () {
        $(".top-search-input-wrap").fadeIn(200).addClass("search-open");
        $(this).hide();
        $('.search-close-icon').show().css('display', 'inline-block');
        $('body.off-canvas-menu-init').css({'overflow-y': 'hidden'});
        $('#sp-header').css({'z-index': '999'});
        setTimeout(function () {
            $('.rhino-top-search input').focus();
        }, 500);
    });

    $(".search-close-icon").on('click', function () {
        $(".top-search-input-wrap").fadeOut(200).removeClass("search-open");
        $('.search-close-icon').hide();
        $('.search-open-icon').show();
        $('body.off-canvas-menu-init').css({
            'overflow-y': 'initial'
        });
        $('#sp-header').css({'z-index': '99'});
    });
    $('.search-suggested-tag > ul > li > a').on('click', function (e) {
        e.preventDefault();
        $('.search-suggested-tag > ul > li > a.active').removeClass('active');
        $(this).addClass('active');
        var tagText = $(this).text().trim();
        $('.sp_search_input input').val(tagText).focus();
    });

    // press esc to hide search
    $(document).keyup(function (e) {
        if (e.keyCode == 27) { // esc keycode
            $(".top-search-input-wrap").fadeOut(200);
            $(".search-close-icon").fadeOut(200);
            $(".search-open-icon").delay(200).fadeIn(200);
            $('body.off-canvas-menu-init').css({'overflow-y': 'initial'});
        }
    });
    // End Top Search
});