<?php



/**
 * @package Salon
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2018 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

//no direct accees
defined('_JEXEC') or die('resticted access');
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;

class SppagebuilderAddonImage_slider extends SppagebuilderAddons {

    public function render() {

        $title = (isset($this->addon->settings->sp_image_slider_item->title) && $this->addon->settings->sp_image_slider_item->title) ? $this->addon->settings->sp_image_slider_item->title : '';
        $class = (isset($this->addon->settings->class) && $this->addon->settings->class) ? $this->addon->settings->class : '';

        $output = '';
        $output .= '<div class="sppb-addon sppb-addon-image-slider ' . $class . '">';

        if ($title) {
            $output .= '<div class=" sppb-addon-title-wrapper">';
            $output .= '<h3 class="sppb-addon-title">' . $title . '</h3>';
            $output .= '</div>';
        }

        //$output .= '<div class="phone-mockup"> <img src="templates/shaper_oneclip/images/mob-frame.png" /> </div>';

        $output .= '<div class="image-slider owl-carousel owl-theme">';
        foreach ($this->addon->settings->sp_image_slider_item as $key => $slide_item) {
            $output .= '<div class="item">';
            $output .= '<img alt="' . $title . '" src="' . Uri::root() . (is_string($slide_item->image) ? $slide_item->image : $slide_item->image->src) . '">';
            $output .= '</div>';
        }

        $output .= '</div>'; // .owl-carousel .owl-theme

        $output .= '</div>'; // .sppb-addon-image-slider

        return $output;
    }

    public function scripts() {
        $app = Factory::getApplication();
        $base_path = Uri::base() . '/templates/' . $app->getTemplate() . '/js/';
        return array($base_path . 'owl.carousel.min.js');
    }

    public function js() {
        return 'jQuery(document).ready(function($){"use strict";
            if ($(".image-slider").length) {
                $(".image-slider").owlCarousel({
                    loop: true,
                    nav: true,
                    margin: 30,
                    autoWidth: false,
                    mouseDrag: false,
                    navText: [\'<span class="fa fa-long-arrow-left"></span>\', \'<span class="fa fa-long-arrow-right"></span>\'],
                    autoplay: true,
                    responsive: {
                        0: {
                            items: 1
                        },
                        480: {
                            items: 3
                        },
                        996: {
                            items: 5
                        }
                    },
                    onInitialized: function() {
                        $(".owl-item.active").eq(1).addClass("active-one");
                        $(".owl-item.active").eq(2).addClass("active-two");
                        $(".owl-item.active").eq(3).addClass("active-three");
                        $(".owl-item.active").eq(4).addClass("active-four");
                    },
                    onTranslated: function() {
                        $(event.target).find(".active-one").removeClass("active-one");
                        $(event.target).find(".active-two").removeClass("active-two");
                        $(event.target).find(".active-three").removeClass("active-three");
                        $(event.target).find(".active-four").removeClass("active-four");
                        $(event.target).find(".active").eq(0).addClass("active-one");
                        $(event.target).find(".active").eq(1).addClass("active-two");
                        $(event.target).find(".active").eq(2).addClass("active-three");
                        $(event.target).find(".active").eq(3).addClass("active-four");
                    }
                });
            }
        });';
    }

    public function stylesheets() {
        $app = Factory::getApplication();
        $base_path = Uri::base() . '/templates/' . $app->getTemplate() . '/css/';
        return array($base_path . 'owl.carousel.css');
    }

    public static function getTemplate(){
        $output ='
        <# var title = (!_.isEmpty(data.title)) ? data.title : ""; #>
        <div class="sppb-addon sppb-addon-image-slider {{data.class}}">

        <div class="image-slider owl-carousel owl-theme">
        <# _.each (data.sp_image_slider_item, function(slide_item) { #>
            <div class="item">
            <img alt="{{{title}}}" src="' . Uri::root() . '/{{slide_item.image}}">
            </div>
        <# }); #>

        </div>

        </div>
        ';
        return $output;
    }

}
