<?php

/**
 * @package     Joomla.Site
 * @subpackage  mod_spmoviedb_search
 *
 * @copyright   Copyright (C) 2010 - 2022 JoomShaper. All rights reserved.
 * @license     GNU General Public License version 2 or later.
 */


// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;

$input = Factory::getApplication()->input;
$searchword = $input->get('searchword', '', 'STRING');
$searchtype = $input->get('type', '', 'STRING');

?>

<div id="mod_spmoviedb_search<?php echo $module->id; ?>" class="mod-spmoviedb-search moviedb_search <?php echo $params->get('moduleclass_sfx') ?>">
	<div class="input-group moviedb-search-wrap">
		<form id="moviedb-search">
			<div class="input-box">
				<input type="hidden" id="rooturl" name="rooturl" value="<?php echo Uri::root(); ?>">
				<input type="hidden" id="mid" name="rooturl" value="<?php echo SpmoviedbHelper::getItemid('movies'); ?>">
				<input type="hidden" id="cid" name="rooturl" value="<?php echo SpmoviedbHelper::getItemid('celebrities'); ?>">
				<input type="hidden" id="tid" name="rooturl" value="<?php echo SpmoviedbHelper::getItemid('trailers'); ?>">
				<input type="text" id="searchword" name="searchword" class="spmoviedb-search-input form-control" value="<?php echo $searchword; ?>" placeholder="<?php echo Text::_('MOD_SPMOVIEDBSEARCH_PLACEHOLDER'); ?>" autocomplete="off">
			</div>
			<span class="search-icon">
				<button type="submit" class="spmoviedb-search-submit">
					<span class="spmoviedb-search-icons">
						<i class="spmoviedb-icon-search"></i>
					</span>
				</button>
			</span>
		</form>
		<div class="spmoviedb-search-results"></div>
	</div>
</div>