<?php

/**
 * @package Finatic
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2019 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */
//no direct accees
defined('_JEXEC') or die('resticted access');

class SppagebuilderAddonFinatic_services extends SppagebuilderAddons {

    public function render() {
				$class = (isset($this->addon->settings->class) && $this->addon->settings->class) ? $this->addon->settings->class : '';
				$columns 		= (isset($this->addon->settings->columns) && $this->addon->settings->columns) ? $this->addon->settings->columns : 3;

				$grid_layout = isset($this->addon->settings->finatic_service_grid_layout) ? $this->addon->settings->finatic_service_grid_layout : '';
				$grid_layout_active = $grid_layout != '' ? 'gird-layout' : '';
				$output = '<div class="finatic-services '. $class . ' ' . $grid_layout_active . '">';
					if($this->addon->settings->finatic_service_carousel){
						$output .= '<div id="finatic-services-carousel" class="owl-carousel" data-carouselid="">';
					}
					if($grid_layout){
					$output .= '<div class="sppb-row">';
					}
						foreach ($this->addon->settings->finatic_service as $key => $service) {
							if($grid_layout){
						$output .= '<div class="sppb-col-6 sppb-col-12 sppb-col-sm-'. round(12/$columns) .'">';
							}
							$output .= '<div class="item">';
								$service_img = isset($service->finatic_service_image) ? $service->finatic_service_image : '';
								$service_title = isset($service->finatic_service_title) ? $service->finatic_service_title : '';
								$service_btn_content = isset($service->finatic_service_btn_content) ? $service->finatic_service_btn_content : '';
                                if(is_object($service_img)){
                                    $service_img = $service_img->src;
                                }
								if($service_img){

									$output .= '<img src="' . $service_img . '">';
								}
								$output .= '<div class="item-info">';
								if($service_title){
									$output .= '<h3>' . $service_title . '</h3>';
								}
								$output .= '<ul class="finatic-service-items">';
								foreach ($service->finatic_service_items as $key => $item) {
									$output .= '<li>';
										if($item->choose_option == 'image'){
											$output .= '<img src="' . $item->item_image . '">';
										} else if($item->choose_option == 'icon'){
											$output .= '<i class="fa ' . $item->item_icon . '"></i>';
										} else if($item->choose_option == 'custom_icon'){
											$output .= '<i class="' . $item->item_custom_icon . '"></i>';
										}
										$output .= '<p>' . $item->item_title . '</p>';
										if(isset($item->item_link) && $item->item_link){
											$output .= '<a href="'. $item->item_link .'" class="full-link"></a>';
										}
									$output .= '</li>';
								}
								$output .= '</ul>';
								if($service_btn_content){
									$output .= '<a class="sppb-btn sppb-btn-link" href="' . $service->finatic_service_button_url . '">' . $service_btn_content . '<i class="fn-next"></i></a>';
								}
								$output .= '</div>';
							$output .= '</div>';
							if($grid_layout){
						$output .= '</div>'; //col
							}
						}
					if($grid_layout){
					$output .= '</div>'; //row
					}
					if($this->addon->settings->finatic_service_carousel){
					$output .= '</div>';
					}
				$output .= '</div>';

        return $output;
    }

    public function scripts() {
        $app = JFactory::getApplication();
        $base_path = JURI::base() . '/templates/' . $app->getTemplate() . '/js/';
        return array($base_path . 'owl.carousel.min.js', $base_path . 'addon.slider.js');
    }

    public function js() {
        $addon_id = '#sppb-addon-' . $this->addon->id;
        return '
            jQuery(document).ready(function($){"use strict";

            $("' . $addon_id . ' #finatic-services-carousel").owlCarousel({
                margin: 30,
                loop: true,
                video:true,
                autoplay: true,
								dots: false,
								nav: true,
                autoplaySpeed: 800,
								navText: ["<i class=\"fa fa-angle-left\"></i>", "<i class=\"fa fa-angle-right\"></i>"],
                responsive: {
										0: {
											items: 1
										},
                    768: {
											items: 2
                    },
										999: {
											items: 3
                    },
										1800: {
											items: 4
                    }
                },
								onInitialized: function() {
										$(".owl-item.active").last().addClass("last-owl-active-item");
								},
								onTranslated: function() {
										$(event.target).find(".last-owl-active-item").removeClass("last-owl-active-item");
										$(event.target).find(".active").last().addClass("last-owl-active-item");
								}
            });
        });
        ';
    }

    public function stylesheets() {
        $app = JFactory::getApplication();
        $base_path = JURI::base() . '/templates/' . $app->getTemplate() . '/css/';
        return array($base_path . 'owl.carousel.min.css');
    }

    public static function getTemplate() {
        $output = '
					<# let grid_layout_active = data.finatic_service_grid_layout != "" ? "gird-layout" : ""; 
						 let columns =  Math.round(12/data.columns); console.log(columns);#>
					<div class="finatic-services {{data.class}} {{grid_layout_active}}">
						<# if(data.finatic_service_carousel){ #>
							<div id="finatic-services-carousel" class="owl-carousel">
						<# }
						if(data.finatic_service_grid_layout){ #>
						<div class="sppb-row">
						<# }
							_.each (data.finatic_service, function(service){ #>
								<# if(data.finatic_service_grid_layout){ #>
							<div class="sppb-col-sm-{{columns}}">
								<# } #>
								<div class="item">
									<# if(service.finatic_service_image){ #>
											<img src="{{typeof service.finatic_service_image.src !== "undefined" ? service.finatic_service_image.src : service.finatic_service_image}}">
									<# } #>
									<div class="item-info">
									<# if(service.finatic_service_title){ #>
											<h3>{{{service.finatic_service_title}}}</h3>
									<# } #>
									<ul class="finatic-service-items">
									<# _.each (service.finatic_service_items, function(item) { #>
										<li>
											<# if(item.choose_option == "image"){ #>
													<img src="{{item.item_image}}">
											<# } else if(item.choose_option == "icon"){ #>
													<i class="fa {{item.item_icon}}"></i>
											<# } else if(item.choose_option == "custom_icon"){ #>
													<i class="{{item.item_custom_icon}}"></i>
											<# } #>
											<p>{{{item.item_title}}}</p>
											<# if(item.item_link){ #>
												<a href="{{item.item_link}}" class="full-link"></a>
											<# } #>
										</li>
									<# }) #>
									</ul>
									<# if(service.finatic_service_btn_content){ #>
										<a class="sppb-btn sppb-btn-link" href="{{service.finatic_service_button_url}}">{{{service.finatic_service_btn_content}}}<i class="fn-next"></i></a>
									<# } #>
									</div>
								</div>
								<# if(data.finatic_service_grid_layout){ #>
								</div>
								<# } #>
							<# });
						if(data.finatic_service_grid_layout){ #>
						</div>
						<# }
						if(data.finatic_service_carousel){ #>
							</div>
						<# } #>
					</div>
					';
        return $output;
    }

}
