<?php
/**
 * @package     SP Simple Portfolio
 * @subpackage  mod_spsimpleportfolio
 *
 * @copyright   Copyright (C) 2010 - 2018 JoomShaper. All rights reserved.
 * @license     GNU General Public License version 2 or later.
 */

defined('_JEXEC') or die;
use Joomla\CMS\HTML\HTMLHelper;

HTMLHelper::_('jquery.framework');
HTMLHelper::_('bootstrap.framework');

jimport( 'joomla.filesystem.file' );
$layout_type = $params->get('layout_type', 'default');

?>

<div id="mod-sp-simpleportfolio<?php echo $module->id. '-' . str_replace(' ', '-', strtolower($module->title)); ?>" class="sp-simpleportfolio sp-simpleportfolio-view-items layout-<?php echo str_replace('_', '-', $layout_type); ?> <?php echo $moduleclass_sfx; ?>">

	<?php
		//Videos
		foreach ($items as $item) {
			if($item->video) {
				$video = parse_url($item->video);

				switch($video['host']) {
					case 'youtu.be':
					$video_id 	= trim($video['path'],'/');
					$video_src 	= '//www.youtube.com/embed/' . $video_id;
					break;

					case 'www.youtube.com':
					case 'youtube.com':
					parse_str($video['query'], $query);
					$video_id 	= $query['v'];
					$video_src 	= '//www.youtube.com/embed/' . $video_id;
					break;

					case 'vimeo.com':
					case 'www.vimeo.com':
					$video_id 	= trim($video['path'],'/');
					$video_src 	= "//player.vimeo.com/video/" . $video_id;
				}
				echo '<iframe class="sp-simpleportfolio-lightbox" src="'. $video_src .'" width="500" height="281" id="sp-simpleportfolio-video'.$item->spsimpleportfolio_item_id.'" style="border:none;" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>';
			}
		}
	?>
	
	<div id="spsimpleportfolio-slide<?php echo $module->id. '-' . str_replace(' ', '-', strtolower($module->title)); ?>" class="carousel slide" data-bs-ride="carousel">
		<!-- Indicators -->
		<div class="carousel-indicators">
			<?php for ($i=0; $i < $params->get('columns', 3); $i++) {
				$active = ($i == 0) ? 'class="active"' : ''; ?>
				<button type="button" data-bs-target="#spsimpleportfolio-slide<?php echo $module->id. '-' . str_replace(' ', '-', strtolower($module->title)); ?>" data-bs-slide-to="<?php echo $i; ?>"  <?php echo $active; ?> ></button>
			<?php } ?>
		</div>
		
		<div class="carousel-inner spsimpleportfolio-items" role="listbox">
			<?php foreach (array_chunk($items, $params->get('columns', 3)) as $chunk_key => $items) { ?>
			<?php $active = ($chunk_key == 0) ? 'active': '';?>
				<div class="carousel-item row <?php echo $active; ?>">
					<?php foreach ($items as $item) { ?>
						<div class="sp-simpleportfolio-item col-sm-<?php echo 12/$params->get('columns', 3); ?>">
							<div class="sp-simpleportfolio-item-wrap">
								<div class="sp-simpleportfolio-overlay-wrapper">
									<?php if($item->video) { ?>
										<span class="sp-simpleportfolio-icon-video"></span>
									<?php } ?>
									<img class="sp-simpleportfolio-img" src="<?php echo $item->thumb; ?>" alt="<?php echo $item->title; ?>">
								</div>
								<a href="<?php echo $item->url; ?>">
								<div class="sp-simpleportfolio-info">
									<div class="sp-simpleportfolio-title-wrap">
										<h5 class="sp-simpleportfolio-title">
												<?php echo $item->title; ?>
										</h5>
										<div class="sp-simpleportfolio-intro">
											<?php echo HTMLHelper::_('string.truncate', $item->description, 200); ?>
										</div>
									</div>
									<div class="sp-simpleportfolio-tags">
										<?php echo implode(', ', $item->tags); ?>
									</div>
								</div>
								</a>
							</div>
						</div>
					<?php } ?>
				</div> <!-- /.carousel-item -->
			<?php } ?>
		</div> <!-- /.carousel-inner -->

		<button class="carousel-control-prev" type="button" data-bs-target="#spsimpleportfolio-slide<?php echo $module->id. '-' . str_replace(' ', '-', strtolower($module->title)); ?>"  data-bs-slide="prev">
			<span class="carousel-control-prev-icon" aria-hidden="true"></span>
			<span class="visually-hidden">Previous</span>
		</button>
		<button class="carousel-control-next" type="button" data-bs-target="#spsimpleportfolio-slide<?php echo $module->id. '-' . str_replace(' ', '-', strtolower($module->title)); ?>"  data-bs-slide="next">
			<span class="carousel-control-next-icon" aria-hidden="true"></span>
			<span class="visually-hidden">Next</span>
		</button>
	</div> <!-- /.spsimpleportfolioSlide -->	

</div> <!--/#mod-sp-simpleportfolio -->