<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2022 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Helper\ModuleHelper;
use Joomla\CMS\Layout\LayoutHelper;

$top_review_limit = 5;

$modules = ModuleHelper::getModules('package-middle');

?>


<div id="spbooking" class="spbooking spbooking-view-package spbooking-view-details">
    <div class="package-details-top-wrapper">
        <!-- package details basic information -->
        <div class="spbooking-row spbooking-align-center">
            <div class="spbooking-col-12 spbooking-col-lg-6">
                <!-- package thumb -->
                <div class="spbooking-row spbooking-package-details-image-thumb">
                    <!-- rooms thumb -->
                    <div class="spbooking-col-12">
                        <?php echo LayoutHelper::render('gallery.gallery_2', array('gallery' => $this->item->gallery, 'title' => '', 'banner_image' => $this->item->image, 'modifier_class' => 'package-gallery')); ?>
                    </div>
                </div> <!-- /.spbooking-details-thumb -->
            </div>
            <div class="spbooking-col-12 spbooking-col-lg-6 spbooking-details-top-left">
                <p class="spbooking-title"><?php echo $this->item->title; ?></p>

                <div class="spbooking-title-bottom">
                    <?php if (!empty($this->item->start_date) && $this->item->start_date != '0000-00-00') { ?>
                        <div class="spbooking-details-date-wrap">
                            <span class="spbooking-details-start-date">
                                <div>
                                    <p><?php echo Text::_('COM_SPBOOKING_TIME_SPAN'); ?></p>
                                    <div class="spbooking-package-details-time-wrap">
                                        <span class="text-mute"><?php echo date('d M Y', strtotime($this->item->start_date)); ?></span>
                                        <?php if (!empty($this->item->end_date) && $this->item->end_date != '0000-00-00') { ?>
                                            -
                                            <span class="spbooking-details-end-date text-mute">
                                                <?php echo date('d M Y', strtotime($this->item->end_date)); ?>
                                            </span>
                                        <?php } ?>
                                    </div>
                                </div>
                            </span>
                        </div>
                    <?php } ?>
                </div> <!-- /.spbooking-title-bottom -->

                <!-- Major Activities -->
                <div class="spbooking-major-activities">

                    <!-- CUSTOM BLOCK START -->
                    <?php if (!empty($this->item->custom)) : ?>
                        <div class="spbooking-details-custom">
                            <?php foreach ($this->item->custom as $custom) : ?>
                                <?php if (!empty($custom->key) || !empty($custom->value)) : ?>
                                    <div class="spbooking-custom-item">

                                        <?php if (!empty($custom->key)) : ?>
                                            <div class="spbooking-custom-title">
                                                <h4><?php echo $custom->key; ?></h4>
                                            </div>
                                        <?php endif; ?>

                                        <?php if (!empty($custom->value)) : ?>
                                            <div class="spbooking-custom-description">
                                                <p><?php echo nl2br($custom->value); ?></p>
                                            </div>
                                        <?php endif; ?>

                                    </div>
                                <?php endif; ?>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                    <!-- CUSTOM BLOCK END -->

                    <?php if (!empty($this->item->major_activities)) { ?>
                        <div class="spbooking-details-major-activities">
                            <?php foreach ($this->item->major_activities as $major_activity) { ?>
                                <div class="spbooking-major-activities-item">
                                    <div class="spbooking-major-activities-media-type">
                                        <?php if (!empty($major_activity->icon_image)) {
                                            if ($major_activity->icon_image == 'icon') { ?>
                                                <i class="<?php echo $major_activity->icon ?> major-activities-icon"></i>
                                            <?php } elseif ($major_activity->icon_image == 'image') { ?>
                                                <img src="<?php echo Uri::root() . $major_activity->image; ?>" alt="" class="major-activities-image">
                                        <?php }
                                        }   ?>
                                    </div>
                                    <div class="spbooking-major-activities-title">
                                        <span><?php echo $major_activity->key; ?></span>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                    <?php } ?>
                </div>
                <!-- / Major Activities -->

                <div class="spbooking-package-details-price-wrap">
                    <div class="spbooking-top-left-bottom">
                        <?php if (!empty($this->item->is_available)) { ?>
                            <a href="<?php echo Uri::root() . ('index.php?option=com_spbooking&view=checkout&layout=package&checkout_for=package&package_id=' . $this->item->id); ?>" class="spbooking-btn spbooking-btn-primary spbooking-btn"><?php echo Text::_('COM_SPBOOKING_COMMON_BOOK_NOW'); ?></a>
                        <?php } else { ?>
                            <button class="spbooking-btn spbooking-btn-primary"><?php echo Text::_('COM_SPBOOKING_COMMON_BOOK_NOW'); ?></button><br>
                            <small class="text-danger"><?php echo Text::_('COM_SPBOOKING_PACKAGE_NOT_AVAILABLE'); ?></small>
                        <?php } ?>
                    </div> <!-- /.spbooking-top-right-bottom  -->
                    <?php if (!empty($this->item->price) && $this->item->price != 0.00) { ?>
                        <div class="spbooking-price-box text-right">
                            <?php if (!empty($this->item->sale_price) && $this->item->sale_price != 0.00) { ?>
                                <div class="original-price">
                                    <del class="text-mute">
                                        <?php echo SpbookingHelper::formatPrice($this->item->price, $this->item->currency, $this->item->currency_type, $this->item->currency_position); ?>
                                    </del>
                                </div>
                                <div class="sale-price">
                                    <span>
                                        <?php echo SpbookingHelper::formatPrice($this->item->sale_price, $this->item->currency, $this->item->currency_type, $this->item->currency_position); ?>
                                    </span> / <?php echo Text::_('COM_SPBOOKING_COMMON_PERSON'); ?>
                                </div>
                            <?php } else { ?>
                                <div class="sale-price">
                                    <span>
                                        <?php echo SpbookingHelper::formatPrice($this->item->price, $this->item->currency, $this->item->currency_type, $this->item->currency_position); ?>
                                    </span> / <?php echo Text::_('COM_SPBOOKING_COMMON_PERSON'); ?>
                                </div>
                            <?php } ?>
                        </div>
                    <?php } ?>
                </div> <!-- /.spbooking-col-3 -->
            </div> <!-- /.spbooking-col-6 -->
        </div>
    </div>

    <div class="spbooking-container package-details-bottom-wrapper">
        <!-- package overview -->
        <div class="spbooking-row spbooking-details-overview mt-preset">

            <?php // generate columns
            if (!empty($this->item->certificates) && $this->item->certificates && count((array)$this->item->certificates) == 1) {
                $left_col = 6;
                $right_col = 3;
                $review_col = 3;
            } else {
                $left_col = 9;
                $right_col = 3;
                $review_col = 12;
            }
            ?>

            <!-- package description -->
            <div class="spbooking-col-md-12 spbooking-col-lg-12">
                <h4 class="overview is-uppercase"><?php echo Text::_('COM_SPBOOKING_PACKAGE_DETAILS_OVERVIEW_TITLE'); ?></h4>
                <?php if (!empty($this->item->description)) { ?>
                    <div class="description"><?php echo $this->item->description; ?></div>
                <?php } ?>
            </div>

            <?php if (!empty($this->item->certificates) && $this->item->certificates && count((array)$this->item->certificates) == 1) { ?>
                <!-- oscars -->
                <div class="spbooking-col-md-6 spbooking-col-lg-<?php echo $review_col; ?> spbooking-item-certificates">
                    <div class="package-award">
                        <div class="spbooking-box">
                            <?php foreach ($this->item->certificates as $certificate) { ?>
                                <img src="<?php echo $certificate->image; ?>" alt="<?php echo $certificate->name; ?>">
                            <?php } ?>
                        </div>
                    </div>
                </div><!-- /.spbooking-col- -->
            <?php } ?>
        </div> <!-- /.spbooking-row -->

        <?php if (!empty($this->item->certificates) && $this->item->certificates && count((array)$this->item->certificates) > 1) { ?>
            <!-- package overview -->
            <div class="spbooking-row spbooking-item-certificates">
                <?php foreach ($this->item->certificates as $certificate) { ?>
                    <div class="spbooking-col-sm-3 mt-20">
                        <img src="<?php echo $certificate->image; ?>" alt="<?php echo $certificate->name; ?>">
                    </div>
                <?php } ?>
            </div> <!-- /.spbooking-row -->
        <?php } ?>

        <!-- package include  -->
        <div class="spbooking-row spbooking-package-inc-exc mt-preset">
            <?php if (!empty($this->item->includes) && $this->item->includes) { ?>
                <div class="spbooking-col-md-6 spbooking-package-includes-wrap">
                    <ul class="spbooking-package-includes mt-30">
                        <?php foreach ($this->item->includes as $include) { ?>
                            <?php if (!empty($include->key)) { ?>
                                <li>
                                    <?php if (!empty($include->icon_image)) { ?>
                                        <?php if ($include->icon_image == 'icon') { ?>
                                            <span class="<?php echo !empty($include->icon) ? $include->icon : 'fa fa-check-square-o'; ?> text-green"></span>
                                        <?php } else { ?>
                                            <?php if (!empty($include->image)) { ?>
                                                <img class="icon-image" src="<?php echo $include->image; ?>" alt="">
                                            <?php } ?>
                                        <?php } ?>
                                    <?php } ?>
                                    <?php echo " " . $include->key; ?>
                                </li>
                            <?php } ?>

                        <?php } ?>
                    </ul>
                </div>
            <?php } ?>

            <!-- package excludes -->
            <?php if (!empty($this->item->excludes) && $this->item->excludes) { ?>
                <div class="spbooking-col-md-6 spbooking-package-excludes-wrap">
                    <ul class="spbooking-package-excludes mt-30">
                        <?php foreach ($this->item->excludes as $exclude) { ?>
                            <?php if (!empty($exclude->key)) { ?>
                                <li>
                                    <?php if (!empty($exclude->icon_image)) { ?>
                                        <?php if ($exclude->icon_image == 'icon') { ?>
                                            <span class="<?php echo !empty($exclude->icon) ? $exclude->icon : 'fa fa-times-circle-o'; ?> text-red"></span>
                                        <?php } else { ?>
                                            <?php if (!empty($exclude->image)) { ?>
                                                <img class="icon-image" src="<?php echo $exclude->image; ?>" alt="">
                                            <?php } ?>
                                        <?php } ?>
                                    <?php } ?>
                                    <?php echo " " . $exclude->key; ?>
                                </li>
                            <?php } ?>
                        <?php } ?>
                    </ul>
                </div>
            <?php } ?>

        </div> <!-- /.spbooking-package-inc-exc -->

        <!-- tour overview -->
        <div class="spbooking-row tour-overview">
            <?php if (!empty($this->item->overview)) { ?>
                <div class="tour-overview-details">
                    <div class="spbooking-row">
                        <?php foreach ($this->item->overview as $overview) { ?>
                            <div class="spbooking-col-md-6">
                                <div class="package-overview-holder">
                                    <div class="icon-image-wrap">
                                        <?php if (!empty($overview->icon_image)) { ?>
                                            <?php if ($overview->icon_image == 'icon') { ?>
                                                <span class="text-green <?php echo $overview->icon; ?> fa-2x"></span>
                                            <?php } else { ?>
                                                <img src="<?php echo $overview->image; ?>" alt="">
                                            <?php } ?>
                                        <?php } ?>
                                    </div>
                                    <div class="text-wrap">
                                        <?php if (!empty($overview->key)) { ?>
                                            <h4 class=""><?php echo $overview->key; ?></h4>
                                        <?php } ?>
                                        <?php if (!empty($overview->value)) { ?>
                                            <p class="text-mute"><?php echo $overview->value; ?></p>
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            <?php } ?>
        </div>


        <!-- Daywise Tour Activities -->
        <!-- Daywise Tour Activities -->
        <div class="spbooking-row tour-activities mt-preset">
            <div class="spbooking-col-12">
                <h4 class="itenary-title is-uppercase"><?php echo Text::_('COM_SPBOOKING_PACKAGE_ITENARY_TITLE'); ?></h4>
                <?php if (!empty($this->item->activities)) { ?>
                    <!-- activity nav links -->
                    <div class="itenary-tab">
                        <ul class="nav nav-pills mt-20 itenary-nav">
                            <?php $i = 0; ?>
                            <?php foreach ($this->item->activities as $key => $activity) { ?>
                                <li class="nav-item">
                                    <a class="nav-link text-mute <?php echo $i == 0 ? 'active' : ''; ?>" data-trigger="<?php echo '#day-' . $key; ?>" href="javascript:"><?php echo Text::sprintf('COM_SPBOOKING_ACTIVITIES_DAY_N', $key); ?></a>
                                    <!-- Show Date -->
                                    <?php foreach ($activity as $day) {
                                        if ($day->date) { ?>
                                            <div class="nav-link spbooking-activity-content-date">
                                                <?php echo $day->date; ?>
                                            </div>
                                    <?php break;
                                        }
                                    } ?>
                                </li>
                            <?php $i++;
                            }
                            $i = 0; ?>
                        </ul>

                        <!-- activity content -->
                        <div class="itenary-panel">
                            <?php foreach ($this->item->activities as $key => $days) { ?>
                                <div class="spbooking-activity-content <?php echo $i == 0 ? 'show' : ''; ?>" id="day-<?php echo $key; ?>">
                                    <ul>
                                        <?php foreach ($days as $index => $activity) { ?>
                                            <li class="activity-container">
                                                <div class="left-box">
                                                    <!-- left marker style would be here -->
                                                </div>
                                                <div class="activity-box">
                                                    <div class="time-slot text-mute">
                                                        <?php if (!empty($activity->time)) { ?>
                                                            <?php if (!empty($activity->icon_image)) {
                                                                if ($activity->icon_image == 'icon') { ?>
                                                                    <i class="<?php echo $activity->icon ?> activity-time-icon"></i>
                                                                <?php } elseif ($activity->icon_image == 'image') { ?>
                                                                    <img src="<?php echo Uri::root() . $activity->image; ?>" alt="" class="activity-time-image">
                                                            <?php }
                                                            }   ?>
                                                            <span class=""><?php echo $activity->time; ?></span>
                                                        <?php } ?>
                                                    </div>
                                                    <?php if (!empty($activity->desc)) { ?>
                                                        <p class="activity-desc"><?php echo $activity->desc; ?></p>
                                                    <?php } ?>
                                                </div>
                                            </li>
                                        <?php } ?>
                                    </ul>
                                </div>
                            <?php $i++;
                            } ?>
                        <?php } ?>
                        </div>
                    </div>
            </div>
        </div>
    </div>


    <!-- package gallery -->
    <div class="spbooking-row spbooking-details-image mt-preset">
        <!-- rooms gallery -->
        <div class="spbooking-col-12">
            <?php echo LayoutHelper::render('gallery.gallery', array('gallery' => $this->item->gallery, 'title' => '', 'banner_image' => $this->item->image, 'modifier_class' => 'package-gallery')); ?>
        </div>
    </div> <!-- /.spbooking-details-gallery -->

    <div class="spbooking-row package-details-gallery-bottom-wrap">
        <?php if (!empty($this->item->custom)) { ?>
            <div class="spbooking-container spbooking-details-custom">
                <?php foreach ($this->item->custom as $custom) { ?>
                    <div class="spbooking-custom-item">
                        <div class="spbooking-custom-title">
                            <h4><?php echo $custom->key; ?></h4>
                        </div>
                        <div class="spbooking-custom-description">
                            <p><?php echo $custom->value; ?></p>
                        </div>
                    </div>
                <?php } ?>
            <?php } ?>
            </div>
    </div>

    <div class="spbooking-container">
        <?php foreach ($modules as $module) { ?>
            <?php echo ModuleHelper::renderModule($module, array('style' => 'sp_xhtml')); ?>
        <?php } ?>
    </div>



    <div class="spbooking-container">
        <!-- user comments -->
        <div class="spbooking-row accomodation-user-comments">
            <div class="spbooking-col-12">
                <label class="user-comments-title is-uppercase"><?php echo Text::_('COM_SPBOOKING_PACKAGE_USER_COMMENTS') . " (" . $this->item->reviews['total_reviews'] . ")"; ?></label>
                <?php if (!empty($this->item->reviews['reviews'])) { ?>
                    <ul class="user-comment-list list-group">
                        <?php foreach ($this->item->reviews['reviews'] as $comment) { ?>
                            <li class="user-comment-item list-group-item">
                                <div class="comment-header">
                                    <img class="img-round" src="<?php echo Uri::root() . 'components/com_spbooking/assets/images/default.png'; ?>" alt="">
                                    <p class='user-name'><?php echo $comment->user_name; ?></p>
                                    <small class="comment-date text-mute"><?php echo HTMLHelper::_('date', $comment->created, 'jS M, Y'); ?></small>
                                </div>
                                <?php if (!empty($comment->review)) { ?>
                                    <div class="comment-body mt-10">
                                        <p><?php echo $comment->review; ?></p>
                                    </div>
                                <?php } ?>

                                <?php if (!empty($comment->inner_rating)) { ?>
                                    <?php foreach (range(1, 5) as $index) { ?>
                                        <?php if ($index <= $comment->inner_rating) { ?>
                                            <span class="fa fa-star is-filled"></span>
                                        <?php } else if ($index > $comment->inner_rating && $comment->inner_rating > $index - 1) { ?>
                                            <span class="fa fa-star-half-o is-filled"></span>
                                        <?php } else { ?>
                                            <span class="fa fa-star-o"></span>
                                        <?php } ?>
                                    <?php } ?>
                                    <strong><?php echo $comment->inner_rating; ?></strong>
                                <?php } ?>

                            </li>
                        <?php } ?>
                    </ul>
                <?php } ?>
            </div>
        </div>

        <!-- give feedback form -->
        <!-- if review enabled -->
        <?php if (!empty($this->cParams->get('review', 1))) { ?>
            <!-- if guest review disabled -->
            <?php if ($this->cParams->get('guest_review', 0) == 0) { ?>
                <!-- if user logged in -->
                <?php if (Factory::getUser()->id > 0) { ?>
                    <div class="spbooking-row user-feedback">
                        <div class="spbooking-col-sm-12">
                            <label class="give-feedback-title is-uppercase"><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_USER_FEEDBACK_TITLE'); ?></label>
                            <form action="#" class="feedback-form" id="feedback-form">
                                <div class="feedback-first-formgroup">
                                    <div class="form-group overall-rating">
                                        <label for=""><?php echo Text::_('Overall Rating'); ?></label>

                                        <?php foreach (range(1, 5) as $index) { ?>
                                            <?php if ($index <= $this->item->reviews['average_rating']) { ?>
                                                <span class="fa fa-star is-filled"></span>
                                            <?php } else if ($index > $this->item->reviews['average_rating'] && $this->item->reviews['average_rating'] > $index - 1) { ?>
                                                <span class="fa fa-star-half-o is-filled"></span>
                                            <?php } else { ?>
                                                <span class="fa fa-star-o"></span>
                                            <?php } ?>
                                        <?php } ?>
                                    </div>

                                    <div class="form-group">
                                        <label for=""><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_USER_FEEDBACK_RATING'); ?></label>
                                        <ul class="review-categories-list">
                                            <li class="review-list-item">
                                                <span><?php echo Text::_('COM_SPBOOKING_REVIEW_SAFETY_SECURITY'); ?></span>
                                                <div class="safty-security"></div>
                                            </li>
                                            <li class="review-list-item">
                                                <span><?php echo Text::_('COM_SPBOOKING_REVIEW_MAINTENANCE'); ?></span>
                                                <div class="maintenance"></div>
                                            </li>
                                            <li class="review-list-item">
                                                <span><?php echo Text::_('COM_SPBOOKING_REVIEW_CLEANLINESS'); ?></span>
                                                <div class="cleanliness"></div>
                                            </li>
                                            <li class="review-list-item">
                                                <span><?php echo Text::_('COM_SPBOOKING_REVIEW_SERVICE'); ?></span>
                                                <div class="service"></div>
                                            </li>
                                            <li class="review-list-item">
                                                <span><?php echo Text::_('COM_SPBOOKING_REVIEW_HOSPITALITY'); ?></span>
                                                <div class="hospitality"></div>
                                            </li>
                                        </ul>
                                    </div>

                                    <div class="form-group">
                                        <label for=""><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_USER_FEEDBACK'); ?></label>
                                        <textarea name="review" id="feedback" cols="10" rows="7" class="form-control"></textarea>
                                    </div>
                                </div>

                                <div class="feedback-second-formgroup">
                                    <div class="form-row form-group">
                                        <label for=""><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_USER_FEEDBACK_PERSONAL_INFO'); ?></label>
                                        <div class="group-row">
                                            <div class="row">
                                                <input type="hidden" name="user_name" value="<?php echo Factory::getUser()->name; ?>">
                                                <input type="hidden" name="user_email" value="<?php echo Factory::getUser()->email; ?>">
                                                <div class="col">
                                                    <div class="reserve-box">
                                                        <input type="hidden" name="package_id" value="<?php echo $this->item->id; ?>">
                                                        <input type="hidden" name="review_for" value="package">
                                                    </div>

                                                    <div class="form-group submit-button-wrap">
                                                        <button type="submit" class="spbooking-btn spbooking-btn-primary is-uppercase"><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_SUBMIT_FEEDBACK'); ?></button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                            </form>
                        </div>
                    </div>
                <?php } else {  ?>
                    <p class="login-message">
                        <?php $link =  base64_encode(Route::_('index.php?option=com_spbooking&view=package&id=' . $this->item->id  . SpbookingHelper::getItemid('packages'))); ?>
                        <?php $login_link = Route::_('index.php?option=com_users&view=login' . SpbookingHelper::getItemid('login') . '&return=' . $link); ?>
                        <?php echo Text::sprintf('COM_SPBOOKING_LOGIN_FOR_FEEDBACK', $login_link); ?>
                    </p>
                <?php } ?>
            <?php } else { ?>
                <!-- if guest review allowed -->
                <div class="spbooking-row user-feedback">
                    <div class="spbooking-col-sm-12">
                        <label class="give-feedback-title is-uppercase"><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_USER_FEEDBACK_TITLE'); ?></label>
                        <form action="#" class="feedback-form" id="feedback-form">
                            <div class="feedback-first-formgroup">
                                <div class="form-group overall-rating">
                                    <label for=""><?php echo Text::_('Overall Rating'); ?></label>

                                    <?php foreach (range(1, 5) as $index) { ?>
                                        <?php if ($index <= $this->item->reviews['average_rating']) { ?>
                                            <span class="fa fa-star is-filled"></span>
                                        <?php } else if ($index > $this->item->reviews['average_rating'] && $this->item->reviews['average_rating'] > $index - 1) { ?>
                                            <span class="fa fa-star-half-o is-filled"></span>
                                        <?php } else { ?>
                                            <span class="fa fa-star-o"></span>
                                        <?php } ?>
                                    <?php } ?>
                                </div>

                                <div class="form-group">
                                    <label for=""><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_USER_FEEDBACK_RATING'); ?></label>
                                    <ul class="review-categories-list">
                                        <li class="review-list-item">
                                            <span><?php echo Text::_('COM_SPBOOKING_REVIEW_SAFETY_SECURITY'); ?></span>
                                            <div class="safty-security"></div>
                                        </li>
                                        <li class="review-list-item">
                                            <span><?php echo Text::_('COM_SPBOOKING_REVIEW_MAINTENANCE'); ?></span>
                                            <div class="maintenance"></div>
                                        </li>
                                        <li class="review-list-item">
                                            <span><?php echo Text::_('COM_SPBOOKING_REVIEW_CLEANLINESS'); ?></span>
                                            <div class="cleanliness"></div>
                                        </li>
                                        <li class="review-list-item">
                                            <span><?php echo Text::_('COM_SPBOOKING_REVIEW_SERVICE'); ?></span>
                                            <div class="service"></div>
                                        </li>
                                        <li class="review-list-item">
                                            <span><?php echo Text::_('COM_SPBOOKING_REVIEW_HOSPITALITY'); ?></span>
                                            <div class="hospitality"></div>
                                        </li>
                                    </ul>
                                </div>

                                <div class="form-group">
                                    <label for=""><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_USER_FEEDBACK'); ?></label>
                                    <textarea name="review" id="feedback" cols="10" rows="7" class="form-control"></textarea>
                                </div>
                            </div>

                            <div class="feedback-second-formgroup">
                                <div class="form-row form-group">
                                    <label for=""><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_USER_FEEDBACK_PERSONAL_INFO'); ?></label>
                                    <div class="group-row">
                                        <div class="row">
                                            <?php if (Factory::getUser()->id > 0) { ?>
                                                <input type="hidden" name="user_name" value="<?php echo Factory::getUser()->name; ?>">
                                                <input type="hidden" name="user_email" value="<?php echo Factory::getUser()->email; ?>">
                                            <?php } else { ?>
                                                <div class="col-md-6">
                                                    <input type="text" class="form-control" name="user_name" required="required" placeholder="<?php echo Text::_('COM_SPBOOKING_ACCOMODATION_USER_NAME'); ?>">
                                                </div>
                                                <div class="col-md-6">
                                                    <input type="email" class="form-control" name="user_email" required="required" placeholder="<?php echo Text::_('COM_SPBOOKING_ACCOMODATION_USER_EMAIL'); ?>">
                                                </div>
                                            <?php } ?>
                                            <div class="col">
                                                <div class="reserve-box">
                                                    <input type="hidden" name="package_id" value="<?php echo $this->item->id; ?>">
                                                    <input type="hidden" name="review_for" value="package">
                                                </div>

                                                <div class="form-group submit-button-wrap">
                                                    <button type="submit" class="spbooking-btn spbooking-btn-primary is-uppercase"><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_SUBMIT_FEEDBACK'); ?></button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                        </form>
                    </div>
                </div>
            <?php } ?>
        <?php } ?>
    </div>
</div>