<?php
/**
* @package com_spmedical
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2023 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

// No Direct Access
defined ('_JEXEC') or die('Restricted Access');

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\MVC\Model\BaseDatabaseModel;
use Joomla\CMS\MVC\Controller\FormController;

class SpmedicalControllerAppointments extends FormController
{

	public function getModel($name = 'form', $prefix = '', $config = array('ignore_request' => true))
	{
		$model = parent::getModel($name, $prefix, $config);

		return $model; 
	}

	public function submit()
	{
		
		// Load Lessons model
		BaseDatabaseModel::addIncludePath(JPATH_SITE.'/components/com_spmedical/models');
		$specialists_model 	= BaseDatabaseModel::getInstance( 'Specialists', 'SpmedicalModel' );
		$appointments_model = BaseDatabaseModel::getInstance( 'Appointments', 'SpmedicalModel' );

		$input 		= Factory::getApplication()->input;
		$mail  		= Factory::getMailer();

		$user 		= Factory::getUser();
		$user_id 	= $user->id;
		
		$choose_patient 			= $input->post->get('choose_patient', NULL, 'INT');
		$patient_name 				= $input->post->get('patient_name', NULL, 'STRING');
		$date_of_birth 				= $input->post->get('date_of_birth', NULL, 'STRING');
		$patient_gender 			= $input->post->get('patient_gender', NULL, 'STRING');
		$specialist_id 				= $input->post->get('specialist_id', NULL, 'INT');
		$specialist_name            = $input->post->get('specialist_name', NULL, 'STRING');
		$department_id 				= $input->post->get('department_id', NULL, 'INT');
		$patient_phone 				= $input->post->get('patient_phone', NULL, 'STRING');
		$patient_email				= $input->post->get('patient_email', NULL, 'STRING');
		$patient_address_street		= $input->post->get('patient_address_street', NULL, 'STRING');
		$patient_address_city		= $input->post->get('patient_address_city', NULL, 'STRING');
		$patient_address_state		= $input->post->get('patient_address_state', NULL, 'STRING');
		$patient_address_zip_code	= $input->post->get('patient_address_zip_code', NULL, 'INT');
		$appointment_date 			= $input->post->get('appintment_date', NULL, 'STRING');
		$patient_note 				= $input->post->get('patient_note', NULL, 'STRING');
		$visiting_option			= $input->post->get('visiting_option', NULL, 'STRING');
		$showcaptcha 				= $input->post->get('showcaptcha', NULL, 'INT');

		$output = array();
		$output['status'] = false;
		$output['content'] = '';

		$params    = ComponentHelper::getParams('com_spmedical');
		$adminMail = $params->get('email_address');
		
		if($showcaptcha)
		{
			PluginHelper::importPlugin('captcha');
			$res = Factory::getApplication()->triggerEvent('onCheckAnswer');

			if(!$res[0])
			{
				$output['content'] = Text::_('COM_SPMEDICAL_RECAPTCHA_INVALID_CAPTCHA');
				echo json_encode($output);
				die();
			}
		}

		$specialist_info =  '';
		$department_id 	 = '';
		if ($specialist_id)
		{
			$specialist_info	= $specialists_model->getSpecialist($specialist_id);
			$specialist_name    = $specialist_info->title;
			$specialist_email 	= $specialist_info->email;
			$department_id		= $specialist_info->department_id;
		}

		//message body
		$visitorip      = isset($_SERVER['HTTP_X_FORWARDED_FOR']) ? $_SERVER['HTTP_X_FORWARDED_FOR'] : $_SERVER['REMOTE_ADDR'];
		
		// get site name 
		$site_name 		= isset($_SERVER['SERVER_NAME']) ? $_SERVER['SERVER_NAME'] : '';
		$subject 		= 'You have an appointment request from ' . ' Email Address: ' . $patient_email . ' - ' . $site_name;

		if ( $appointment_no = $appointments_model->insertAppointment($patient_name, $patient_phone, $patient_email, $appointment_date, $patient_note, $specialist_id, $department_id, $user_id, $visitorip, $choose_patient, $date_of_birth, $patient_gender, $patient_address_street, $patient_address_city, $patient_address_state, $patient_address_zip_code, $visiting_option) )
		{
			
			$msg  = '';
			$msg .= '<span>Appointment ID : ' . $appointment_no .'</span><br />';
			$msg .= '<span>Specialist Name: ' . $specialist_name .'</span><br />';
			$msg .= '<span>Patient Name : ' . $patient_name .'</span><br />';
			$msg .= '<span>Patient Phone : ' . $patient_phone .'</span><br />';
			$msg .= '<span>Patient Email : ' . $patient_email .'</span><br />';
			if($date_of_birth) {
				$msg .= '<span>Date Of Birth : ' . $date_of_birth .'</span><br />';
			}
			if($patient_address_street || $patient_address_city || $patient_address_state || $patient_address_zip_code) {
				$msg .= '<span>Address : ' . $patient_address_street ? $patient_address_street . ' , ' : ('' . $patient_address_city ? $patient_address_city . ' , ' : ('' . $patient_address_state ? $patient_address_state . ' , ' : ('' . $patient_address_state ? $patient_address_state . ' , ' : '' . $patient_address_zip_code .'</span><br />')));
			}
			if($visiting_option) {
				$msg .= '<span>Visiting Type : ' . $visiting_option .'</span><br />';
			}
			$msg .= '<span>Appointment Date : ' . $appointment_date .'</span><br />';
			if($patient_note) {
				$msg .= '<span>Patient Note : ' . $patient_note .'</span><br />';
			}
			$msg .= '<span>Sender IP : ' . $visitorip .'</span>';

			// Sent email
			$sender = array($patient_email, $patient_name);
			$mail->setSender($sender);
			$mail->addRecipient($specialist_email);
			$mail->setSubject($subject);
			$mail->isHTML(true);
			$mail->Encoding = 'base64';
			$mail->setBody($msg);


			$output['appointment_id'] = '';
			if ($mail->Send()) {
				$output['status'] = true;
				$output['content'] = Text::_('COM_SPMEDICAL_SPECIALIST_APPOINTMENT_SUCCESS') . ' <strong>' .$appointment_no . '<strong>';
				$output['appointment_id'] = $appointment_no;
				// Mail will sent to the email address added in configuration.
				($adminMail) ? $mail->addAddress($adminMail) . $mail->Send() : '';
			} else {
				$output['content'] = Text::_('COM_SPMEDICAL_SPECIALIST_APPOINTMENT_ERROR');
			}
		}
		echo json_encode($output);
		die();
	}
	
}
