<?php
/**
* @package com_spmedical
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2022 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/


// No Direct Access
defined ('_JEXEC') or die('Restricted Access');

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\PluginHelper;

$doc 	= Factory::getDocument();
$input  = Factory::getApplication()->input;
$doc->addStylesheet( Uri::root(true) . '/components/com_spmedical/assets/css/bootstrap-datepicker3.css' );

$doc->addScript( Uri::root(true) . '/components/com_spmedical/assets/js/jquery-ui.js' );
$doc->addScript( Uri::root(true) . '/components/com_spmedical/assets/js/bootstrap-datepicker.min.js' );

$specialistid       = $input->get('specialistid', '', 'INT');
?>

<div id="spmedical" class="spmedical view-spmedical-appointments spmedical-appointments">
	<!-- spmedical specialists Appointment(for details page) -->
	<div class="spmedical-specialist-appointment">
		<div class="img-wrap"></div>
		<div class="spmedical-specialist-appointment-form">
			<h3><?php echo Text::_('COM_SPMEDICAL_MAKE_AN_APPOINTMENT'); ?></h3>
			<form id="spmedical-specialist-appintment-from" class="spmedical-specialist-appintment spmedial-suggest-fields">
				<div class="spmedical-row spmedical-mb-3">
					<?php if($this->choose_patient) { ?>
						<div class="spmedical-col-auto">
							<div class="spmedical-mb-2 spmedical-mr-2">
								<?php echo text::_('COM_SPMEDICAL_FIELD_CHOOSE_PATIENT');?>
							</div>
							
							<div class="btn-group" role="group">
								<input type="radio" class="btn-check" name="choose_patient" id="choose-patient-yes" autocomplete="off" value="1" checked>
								<label class="btn btn-outline-primary" for="choose-patient-yes"><?php echo text::_('JYES');?></label>
			
								<input type="radio" class="btn-check" name="choose_patient" id="choose-patient-no" value="0" autocomplete="off">
								<label class="btn btn-outline-primary" for="choose-patient-no"><?php echo text::_('JNO');?></label>
							</div>
						</div>
					<?php } ?>

					<div class="spmedical-col">
						<div class="input-field">
							<label for="patient-name"><?php echo text::_('COM_SPMEDICAL_FIELD_PATIENT_NAME');?></label>
							<input type="text" id="patient-name" name="patient_name" required="true" autocomplete="off">
						</div>
					</div>
					
					<div class="spmedical-col-auto">
						<div class="spmedical-mb-2">
							<?php echo text::_('COM_SPMEDICAL_FIELD_GENDER');?>
						</div>
						
						<div class="btn-group" role="group">
							<input type="radio" class="btn-check" name="patient_gender" id="genderMale" autocomplete="off" checked value="m" required="true">
							<label class="btn btn-outline-primary" for="genderMale"><?php echo text::_('COM_SPMEDICAL_FIELD_GENDER_MALE');?></label>
		
							<input type="radio" class="btn-check" name="patient_gender" id="genderFemale" autocomplete="off" value="f" required="true">
							<label class="btn btn-outline-primary" for="genderFemale"><?php echo text::_('COM_SPMEDICAL_FIELD_GENDER_FEMALE');?></label>
						</div>
					</div>
				</div>
				
				<div class="spmedical-row spmedical-mb-3">
					<div class="spmedical-col">
						<div class="input-field">
							<label for="date-of-birth"><?php echo text::_('COM_SPMEDICAL_FIELD_PATIENT_DATE_OF_BIRTH');?></label>
							<input type="date" id="date-of-birth" name="date_of_birth" placeholder="<?php echo text::_('COM_SPMEDIAL_APPOINTMENT_PH_DATE'); ?>" required="true" autocomplete="off">
						</div>
					</div>

					<div class="spmedical-col">
						<div class="input-field">
							<label for="phone"><?php echo text::_('COM_SPMEDICAL_FIELD_PATIENT_PHONE');?></label>
							<input type="text" id="phone" name="patient_phone" required="true">
						</div>
					</div>
				</div>

				
				<div class="spmedical-row spmedical-mb-3">
					<div class="spmedical-col">
						<div class="input-field">
							<label for="email"><?php echo text::_('COM_SPMEDIAL_APPOINTMENT_PH_PATIENT_EMAIL');?></label>
							<input type="text" id="email" name="email" placeholder="<?php echo text::_('COM_SPMEDIAL_APPOINTMENT_PH_PATIENT_EMAIL'); ?>" required="true">
						</div>
					</div>

					<?php if($this->appointments_address) { ?>
					<div class="spmedical-col">
						<div class="spmedical-mb-2">
							<?php echo text::_('COM_SPMEDICAL_FIELD_PATIENT_ADDRESS');?>
						</div>
		
						<div class="input-field">
							<input type="text" id="patient_address_street" name="patient_address_street" placeholder="<?php echo text::_('COM_SPMEDICAL_FIELD_PATIENT_ADDRESS_STREET_HINT'); ?>">
						</div>
					</div>
					<?php } ?>
				</div>
				
				<?php if($this->appointments_address) { ?>
				<div class="spmedical-row spmedical-mb-3">
					<div class="spmedical-col">
						<div class="input-field">
							<input type="text" id="patient_address_city" name="patient_address_city" placeholder="<?php echo text::_('COM_SPMEDICAL_FIELD_PATIENT_ADDRESS_CITY_HINT'); ?>">
						</div>
					</div>
					<div class="spmedical-col">
						<div class="input-field">
							<input type="text" id="patient_address_state" name="patient_address_state" placeholder="<?php echo text::_('COM_SPMEDICAL_FIELD_PATIENT_ADDRESS_STATE_HINT'); ?>">
						</div>
					</div>
					<div class="spmedical-col">
						<div class="input-field">
							<input type="text" id="patient_address_zip_code" name="patient_address_zip_code" placeholder="<?php echo text::_('COM_SPMEDICAL_FIELD_PATIENT_ADDRESS_ZIP_CODE_HINT'); ?>">
						</div>
					</div>
				</div>
				<?php } ?>
				
				<div class="spmedical-row">
					<div class="spmedical-col">
						<div class="input-item">
							<label for="spmedical-departments"><?php echo text::_('COM_SPMEDICAL_FIELD_PRIMARY_CONCERN');?></label>
							<select id="spmedical-departments" class="spmedical-combobox spmedical-appointment-combobox" require="true">
								<option disabled selected><?php echo text::_('COM_SPMEDICAL_FIELD_SELECTED_CHOOSE');?></option>
								<?php foreach ($this->departments as $department) { ?>
									<option value="<?php echo $department->id; ?>"><?php echo $department->title; ?></option>
								<?php } ?>
							</select>
						</div>
					</div>

					<div class="spmedical-col">
						<div class="input-item">
							<label for="spmedical-specialists"><?php echo text::_('COM_SPMEDICAL_FIELD_PATIENT_CHOOSE_DOCTOR');?></label>
							<select id="spmedical-specialists" class="spmedical-combobox spmedical-appointment-combobox">
								<option <?php echo ($specialistid == '') ? 'selected' : '';?>><?php echo text::_('COM_SPMEDICAL_FIELD_SELECTED_CHOOSE');?></option>
								<?php foreach ($this->specialists as $specialist) { ?>
									<option <?php echo ($specialistid == $specialist->id) ? 'selected' : '';?> value="<?php echo $specialist->id; ?>"><?php echo $specialist->title; ?></option>
								<?php } ?>
							</select>
						</div>
					</div>
					<input type="hidden" id="specialist_id" name="specialist_id" value="">
					<input type="hidden" id="department_id" name="department_id" value="">
				</div>
				
				<?php if($this->patient_note) { ?>
				<div class="input-field">
					<label for="patient_note"><?php echo text::_('COM_SPMEDICAL_FIELD_PATIENT_APPOINTMENT_NOTE');?></label>
					<textarea name="patient_note" id="patient_note" placeholder="<?php echo text::_('COM_SPMEDIAL_APPOINTMENT_PH_NOTE'); ?>" cols="30" rows="5"></textarea>
				</div>
				<?php } ?>
				
				<div class="input-field">
					<label for="appintment_date"><?php echo text::_('COM_SPMEDICAL_FIELD_PATIENT_APPOINTMENT_DATE');?></label>
					<input type="date" id="appintment_date" name="appintment_date" placeholder="<?php echo text::_('COM_SPMEDICAL_FIELD_PATIENT_APPOINTMENT_DATE'); ?>" required="true" autocomplete="off">
				</div>
				
				<?php if($this->visiting_option) { ?>
				<div class="spmedical-mb-2">
					<?php echo text::_('COM_SPMEDICAL_FIELD_SELECT_VISITING_OPTION');?>
				</div>
				<div class="btn-group" role="group">
					<input type="radio" class="btn-check" name="visiting_option" id="physical-visit" autocomplete="off" value="physical-visit" checked>
					<label class="btn btn-outline-primary" for="physical-visit"><?php echo text::_('COM_SPMEDICAL_FIELD_SELECT_VISITING_OPTION_PHYSICAL_VISIT');?></label>

					<input type="radio" class="btn-check" name="visiting_option" id="online-visit" autocomplete="off" value="online-visit">
					<label class="btn btn-outline-primary" for="online-visit"><?php echo text::_('COM_SPMEDICAL_FIELD_SELECT_VISITING_OPTION_ONLINE_VISIT');?></label>
				</div>
				<?php } ?>

				<input type="hidden" id="showcaptcha" name="showcaptcha" value="<?php echo $this->captcha; ?>">
				<?php if($this->captcha) { ?>
					<div class="input-field">
						<?php
							PluginHelper::importPlugin('captcha', 'recaptcha');
				
							$app = Factory::getApplication();
							$app->triggerEvent('onInit', ['dynamic_recaptcha_spmedical']);
							$recaptcha = $app->triggerEvent('onDisplay', array(null, 'dynamic_recaptcha_spmedical', 'class="spmedical-dynamic-recaptcha"'));
							
							echo (isset($recaptcha[0])) ? $recaptcha[0] : '<p class="spmedical-text-danger">' . Text::_('COM_SPMEDICAL_CAPTCHA_NOT_INSTALLED') . '</p>';
						?>
					</div>
				<?php } ?>

				<?php if($this->appointment_tac && $this->appointment_tac_text) { ?>
					<div class="input-field">
						<label class="custom-checkbox">
							<input type="checkbox" id="tac" name="tac" value="tac" required="true" data-apptac="true">
							<span class="checkbox-text">
								<?php echo $this->appointment_tac_text; ?>
							</span>
						</label>
					</div>
				<?php } ?>

				<div class="input-field spmedical-text-center">
					<button type="submit" id="appointment-submit" class="spmedical-btn spmedical-btn-primary"><?php echo Text::_('COM_SPMEDICAL_REQUEST_APPOINTMENT');?></button>
				</div>
			</form>
			<div class="spmedical-appointment-status"></div>
		</div>
	</div> <!-- //.end specialist appointment -->
</div> <!-- /#spmedical -->