
<?php

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
/**
* @package    	Joomla.Site
* @subpackage 	com_spsoccer
* @author 		JoomShaper support@joomshaper.com
* @copyright 	Copyright (c) 2010 - 2022 JoomShaper <https://www.joomshaper.com>. All rights reserved.
* @license     	GNU General Public License version 2 or later; see http://www.gnu.org/licenses/gpl-2.0.html
*/

// No Direct Access
defined ('_JEXEC') or die('Restricted Access');


$doc = JFactory::getDocument();
$tpl_params = JFactory::getApplication()->getTemplate(true)->params;

?>
<div id="spsoccer" class="spsoccer view-spsoccer-player">
	<div class="spsoccer-player">

		<div class="spsoccer-row">
			<div class="spsoccer-player-basic spsoccer-col-md-6">
				<div class="spsoccer-player-basic-info-wrap">
					<div class="spsoccer-player-title-wrap">
						<h3 class="spsoccer-player-title"><?php echo $this->item->title; ?></h3>
						<span class="spsocer-player-kit-number"><?php echo $this->item->squad_no; ?></span>
					</div>
					<div class="spsoccer-player-img-wrap">
						<img class="splms-img-responsive" src="<?php echo $this->item->image; ?>" alt="<?php echo $this->item->title; ?>">
					</div>
				</div>

				<div class="spsoccer-player-basic-info-bottom-wrap">
					<ul>
						<?php if($this->item->total_matches){ ?>
						<li>
							<span class="spsoccer-item-title"><?php echo Text::_('COM_SOSOCCER_PLAYER_MATCHES'); ?>: </span>
							<span><?php echo $this->item->total_matches; ?></span>
						</li>
						<?php } ?>
						<?php if($this->item->total_goals){ ?>
						<li>
							<span class="spsoccer-item-title"><?php echo Text::_('COM_SOSOCCER_PLAYER_GOALS'); ?>: </span>
							<span><?php echo $this->item->total_goals; ?></span>
						</li>
						<?php } ?>
						<?php if($this->item->passing){ ?>
						<li>
							<span class="spsoccer-item-title"><?php echo Text::_('COM_SOSOCCER_PLAYER_PASSING'); ?>: </span>
							<span><?php echo $this->item->passing; ?></span>
						</li>
						<?php } ?>
					</ul>
				</div>

				<div class="tournament-header">
					<div class="spsoccer-player-info-wrap">
						<div class="spsoccer-player-career">
							<ul class="spsoccer-player-info-list spsoccer-ul-list">
								
							</ul>
						</div>
						<div class="spsoccer-player-social-profile">
							<ul>
								<?php if (!empty($this->item->facebook)) { ?>
									<li><a href="<?php echo $this->item->facebook ?>" target="_blank">
										<i class="sp-soccer-facebook"></i>
									</a></li>
								<?php } if (!empty($this->item->twitter)) { ?>
									<li><a href="<?php echo $this->item->twitter ?>" target="_blank">
										<i class="sp-soccer-twitter"></i>
									</a></li>
								<?php } if (!empty($this->item->linkedin)) { ?>
									<li><a href="<?php echo $this->item->linkedin ?>" target="_blank">
										<i class="sp-soccer-linkedin"></i>
									</a></li>
								<?php } if (!empty($this->item->g_plus)) { ?>
									<li><a href="<?php echo $this->item->g_plus ?>" target="_blank">
										<i class="sp-soccer-google-plus"></i>
									</a></li>
								<?php } if (!empty($this->item->youtube)) { ?>
									<li><a href="<?php echo $this->item->youtube ?>" target="_blank">
										<i class="sp-soccer-youtube"></i>
									</a></li>
								<?php } ?>
							</ul>
						</div>

					</div>
				</div>
			</div> <!-- /.spsoccer-col-md -->

			<div class="torunament-info spsoccer-col-md-6">

				<div class="spsoccer-player-career-wrap">
					<div>
						<h3><?php echo Text::_('COM_SOSOCCER_PLAYER_FULL_OVERVIEW'); ?></h3>
	
						<div class="spsoccer-player-career-list-wrap">
							<ul class="spsoccer-player-career-list">
								<?php if($this->item->dob != '0000-00-00'){ ?>
								<li>
									<span class="spsoccer-item-title"><?php echo Text::_('COM_SOSOCCER_PLAYER_DOB'); ?>: </span>
									<span><?php echo HTMLHelper::date($this->item->dob, 'F j\<\s\u\p\>S\<\/\s\u\p\>, Y'); ?></span>
								</li>
								<?php } ?>
	
								<?php if($this->item->birth_place){?>
								<li>
									<span class="spsoccer-item-title"><?php echo Text::_('COM_SOSOCCER_PLAYER_BIRTH_PLACE'); ?>: </span>
									<span><?php echo $this->item->birth_place; ?></span>
								</li>
								<?php } ?>
	
								<?php if($this->item->height){?>
								<li>
									<span class="spsoccer-item-title"><?php echo Text::_('COM_SOSOCCER_PLAYER_HEIGHT'); ?>: </span>
									<span><?php echo $this->item->height; ?> cm</span>
								</li>
								<?php } ?>

								<?php if($this->item->weight){?>
								<li>
									<span class="spsoccer-item-title"><?php echo Text::_('COM_SOSOCCER_PLAYER_WEIGHT'); ?>: </span>
									<span><?php echo $this->item->weight; ?> Kg</span>
								</li>
								<?php } ?>
	
								<?php if($this->item->position){?>
								<li>
									<span class="spsoccer-item-title"><?php echo Text::_('COM_SOSOCCER_PLAYER_POSITION'); ?>: </span>
									<span><?php echo $this->item->position; ?></span>
								</li>
								<?php } ?>
	
								<?php if($this->item->description){?>
								<li>
									<span class="spsoccer-item-title"><?php echo Text::_('COM_SOSOCCER_PLAYER_OVERVIEW'); ?>: </span>
									<span><?php echo $this->item->description; ?></span>
								</li>
								<?php } ?>
							</ul>
						</div>  <!-- /.spsoccer-player-career-list-wrap -->
					</div>
				</div>
			</div> <!-- /.spsoccer-col-md -->

		</div> <!-- /.spsoccer-row -->

	</div> <!-- /.spsoccer-player -->


	<?php if ($doc->countModules('position2')) { ?>
		<div class="player-details-bottom">
			<?php
				jimport('joomla.application.module.helper');
				$modules = JModuleHelper::getModules('position2');
				$attribs = array('style'=>'sp_xhtml');
				foreach ($modules as $key => $module) {
					echo JModuleHelper::renderModule($module, $attribs);
				}
			?>
		</div>  <!-- /.player-details-bottom -->
	<?php } ?> <!-- // END:: key condition -->











</div> <!-- /#spsoccer .spsoccer -->

