"use strict";

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

(function ($) {
	"use strict";
	// if( typeof addonInteraction === 'undefined')
	//     return
	/*
  * ====================
  * INTERACTION MATH
  * ====================
  */

	function InteractionMath(animationProperty) {
		this.actions = animationProperty;
		this.actionProperty = ["move", "rotate", "scale", "skew", "opacity", "blur"];
		this.actionSortList = {};
	}
	InteractionMath.prototype.bindCustomAnimation = function () {
		var _this = this;

		this.actionProperty.map(function (ActionName) {
			_this.actionSortList[ActionName] = _this.actions.filter(function (action) {
				return action.name === ActionName;
			});
		});
	};
	InteractionMath.prototype.getCustomAnimationActionByName = function (actionName) {
		var keyframe = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;

		if (keyframe === null) {
			return typeof this.actionSortList[actionName] !== "undefined" ? this.actionSortList[actionName] : [];
		} else {
			var animation = { from: null, to: null };
			var actions = typeof this.actionSortList[actionName] !== "undefined" ? this.actionSortList[actionName] : [];

			if (actions.length === 0) {
				return animation;
			}
			var found = false;
			actions.map(function (action, index) {
				if (keyframe < parseInt(action.keyframe) && animation.to === null) {
					if (typeof animation.fixed !== "undefined") delete animation.fixed;
					action.toKF = 0;
					animation.to = action;
					if (typeof actions[index - 1] !== "undefined") {
						actions[index - 1].scroll = 0;
						animation.from = actions[index - 1];
					}
					found = true;
				}
				if (index === actions.length - 1 && found === false) {
					animation.fixed = true;
					animation.to = action;
					if (typeof actions[index - 1] !== "undefined") {
						actions[index - 1].scroll = 0;
						animation.from = actions[index - 1];
					}
				}
			});
			return animation;
		}
	};
	InteractionMath.prototype.getTAxis = function (from, to, scrollPercentage, combinedPercentage) {
		var toKF = combinedPercentage.toKF,
		    fromKF = combinedPercentage.fromKF;

		var tf = fromKF === 0 ? scrollPercentage : scrollPercentage - fromKF;
		return from - (from - to) / toKF * tf;
	};

	InteractionMath.prototype.getMoveTransform = function (key, nextTriggerActions, scrollPercentage) {
		var keyframe = nextTriggerActions.to.keyframe;
		var Fkeyframe = nextTriggerActions.from.keyframe;
		var toKF = isNaN(keyframe) ? 100 : Math.abs(Fkeyframe - keyframe);
		var combinedPercentage = { toKF: toKF, fromKF: Fkeyframe, totalKF: keyframe };

		var Xfrom = nextTriggerActions.from.x;
		var Xto = nextTriggerActions.to.x;
		var Yfrom = nextTriggerActions.from.y;
		var Yto = nextTriggerActions.to.y;
		var Zfrom = nextTriggerActions.from.z;
		var Zto = nextTriggerActions.to.z;
		nextTriggerActions.goal.x = this.getTAxis(Xfrom, Xto, scrollPercentage, combinedPercentage);
		nextTriggerActions.goal.y = this.getTAxis(Yfrom, Yto, scrollPercentage, combinedPercentage); //IM.getTAxis(Yfrom, Yto, scrollPercentage, combinedPercentage)
		nextTriggerActions.goal.z = this.getTAxis(Zfrom, Zto, scrollPercentage, combinedPercentage);
		return nextTriggerActions;
	};
	InteractionMath.prototype.getSkew = function (key, nextTriggerActions, scrollPercentage) {
		var keyframe = nextTriggerActions.to.keyframe;
		var Fkeyframe = nextTriggerActions.from.keyframe;
		var toKF = isNaN(keyframe) ? 100 : Math.abs(Fkeyframe - keyframe);

		var combinedPercentage = { toKF: toKF, fromKF: Fkeyframe, totalKF: keyframe };
		var Xfrom = nextTriggerActions.from.x;
		var Xto = nextTriggerActions.to.x;
		var Yfrom = nextTriggerActions.from.y;
		var Yto = nextTriggerActions.to.y;
		nextTriggerActions.goal.x = this.getTAxis(Xfrom, Xto, scrollPercentage, combinedPercentage);
		nextTriggerActions.goal.y = this.getTAxis(Yfrom, Yto, scrollPercentage, combinedPercentage);
		return nextTriggerActions;
	};
	InteractionMath.prototype.getOpacity = function (key, nextTriggerActions, scrollPercentage) {
		var keyframe = nextTriggerActions.to.keyframe;
		var Fkeyframe = nextTriggerActions.from.keyframe;
		var toKF = isNaN(keyframe) ? 100 : Math.abs(Fkeyframe - keyframe);

		var combinedPercentage = { toKF: toKF, fromKF: Fkeyframe, totalKF: keyframe };
		var Ofrom = nextTriggerActions.from.value;
		var Oto = nextTriggerActions.to.value;
		nextTriggerActions.goal.value = this.getTAxis(Ofrom, Oto, scrollPercentage, combinedPercentage);
		return nextTriggerActions;
	};

	var MouseTilt = function () {
		function MouseTilt(element) {
			var settings = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

			_classCallCheck(this, MouseTilt);

			this.width = null;
			this.height = null;
			this.clientWidth = null;
			this.clientHeight = null;
			this.left = null;
			this.top = null;

			// for Gyroscope sampling
			this.gammazero = null;
			this.betazero = null;
			this.lastgammazero = null;
			this.lastbetazero = null;

			this.transitionTimeout = null;
			this.updateCall = null;
			this.event = null;

			this.updateBind = this.update.bind(this);
			this.resetBind = this.reset.bind(this);

			this.element = element;

			this.settings = this.extendSettings(settings);

			this.reverse = this.settings.reverse ? -1 : 1;
			this.glare = MouseTilt.isSettingTrue(this.settings.glare);
			this.glarePrerender = MouseTilt.isSettingTrue(this.settings["glare-prerender"]);
			this.fullPageListening = MouseTilt.isSettingTrue(this.settings["full-page-listening"]);
			this.gyroscope = MouseTilt.isSettingTrue(this.settings.gyroscope);
			this.gyroscopeSamples = this.settings.gyroscopeSamples;

			this.elementListener = this.getElementListener();

			// this.wrapWithParent();

			if (this.glare) {
				this.prepareGlare();
			}

			if (this.fullPageListening) {
				this.updateClientSize();
			}

			this.addEventListeners();
			this.updateInitialPosition();
		}

		_createClass(MouseTilt, [{
			key: "getElementListener",


			/**
    * Method returns element what will be listen mouse events
    * @return {Node}
    */
			value: function getElementListener() {
				return this.element;
			}

			/**
    * Method set listen methods for this.elementListener
    * @return {Node}
    */

		}, {
			key: "addEventListeners",
			value: function addEventListeners() {
				this.onMouseEnterBind = this.onMouseEnter.bind(this);
				this.onMouseMoveBind = this.onMouseMove.bind(this);
				this.onMouseLeaveBind = this.onMouseLeave.bind(this);
				this.onWindowResizeBind = this.onWindowResize.bind(this);
				this.onDeviceOrientationBind = this.onDeviceOrientation.bind(this);

				this.elementListener.addEventListener("mouseenter", this.onMouseEnterBind);
				this.elementListener.addEventListener("mouseleave", this.onMouseLeaveBind);
				this.elementListener.addEventListener("mousemove", this.onMouseMoveBind);

				if (this.glare || this.fullPageListening) {
					window.addEventListener("resize", this.onWindowResizeBind);
				}

				if (this.gyroscope) {
					window.addEventListener("deviceorientation", this.onDeviceOrientationBind);
				}
			}

			/**
    * Method remove event listeners from current this.elementListener
    */

		}, {
			key: "removeEventListeners",
			value: function removeEventListeners() {
				this.elementListener.removeEventListener("mouseenter", this.onMouseEnterBind);
				this.elementListener.removeEventListener("mouseleave", this.onMouseLeaveBind);
				this.elementListener.removeEventListener("mousemove", this.onMouseMoveBind);

				if (this.gyroscope) {
					window.removeEventListener("deviceorientation", this.onDeviceOrientationBind);
				}

				if (this.glare || this.fullPageListening) {
					window.removeEventListener("resize", this.onWindowResizeBind);
				}
			}
		}, {
			key: "destroy",
			value: function destroy() {
				clearTimeout(this.transitionTimeout);
				if (this.updateCall !== null) {
					cancelAnimationFrame(this.updateCall);
				}

				this.reset();

				this.removeEventListeners();
				this.element.vanillaTilt = null;
				delete this.element.vanillaTilt;

				this.element = null;
			}
		}, {
			key: "onDeviceOrientation",
			value: function onDeviceOrientation(event) {
				if (event.gamma === null || event.beta === null) {
					return;
				}

				this.updateElementPosition();

				if (this.gyroscopeSamples > 0) {
					this.lastgammazero = this.gammazero;
					this.lastbetazero = this.betazero;

					if (this.gammazero === null) {
						this.gammazero = event.gamma;
						this.betazero = event.beta;
					} else {
						this.gammazero = (event.gamma + this.lastgammazero) / 2;
						this.betazero = (event.beta + this.lastbetazero) / 2;
					}

					this.gyroscopeSamples -= 1;
				}

				var totalAngleX = this.settings.gyroscopeMaxAngleX - this.settings.gyroscopeMinAngleX;
				var totalAngleY = this.settings.gyroscopeMaxAngleY - this.settings.gyroscopeMinAngleY;

				var degreesPerPixelX = totalAngleX / this.width;
				var degreesPerPixelY = totalAngleY / this.height;

				var angleX = event.gamma - (this.settings.gyroscopeMinAngleX + this.gammazero);
				var angleY = event.beta - (this.settings.gyroscopeMinAngleY + this.betazero);

				var posX = angleX / degreesPerPixelX;
				var posY = angleY / degreesPerPixelY;

				if (this.updateCall !== null) {
					cancelAnimationFrame(this.updateCall);
				}

				this.event = {
					clientX: posX + this.left,
					clientY: posY + this.top
				};

				this.updateCall = requestAnimationFrame(this.updateBind);
			}
		}, {
			key: "wrapWithParent",
			value: function wrapWithParent() {
				if (this.element.parentElement !== null && this.element.parentElement.className === "sppb-addon-wrapper") {
					this.element = this.element.parentElement;
				}
				if (this.element.className !== "sppb-addon-wrapper") {
					var newDom = document.createElement("div");
					newDom.setAttribute("class", "sppb-addon-wrapper");
					this.element.parentNode.insertBefore(newDom, this.element);
					newDom.appendChild(this.element);
					this.element = newDom;
				}
			}
		}, {
			key: "unWrapParent",
			value: function unWrapParent() {
				if (this.element.className !== "sppb-addon-wrapper") {
					return;
				}
				var elem = this.element.childNodes;
				if (elem.length > 0) {
					var newElement = this.element.parentNode.insertBefore(elem[0], this.element);
					this.element.parentElement.removeChild(this.element);
					this.element = newElement;
				}
			}
		}, {
			key: "onMouseEnter",
			value: function onMouseEnter() {
				// this.wrapWithParent();
				this.updateElementPosition();
				this.element.style.willChange = "transform";
				this.setTransition();
			}
		}, {
			key: "onMouseMove",
			value: function onMouseMove(event) {
				if (this.updateCall !== null) {
					cancelAnimationFrame(this.updateCall);
				}

				this.event = event;
				this.updateCall = requestAnimationFrame(this.updateBind);
			}
		}, {
			key: "onMouseLeave",
			value: function onMouseLeave() {
				this.setTransition();

				if (this.settings.reset) {
					requestAnimationFrame(this.resetBind);
				}
			}
		}, {
			key: "reset",
			value: function reset() {
				this.event = {
					clientX: this.left + this.width / 2,
					clientY: this.top + this.height / 2
				};
				if (this.element.parentElement !== null && this.element.parentElement.className && this.element.parentElement.className.indexOf("sppb-addon-wrapper") >= 0) {
					this.element = this.element.parentElement;
				}
				if (this.element && this.element.className && this.element.className.indexOf("sppb-addon-wrapper") === -1) {
					return;
				}

				if (this.element && this.element.style) {
					this.element.style.transform = "perspective(" + this.settings.perspective + "px) " + "rotateX(0deg) " + "rotateY(0deg) " + "scale3d(1, 1, 1)";
				}

				this.resetGlare();
			}
		}, {
			key: "resetGlare",
			value: function resetGlare() {
				if (this.glare) {
					this.glareElement.style.transform = "rotate(180deg) translate(-50%, -50%)";
					this.glareElement.style.opacity = "0";
				}
			}
		}, {
			key: "updateInitialPosition",
			value: function updateInitialPosition() {
				if (this.settings.startX === 0 && this.settings.startY === 0) {
					return;
				}

				this.onMouseEnter();

				if (this.fullPageListening) {
					this.event = {
						clientX: (this.settings.startX + this.settings.max) / (2 * this.settings.max) * this.clientWidth,
						clientY: (this.settings.startY + this.settings.max) / (2 * this.settings.max) * this.clientHeight
					};
				} else {
					this.event = {
						clientX: this.left + (this.settings.startX + this.settings.max) / (2 * this.settings.max) * this.width,
						clientY: this.top + (this.settings.startY + this.settings.max) / (2 * this.settings.max) * this.height
					};
				}

				var backupScale = this.settings.scale;
				this.settings.scale = 1;
				this.update();
				this.settings.scale = backupScale;
				this.resetGlare();
			}
		}, {
			key: "getValues",
			value: function getValues() {
				var x = void 0,
				    y = void 0;

				if (this.fullPageListening) {
					x = this.event.clientX / this.clientWidth;
					y = this.event.clientY / this.clientHeight;
				} else {
					x = (this.event.clientX - this.left) / this.width;
					y = (this.event.clientY - this.top) / this.height;
				}

				x = Math.min(Math.max(x, 0), 1);
				y = Math.min(Math.max(y, 0), 1);

				var tiltX = (this.reverse * (this.settings.max - x * this.settings.max * 2)).toFixed(2);
				var tiltY = (this.reverse * (y * this.settings.max * 2 - this.settings.max)).toFixed(2);
				var angle = Math.atan2(this.event.clientX - (this.left + this.width / 2), -(this.event.clientY - (this.top + this.height / 2))) * (180 / Math.PI);

				return {
					tiltX: tiltX,
					tiltY: tiltY,
					percentageX: x * 100,
					percentageY: y * 100,
					angle: angle
				};
			}
		}, {
			key: "updateElementPosition",
			value: function updateElementPosition() {
				var rect = this.element.getBoundingClientRect();

				this.width = this.element.offsetWidth;
				this.height = this.element.offsetHeight;
				this.left = rect.left;
				this.top = rect.top;
			}
		}, {
			key: "update",
			value: function update() {
				var values = this.getValues();

				this.element.style.transform = "perspective(" + this.settings.perspective + "px) " + "rotateX(" + (this.settings.axis === "x" ? 0 : values.tiltY) + "deg) " + "rotateY(" + (this.settings.axis === "y" ? 0 : values.tiltX) + "deg) " + "scale3d(" + this.settings.scale + ", " + this.settings.scale + ", " + this.settings.scale + ")";

				if (this.glare) {
					this.glareElement.style.transform = "rotate(" + values.angle + "deg) translate(-50%, -50%)";
					this.glareElement.style.opacity = "" + values.percentageY * this.settings["max-glare"] / 100;
				}

				this.element.dispatchEvent(new CustomEvent("tiltChange", {
					detail: values
				}));

				this.updateCall = null;
			}

			/**
    * Appends the glare element (if glarePrerender equals false)
    * and sets the default style
    */

		}, {
			key: "prepareGlare",
			value: function prepareGlare() {
				// If option pre-render is enabled we assume all html/css is present for an optimal glare effect.
				if (!this.glarePrerender) {
					// Create glare element
					var jsTiltGlare = document.createElement("div");
					jsTiltGlare.classList.add("js-tilt-glare");

					var jsTiltGlareInner = document.createElement("div");
					jsTiltGlareInner.classList.add("js-tilt-glare-inner");

					jsTiltGlare.appendChild(jsTiltGlareInner);
					this.element.appendChild(jsTiltGlare);
				}

				this.glareElementWrapper = this.element.querySelector(".js-tilt-glare");
				this.glareElement = this.element.querySelector(".js-tilt-glare-inner");

				if (this.glarePrerender) {
					return;
				}

				Object.assign(this.glareElementWrapper.style, {
					position: "absolute",
					top: "0",
					left: "0",
					width: "100%",
					height: "100%",
					overflow: "hidden",
					"pointer-events": "none"
				});

				Object.assign(this.glareElement.style, {
					position: "absolute",
					top: "50%",
					left: "50%",
					"pointer-events": "none",
					"background-image": "linear-gradient(0deg, rgba(255,255,255,0) 0%, rgba(255,255,255,1) 100%)",
					width: this.element.offsetWidth * 2 + "px",
					height: this.element.offsetWidth * 2 + "px",
					transform: "rotate(180deg) translate(-50%, -50%)",
					"transform-origin": "0% 0%",
					opacity: "0"
				});
			}
		}, {
			key: "updateGlareSize",
			value: function updateGlareSize() {
				if (this.glare) {
					Object.assign(this.glareElement.style, {
						width: "" + this.element.offsetWidth * 2,
						height: "" + this.element.offsetWidth * 2
					});
				}
			}
		}, {
			key: "updateClientSize",
			value: function updateClientSize() {
				this.clientWidth = window.innerWidth || document.documentElement.clientWidth || document.body.clientWidth;

				this.clientHeight = window.innerHeight || document.documentElement.clientHeight || document.body.clientHeight;
			}
		}, {
			key: "onWindowResize",
			value: function onWindowResize() {
				this.updateGlareSize();
				this.updateClientSize();
			}
		}, {
			key: "setTransition",
			value: function setTransition() {
				var _this2 = this;

				clearTimeout(this.transitionTimeout);
				this.element.style.transition = this.settings.speed + "ms " + this.settings.easing;
				if (this.glare) this.glareElement.style.transition = "opacity " + this.settings.speed + "ms " + this.settings.easing;

				this.transitionTimeout = setTimeout(function () {
					_this2.element.style.transition = "";
					if (_this2.glare) {
						_this2.glareElement.style.transition = "";
					}
				}, this.settings.speed);
			}
		}, {
			key: "extendSettings",
			value: function extendSettings(settings) {
				var defaultSettings = {
					reverse: false,
					max: 15,
					startX: 0,
					startY: 0,
					perspective: 1000,
					easing: "cubic-bezier(.03,.98,.52,.99)",
					scale: 1,
					speed: 300,
					transition: true,
					axis: null,
					glare: false,
					"max-glare": 1,
					"glare-prerender": false,
					"full-page-listening": false,
					"mouse-event-element": null,
					reset: true,
					gyroscope: true,
					gyroscopeMinAngleX: -45,
					gyroscopeMaxAngleX: 45,
					gyroscopeMinAngleY: -45,
					gyroscopeMaxAngleY: 45,
					gyroscopeSamples: 10
				};

				var newSettings = {};
				for (var property in defaultSettings) {
					if (property in settings) {
						newSettings[property] = settings[property];
					} else if (this.element.hasAttribute("data-tilt-" + property)) {
						var attribute = this.element.getAttribute("data-tilt-" + property);
						try {
							newSettings[property] = JSON.parse(attribute);
						} catch (e) {
							newSettings[property] = attribute;
						}
					} else {
						newSettings[property] = defaultSettings[property];
					}
				}

				return newSettings;
			}
		}], [{
			key: "isSettingTrue",
			value: function isSettingTrue(setting) {
				return setting === "" || setting === true || setting === 1;
			}
		}, {
			key: "init",
			value: function init(element, settings) {
				element.vanillaTilt = new MouseTilt(element, settings);
			}
		}]);

		return MouseTilt;
	}();

	/*
  * ===========
  * START
  * ===========
  */


	var $window = $(window);
	var windowWidth = $window.width();

	function percentageSeen($element) {
		var viewport = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : "viewport";

		var viewportHeight = $(window).height(),
		    scrollTop = $window.scrollTop(),
		    elementOffsetTop = $element && $element.offset() && $element.offset().top,
		    elementHeight = $element.height();
		if (viewport === "fullpage") {
			var docHeight = $(document).height();
			var winHeight = $(window).height();
			var scrollPercent = scrollTop / (docHeight - winHeight);
			var scrollPercentRounded = Math.round(scrollPercent * 100);
			return scrollPercentRounded;
		} else {
			if (elementOffsetTop > scrollTop + viewportHeight) {
				return -1;
			} else if (elementOffsetTop + elementHeight < scrollTop) {
				return 101;
			} else {
				var distance = scrollTop + viewportHeight - elementOffsetTop;
				var percentage = distance / ((viewportHeight + elementHeight) / 100);
				return percentage > 100 ? 100 : percentage;
			}
		}
	}

	var mouseTiltInstance = {};
	var initialLoader = false;

	window.addEventListener("DOMContentLoaded", function (event) {
		if (typeof addonInteraction !== "undefined") {
			initiateTiltAnimation(windowWidth);
			initiateIntractionAnimation();
		}
	});

	//Initiate tilt animation
	function initiateTiltAnimation(windowWidth) {
		if (typeof addonInteraction["mouse_movement"] !== "undefined") {
			//Cache the global animation action object

			var mouseMovementList = addonInteraction["mouse_movement"];

			mouseMovementList.map(function (tiltOpt) {
				var $addonElem = $("#sppb-addon-" + tiltOpt.addonId);
				if (!$addonElem.parent().hasClass("sppb-addon-wrapper")) {
					$addonElem.wrap('<div class="sppb-addon-wrapper"></div>');
				}
				//For mobile viewport
				if (windowWidth < 768 && tiltOpt.enable_mobile === false) {
					if (typeof mouseTiltInstance[tiltOpt.addonId] !== "undefined") {
						mouseTiltInstance[tiltOpt.addonId].tiltIntance.destroy();
						delete mouseTiltInstance[tiltOpt.addonId];
					}
					return false;
				}

				if (windowWidth > 767 && windowWidth < 991 && tiltOpt.enable_tablet === false) {
					if (typeof mouseTiltInstance[tiltOpt.addonId] !== "undefined") {
						mouseTiltInstance[tiltOpt.addonId].tiltIntance.destroy();
						delete mouseTiltInstance[tiltOpt.addonId];
					}
					return false;
				}

				if (typeof mouseTiltInstance[tiltOpt.addonId] !== "undefined") {
					return false;
				}

				var element = document.getElementById("sppb-addon-" + tiltOpt.addonId);
				element = element.parentElement;

				var settings = {
					speed: parseFloat(tiltOpt.animation.mouse_tilt_speed) * 1000,
					max: parseFloat(tiltOpt.animation.mouse_tilt_max),
					reverse: tiltOpt.animation.mouse_tilt_direction === "opposite",
					easing: "cubic-bezier(.03,.98,.52,.99)",
					scale: 1.05,
					transition: true,
					perspective: 1000
				};
				var tiltIntance = new MouseTilt(element, settings); // MouseTilt.init(element, settings)
				mouseTiltInstance[tiltOpt.addonId] = {
					tiltIntance: tiltIntance,
					enable_mobile: tiltOpt.enable_mobile,
					enable_tablet: tiltOpt.enable_tablet
				};
			});
		}
	}

	function initiateIntractionAnimation() {
		//Cache the global animation action object
		var scrollActionList = addonInteraction["while_scroll_view"];

		if (!scrollActionList) return;

		var $window = $(window);
		/**
   * Set the initial position of each element when page load
   * Hide the element to avoid zigzag trouble for the element
   * Trigger animation with scrollPercentage if element in view port
   * When object fit show the element with some smoth animate after 5 milisecond
   */
		var elements = {};

		$(document).ready(function () {
			scrollActionList.map(function (animationProperty) {
				if (windowWidth < 768 && animationProperty.enable_mobile === false) {
					return false;
				}
				if (windowWidth > 767 && windowWidth < 991 && animationProperty.enable_tablet === false) {
					return false;
				}
				var $addonElem = $("#sppb-addon-" + animationProperty.addonId);
				if (!$addonElem.parent().hasClass("sppb-addon-wrapper")) {
					$addonElem.wrap('<div class="sppb-addon-wrapper"></div>');
				}
				elements[animationProperty.addonId] = $addonElem;
				$addonElem.addClass("sppb-interaction-hide");
				var scrollPercentage = percentageSeen($addonElem.parent("div.sppb-addon-wrapper"));
				initiateOnScrollTrigger($addonElem, animationProperty, scrollPercentage, true);

				var timeoutId = setTimeout(function () {
					$addonElem.removeClass("sppb-interaction-hide");
					clearTimeout(timeoutId);
				}, 500);
			});
		});
		$(window).on("load", function () {
			var scrollScheduled = false;

			function optimizedScrollHandler() {
				scrollScheduled = false;
				windowWidth = $window.width();
				scrollActionList.map(function (animationProperty) {
					var $addonElem = $("#sppb-addon-" + animationProperty.addonId);
					if (windowWidth < 768 && animationProperty.enable_mobile === false) {
						$addonElem.css(flashCss());
						return false;
					}
					if (windowWidth > 767 && windowWidth < 991 && animationProperty.enable_tablet === false) {
						$addonElem.css(flashCss());
						return false;
					}

					var scrollPercentage = percentageSeen($addonElem.parent("div.sppb-addon-wrapper"), animationProperty.scrolling_options);
					initiateOnScrollTrigger($addonElem, animationProperty, scrollPercentage);
				});
			}

			$(document).on("scroll", function () {
				if (!scrollScheduled) {
					scrollScheduled = true;
					window.requestAnimationFrame(optimizedScrollHandler);
				}
			});
		});
	}

	function flashCss() {
		return {
			willChange: "transform",
			"-webkit-transition-timing-function": "ease",
			transitionDuration: "0s",
			"transform-origin": "center center",
			transformStyle: "preserve-3d",
			filter: "blur(0px)",
			"-webkit-filter": "blur(0px)",
			opacity: 1,
			transform: "perspective(1000px) translate3d(0px, 0px, 0px) \n                scale3d(1, 1, 1)\n                rotateX(0deg) rotateY(0deg) rotateZ(0deg) \n                skew(0deg, 0deg)"
		};
	}

	function initiateOnScrollTrigger($addonElem, animationProperty, scrollPercentage) {
		var withoutPercentage = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;

		console.log('here');
		if (withoutPercentage) {
			var cssProperty = parseInteractionCss(animationProperty, scrollPercentage);
			cssProperty["transitionDuration"] = ".1s";
			$addonElem.css(cssProperty);
		}
		if (scrollPercentage > -1 && scrollPercentage <= 100) {
			$addonElem.css(parseInteractionCss(animationProperty, scrollPercentage));
		}
	}

	function parseInteractionCss(animationProperty, scrollPercentage) {
		var nextTriggerActions = {
			move: {
				from: { x: 0, y: 0, z: 0, keyframe: 0, f: false },
				to: { x: 0, y: 0, z: 0, keyframe: 0, f: false },
				goal: { x: 0, y: 0, z: 0, keyframe: 0 }
			},
			scale: {
				from: { x: 1, y: 1, z: 1, keyframe: 0 },
				to: { x: 1, y: 1, z: 1, keyframe: 0 },
				goal: { x: 1, y: 1, z: 1, keyframe: 0 }
			},
			skew: {
				from: { x: 0, y: 0, keyframe: 0 },
				to: { x: 0, y: 0, keyframe: 0 },
				goal: { x: 0, y: 0, keyframe: 0 }
			},
			rotate: {
				from: { x: 0, y: 0, z: 0, keyframe: 0 },
				to: { x: 0, y: 0, z: 0, keyframe: 0 },
				goal: { x: 0, y: 0, z: 0, keyframe: 0 }
			},
			opacity: {
				from: { value: 0, keyframe: 0 },
				to: { value: 0, keyframe: 0 },
				goal: { value: 1, keyframe: 0 }
			},
			blur: {
				from: { value: 0, keyframe: 0 },
				to: { value: 0, keyframe: 0 },
				goal: { value: 0, keyframe: 0 }
			}
		};

		var animation = animationProperty.animation,
		    origin = animationProperty.origin;

		var IM = new InteractionMath(animation);
		IM.bindCustomAnimation();

		IM.actionProperty.map(function (key) {
			var action = IM.getCustomAnimationActionByName(key, scrollPercentage); // Grater than current keyframe/scrollPercentage
			if (action.from !== null) {
				Object.assign(nextTriggerActions[key].from, action.from.property);

				nextTriggerActions[key].from.f = true;
				nextTriggerActions[key].from.keyframe = parseInt(action.from.keyframe);

				if (typeof nextTriggerActions[key].from.x !== "undefined") nextTriggerActions[key].from.x = nextTriggerActions[key].from.x === "" ? 0 : parseFloat(nextTriggerActions[key].from.x);
				if (typeof nextTriggerActions[key].from.y !== "undefined") nextTriggerActions[key].from.y = nextTriggerActions[key].from.y === "" ? 0 : parseFloat(nextTriggerActions[key].from.y);
				if (typeof nextTriggerActions[key].from.z !== "undefined") nextTriggerActions[key].from.z = nextTriggerActions[key].from.z === "" ? 0 : parseFloat(nextTriggerActions[key].from.z);
				if (typeof nextTriggerActions[key].from.value !== "undefined") nextTriggerActions[key].from.value = nextTriggerActions[key].from.value === "" ? 0 : parseFloat(nextTriggerActions[key].from.value);
			}

			if (action.to !== null) {
				Object.assign(nextTriggerActions[key].to, action.to.property);

				if (typeof nextTriggerActions[key].to.x !== "undefined") {
					nextTriggerActions[key].to.x = nextTriggerActions[key].to.x === "" ? 0 : parseFloat(nextTriggerActions[key].to.x);
					nextTriggerActions[key].goal.x = nextTriggerActions[key].to.x;
				}
				if (typeof nextTriggerActions[key].to.y !== "undefined") {
					nextTriggerActions[key].to.y = nextTriggerActions[key].to.y === "" ? 0 : parseFloat(nextTriggerActions[key].to.y);
					nextTriggerActions[key].goal.y = nextTriggerActions[key].to.y;
				}
				if (typeof nextTriggerActions[key].to.z !== "undefined") {
					nextTriggerActions[key].to.z = nextTriggerActions[key].to.z === "" ? 0 : parseFloat(nextTriggerActions[key].to.z);
					nextTriggerActions[key].goal.z = nextTriggerActions[key].to.z;
				}
				if (typeof nextTriggerActions[key].to.value !== "undefined") {
					nextTriggerActions[key].to.value = nextTriggerActions[key].to.value === "" ? 0 : parseFloat(nextTriggerActions[key].to.value);
					nextTriggerActions[key].goal.value = nextTriggerActions[key].to.value;
				}
				nextTriggerActions[key].to.keyframe = parseInt(action.to.keyframe);
				nextTriggerActions[key].to.f = true;
			}

			if (nextTriggerActions[key].to.f === true && nextTriggerActions[key].from.f === true && typeof action.fixed === "undefined") {
				if (key === "opacity" || key === "blur") {
					nextTriggerActions[key] = IM.getOpacity(key, nextTriggerActions[key], scrollPercentage);
				} else if (key === "skew") {
					nextTriggerActions[key] = IM.getSkew(key, nextTriggerActions[key], scrollPercentage);
				} else {
					nextTriggerActions[key] = IM.getMoveTransform(key, nextTriggerActions[key], scrollPercentage);
				}
			}
		});

		return {
			"-webkit-transition-timing-function": "ease",
			transitionDuration: initialLoader ? "0s" : "0.1s",
			"transform-origin": origin.x_offset + " " + origin.y_offset,
			transformStyle: "preserve-3d",
			filter: "blur(" + nextTriggerActions.blur.goal.value + "px)",
			"-webkit-filter": "blur(" + nextTriggerActions.blur.goal.value + "px)",
			opacity: nextTriggerActions.opacity.goal.value,
			transform: "perspective(1000px) translate3d(" + nextTriggerActions.move.goal.x + "px, " + nextTriggerActions.move.goal.y + "px, " + nextTriggerActions.move.goal.z + "px) \n                scale3d(" + nextTriggerActions.scale.goal.x + ", " + nextTriggerActions.scale.goal.y + ", " + nextTriggerActions.scale.goal.z + ")\n                rotateX(" + nextTriggerActions.rotate.goal.x + "deg) rotateY(" + nextTriggerActions.rotate.goal.y + "deg) rotateZ(" + nextTriggerActions.rotate.goal.z + "deg) \n                skew(" + nextTriggerActions.skew.goal.x + "deg, " + nextTriggerActions.skew.goal.y + "deg)"
		};
	}

	$window.resize(function () {
		if (typeof addonInteraction !== "undefined") {
			initiateTiltAnimation($window.width());
		}
	});
})(jQuery);