<?php

/**
 * @package     EasyStore.Site
 * @subpackage  EasyStore.Klarna
 *
 * @copyright   Copyright (C) 2023 - 2024 JoomShaper <https://www.joomshaper.com>. All rights reserved.
 * @license     GNU General Public License version 3; see LICENSE
 */

namespace JoomShaper\Plugin\EasyStore\Klarna\Utils;

use Joomla\Registry\Registry;
use JoomShaper\Component\EasyStore\Administrator\Plugin\Constants;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Class that contains constants for the Paddle payment gateway.
 * @since 1.0.0
 */
class KlarnaConstants extends Constants
{
    /**
     * Plugin parameters
     *
     * @var Registry
     */
    protected $params;

    /**
     * The payment plugin name
     *
     * @var string
     */
    protected $name = 'klarna';

    /**
     * The constructor method
     */
    public function __construct()
    {
        parent::__construct($this->name);
    }

    /**
     * Get Payment Environment
     *
     * @return string
     */
    public function getPaymentEnvironment()
    {
        return $this->params->get('shop_environment');
    }

    /**
     * Get Username
     *
     * @return string
     */

    public function getUsername()
    {
        $key = $this->getPaymentEnvironment() === 'test' ? 'test_username' : 'live_username';

        return trim($this->params->get($key, ''));
    }

    /**
     * Get Password
     *
     * @return string
     */

    public function getPassword()
    {
        $key = $this->getPaymentEnvironment() === 'test' ? 'test_password' : 'live_password';

        return trim($this->params->get($key, ''));
    }

    /**
     * Get Klarna base url
     *
     * @return string
     */

    public function getKlarnaBaseUrl()
    {
        return $this->getPaymentEnvironment() === 'test' ? 'https://api.playground.klarna.com' : 'https://api.klarna.com';
    }
}
