<?php
/**
 * @package     Joomla.Site
 * @subpackage  mod_login
 *
 * @copyright   Copyright (C) 2005 - 2021 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;

HTMLHelper::_('behavior.keepalive');
?>
<div class="sp-custom-login-on">
	<div class="icons-wrap">
		<i class="fa fa-user-circle user-icon"></i>
		<span class="log-text">
			<?php echo Text::sprintf(htmlspecialchars($user->get('name'), ENT_COMPAT, 'UTF-8')); ?>
		</span>
		<i class="fa fa-chevron-down arrow-icon"></i>
	</div>
	<div class="form-login-wrap">
		<div class="form-users-wrapper">
			<?php echo Factory::getDocument()->getBuffer('modules', 'user-menu', array('style' => 'none')); ?>
		</div>
	</div>
</div>
