<?php
/**
 * @package     SP Eventum
 *
 * @copyright   Copyright (C) 2010 - 2015 JoomShaper. All rights reserved.
 * @license     GNU General Public License version 2 or later.
 */

defined('_JEXEC') or die();

$layout = $this->params->get('layout', 'default');

?>

<div id="sp-com-eventum" class="sp-com-eventum sp-eventum-view-schedules">

	<?php if(count($this->items)) { ?>
		<?php if($layout=='tabbed') { ?>
			<div class="eventum-schedules layout-tabbed">

				<!-- Nav tabs -->
				

				<!-- Tab panes -->
				<div class="tab-content">
					<?php foreach ($this->items as $key=>$this->schedule) { ?>
					<div role="tabpanel" class="tab-pane<?php echo ($key==0)? ' fade active in':' fade'; ?>" id="event-scehdule-<?php echo ($key+1); ?>">
						<div class="table-responsive">
							<table class="table table-hover">
								<thead>
									<tr>
										<th>#</th>
										<th><?php echo JText::_('COM_SPEVENTUM_SESSION'); ?></th>
										<th><?php echo JText::_('COM_SPEVENTUM_SPEAKERS'); ?></th>
										
										
									</tr>
								</thead>
								<tbody>
								<?php foreach ($this->schedule->sessions as $key => $this->schedule->session) { ?>
									<tr>
										<td scope="row"><?php echo $key+1; ?></td>
										<td><?php echo $this->schedule->session->title; ?></td>
										<td>
											<?php foreach ($this->schedule->session->speakers as $key => $speaker) { ?>
												<a class="event-speaker" href="<?php echo JRoute::_('index.php?option=com_speventum&view=speaker&id=' . $speaker->speventum_speaker_id . ':' . $speaker->slug . EventumHelper::getItemid('com_speventum&view=speakers')); ?>"><?php echo $speaker->title; ?></a><?php if($key!=count($this->schedule->session->speakers)-1) echo ", "; ?>
											<?php } ?>
											<?php if(!count($this->schedule->session->speakers)) { ?>
											.....
											<?php } ?>
										</td>
										
										
									</tr>						
								<?php } ?>
								</tbody>
							</table>
						</div>
					</div>
					<?php } ?>
				</div>
			</div>
		<?php } else { ?>
			<div class="eventum-schedules layout-classic">
				<?php foreach ($this->items as $key=>$this->schedule) { ?>
				<div class="eventum-schedule">

					<div class="row">
						<div class="col-xs-3 col-sm-2">
							<div class="scedule-date">
								<span class="scedule-date-day">
									<?php echo Jhtml::_('date', $this->schedule->date, 'd'); ?>
								</span>
								<?php echo Jhtml::_('date', $this->schedule->date, 'M, Y'); ?>
							</div>
						</div>
						<div class="col-xs-9 col-sm-10">
							<div class="table-responsive">
								<table class="table table-hover">
									<thead>
										<tr>
											<th>#</th>
											<th><?php echo JText::_('COM_SPEVENTUM_SESSION'); ?></th>
											<th><?php echo JText::_('COM_SPEVENTUM_SPEAKERS'); ?></th>
											<th><?php echo JText::_('COM_SPEVENTUM_TIME'); ?></th>
											<th><?php echo JText::_('COM_SPEVENTUM_VENUE'); ?></th>
										</tr>
									</thead>
									<tbody>
									<?php foreach ($this->schedule->sessions as $key => $this->schedule->session) { ?>
										<tr>
											<td><?php echo $key+1; ?></td>
											<td width="40%"><?php echo $this->schedule->session->title; ?></td>
											<td width="25%">
												<?php foreach ($this->schedule->session->speakers as $key => $speaker) { ?>
													<a class="event-speaker" href="<?php echo JRoute::_('index.php?option=com_speventum&view=speaker&id=' . $speaker->speventum_speaker_id . ':' . $speaker->slug . EventumHelper::getItemid('com_speventum&view=speakers')); ?>"><?php echo $speaker->title; ?></a><?php if($key!=count($this->schedule->session->speakers)-1) echo ", "; ?>
												<?php } ?>
												<?php if(!count($this->schedule->session->speakers)) { ?>
													.....
												<?php } ?>
											</td>
											<td width="20%"><?php echo $this->schedule->session->opening; ?> - <?php echo $this->schedule->session->closing; ?></td>
											<td><?php echo $this->schedule->session->venue; ?></td>
										</tr>						
									<?php } ?>
									</tbody>
								</table>
							</div>
						</div>
					</div>
				</div>
				<?php } ?>
			</div>
		<?php } ?>
	<?php } ?>

	<?php if ($this->pagination->get('pages.total')>1) { ?>
	<div class="pagination">
		<?php echo $this->pagination->getPagesLinks(); ?>
	</div>
	<?php } ?>
</div>