<?php

/**
 * @package SP Page Builder
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2018 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */
//no direct accees
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Router\Route;

class SppagebuilderAddonSpproperties_map extends SppagebuilderAddons
{

	public function render()
	{

		$class = (isset($this->addon->settings->class) && $this->addon->settings->class) ? $this->addon->settings->class : '';
		$title = (isset($this->addon->settings->title) && $this->addon->settings->title) ? $this->addon->settings->title : '';
		$heading_selector = (isset($this->addon->settings->heading_selector) && $this->addon->settings->heading_selector) ? $this->addon->settings->heading_selector : 'h3';
		// $$this->property_categories = (isset($this->property_categories) && $this->property_categories) ? $this->property_categories : array();
		// $this->property_categories = $this->addon->settings->properties_category;
		// if (count($this->property_categories) == 1 && empty($this->property_categories[0])) {
		// 	$this->property_categories = array();
		// }

		//Options
		$map = (isset($this->addon->settings->map) && $this->addon->settings->map) ? $this->addon->settings->map : '';
		$infowindow  = (isset($this->addon->settings->infowindow) && $this->addon->settings->infowindow) ? $this->addon->settings->infowindow : '';
		$gmap_api = (isset($this->addon->settings->gmap_api) && $this->addon->settings->gmap_api) ? $this->addon->settings->gmap_api : '';
		$type = (isset($this->addon->settings->type) && $this->addon->settings->type) ? $this->addon->settings->type : '';
		$zoom = (isset($this->addon->settings->zoom) && $this->addon->settings->zoom) ? $this->addon->settings->zoom : '';
		$mousescroll = (isset($this->addon->settings->mousescroll) && $this->addon->settings->mousescroll) ? $this->addon->settings->mousescroll : '';

		$multi_location = (isset($this->addon->settings->multi_location) && $this->addon->settings->multi_location) ? $this->addon->settings->multi_location : 0;
		$location_addr = [];

		//Getting the map location from #__spproperty_properties table
		$spproperty_markers = $this->getMarkers();

		jimport('joomla.application.component.helper');
		$params = JComponentHelper::getParams('com_spproperty');
		$curr   = $params->get('currency', 'USD:$');
		$currPos = $params->get('currency_position', 'left');



		if (isset($multi_location) && $multi_location !== 0) {
			//Check if #__spproperty_properties has map data. If not then show the addon's given settings.
			if (isset($spproperty_markers) && !empty($spproperty_markers)) {
				foreach ($spproperty_markers as $key => $marker) {
					$price  = $marker->price_request == 'show' || empty($marker->price_request) ? $marker->price : '';
					$price  = $this->formatPrice($price);
					if (!empty($price)) {
						list($cName, $cSymbol) = explode(':', $curr);
						if ($currPos == 'left') {
							$price = $cSymbol . $price;
						} else {
							$price = $price . ' ' . $cSymbol;
						}
					}

					if ($key === 0) {
						$map = $marker->map;
						list($lat, $lng) = explode(',', $marker->map);
						$location_addr[] = array('address' => $this->createInfoWindow($marker), 'latitude' => $lat, 'longitude' => $lng, 'custom_icon' => '', 'price' => $price, 'currency' => explode(':', $curr)[1]);
					} else {
						list($lat, $lng) = explode(',', $marker->map);
						$location_addr[] = array('address' => $this->createInfoWindow($marker), 'latitude' => $lat, 'longitude' => $lng, 'custom_icon' => '', 'price' => $price, 'currency' => explode(':', $curr)[1]);
					}
				}
			}
		}
		$location_json = json_encode($location_addr);

		if ($map) {
			if ($this->addon->settings->map_type == 'google') {
				$infowindow = '<div><strong>InfoWindow: </strong> this is window of info.</div>';
				$map = explode(',', $map);
				$output  = '<div id="sppb-addon-map-' . $this->addon->id . '" class="sppb-addon sppb-addon-gmap sp-property-map-wrapper' . $class . '">';
				$output .= ($title) ? '<' . $heading_selector . ' class="sppb-addon-title">' . $title . '</' . $heading_selector . '>' : '';
				$output .= '<div class="sppb-addon-content">';
				$output .= '<div baseurl="' . base64_encode(JURI::base()) . '" id="sppb-addon-gmap-' . $this->addon->id . '" class="sppb-addon-gmap-canvas" data-lat="' . trim($map[0]) . '" data-lng="' . trim($map[1]) . '" data-location=\'' . base64_encode($location_json) . '\' data-maptype="' . $type . '" data-mapzoom="' . $zoom . '" data-mousescroll="' . $mousescroll . '" data-infowindow="' . base64_encode($infowindow) . '"></div>';
				$output .= '</div>';
				$output .= '</div>';
				return $output;
			} else {

				$dragging = true;
				$zoomcontrol = true;
				$map_style = isset($this->addon->settings->map_style) && !empty($this->addon->settings->map_style) ? $this->addon->settings->map_style : 'streets';
				$mapbox_api = isset($this->addon->settings->mapbox_api) && $this->addon->settings->mapbox_api ? $this->addon->settings->mapbox_api : null;
				if (is_null($mapbox_api)) {
					die("You must have to add mapbox api for using Open Street Map");
				}

				$output  = '<div class="sppb-addon-openstreetmap-wrapper">';
				$output .= '<div class="sppb-addon-content">';
				$output .= "<div baseurl='" . base64_encode(JURI::base()) . "' id='sppb-addon-osm-" . $this->addon->id . "' class='sppb-addon-openstreetmap " . $class . "' data-location='" . base64_encode($location_json) . "' data-mapstyle='" . $map_style . "' data-mapzoom='" . $zoom . "' data-mousescroll='" . $mousescroll . "' data-dragging='" . $dragging . "' data-zoomcontrol='" . $zoomcontrol . "' data-mapbox='" . $mapbox_api . "'></div>";

				$output .= '</div>';
				$output .= '</div>';
				return $output;
			}
		} else {
			$output = '';
			if ($this->addon->settings->map_type == 'google') {
				$output .= '<div id="sppb-addon-map-' . $this->addon->id . '" class="sppb-addon sppb-addon-gmap sp-property-map-wrapper ' . $class . '">';
				$output .= ($title) ? '<' . $heading_selector . ' class="sppb-addon-title">' . $title . '</' . $heading_selector . '>' : '';
				$output .= '<div class="sppb-addon-content">';
				$output .= '<div baseurl="' . base64_encode(JURI::base()) . '" id="sppb-addon-gmap-' . $this->addon->id . '" class="sppb-addon-gmap-canvas" data-lat="" data-lng="" data-location="" data-maptype="' . $type . '" data-mapzoom="' . $zoom . '" data-mousescroll="' . $mousescroll . '" data-infowindow=""></div>';
				$output .= '</div>';
				$output .= '</div>';
			} else {
				$dragging = true;
				$zoomcontrol = true;
				$map_style = isset($this->addon->settings->map_style) && !empty($this->addon->settings->map_style) ? $this->addon->settings->map_style : 'streets';
				$mapbox_api = isset($this->addon->settings->mapbox_api) && $this->addon->settings->mapbox_api ? $this->addon->settings->mapbox_api : null;
				if (is_null($mapbox_api)) {
					die("You must have to add mapbox api for using Open Street Map");
				}

				$output .= '<div class="sppb-addon-openstreetmap-wrapper">';
				$output .= '<div class="sppb-addon-content">';
				$output .= "<div baseurl='" . base64_encode(JURI::base()) . "' id='sppb-addon-osm-" . $this->addon->id . "' class='sppb-addon-openstreetmap " . $class . "' data-location='[]' data-mapstyle='" . $map_style . "' data-mapzoom='" . $zoom . "' data-mousescroll='" . $mousescroll . "' data-dragging='" . $dragging . "' data-zoomcontrol='" . $zoomcontrol . "' data-mapbox='" . $mapbox_api . "'></div>";

				$output .= '</div>';
				$output .= '</div>';
			}
			return $output;
		}

		return;
	}

	public function getThumbs($image, $thumb_size = 'property_thumbnail', $default = '360x207')
	{
		jimport('joomla.application.component.helper');
		$params = JComponentHelper::getParams('com_spproperty');
		$thumb 	= $params->get($thumb_size, $default);

		$filename 		= basename($image);
		$customizePath 	= JPATH_BASE . '/' . dirname($image) . '/thumbs/' . JFile::stripExt($filename) . '_' . $thumb . '.' . JFile::getExt($filename);
		$imageSrc		= JURI::base(true) . '/' . dirname($image) . '/thumbs/' . JFile::stripExt($filename) . '_' . $thumb . '.' . JFile::getExt($filename);

		if (JFile::exists($customizePath)) {
			return $imageSrc;
		}
		return JURI::root() . $image;
	}

	private function formatPrice($price)
	{
		$price = (int)$price;
		if ($price >= 1000 && $price < 1000000) {
			$price /= 1000;
			if (is_float($price)) {
				$price = number_format($price, 2, '.', '');
			}
			$price .= "K";
		} else if ($price >= 1000000 && $price < 1000000000) {
			$price /= 1000000;
			if (is_float($price)) {
				$price = number_format($price, 2, '.', '');
			}
			$price .= "M";
		} else if ($price >= 1000000000) {
			$price /= 1000000000;
			if (is_float($price)) {
				$price = number_format($price, 2, '.', '');
			}
			$price .= "T";
		}
		return $price;
	}

	public function createInfoWindow($marker)
	{

		jimport('joomla.application.component.helper');
		$params = JComponentHelper::getParams('com_spproperty');
		$msr	= $params->get('measurement', 'sqft');
		$curr   = $params->get('currency', 'USD:$');
		$currPos = $params->get('currency_position', 'left');
		$price  = $marker->price_request == 'show' || empty($marker->price_request) ? $marker->price : '';
		$price  = $this->formatPrice($price);
		if (!empty($price)) {
			list($cName, $cSymbol) = explode(':', $curr);
			if ($currPos == 'left') {
				$price = $cSymbol . $price;
			} else {
				$price = $price . ' ' . $cSymbol;
			}
		}

		$postfix_price = '';
		if ($marker->property_status == 'rent') {
			if (!empty($marker->rent_period)) {
				$postfix_price = $marker->rent_period;
			} else {
				$postfix_price = 'Month';
			}
		} else {
			$postfix_price = $msr;
		}
		$html = array();
		$html[] = "<a href='" . Route::_('index.php?option=com_spproperty&view=property&id=' . $marker->id) . "'>";
		$html[] = "<div class='infowindow'>";
		$html[] = "<div class='image-wrapper'>";
		$html[] = "<img src='" . $this->getThumbs($marker->image) . "' >";
		$html[] = "</div>";
		$html[] = "<div class='info-wrapper'>";
		$html[] = "<div class='title-wrapper'>";
		$html[] = "<p class='price-text'>";
		$html[] = "<span class='price'>" . (!empty($price) ? $price . "<span>" . ' / ' . $postfix_price . "</span>" . ' | ' : '') . " </span>";
		$html[] = "<span class='property-size'>" . $marker->psize . ' ' . $msr . "</span>";
		$html[] = "</p>";
		$html[] = "</div>";
		$html[] = "<div class='location-wrapper'>";
		$html[] = "<span class='fa fa-map-marker'></span> <span>" . $marker->address . "</span>";
		$html[] = "</div>";
		$html[] = "</div>";
		$html[] = "</div>";
		$html[] = "</a>";

		return implode("\n", $html);
	}

	public function getMarkers()
	{
		$db 	= JFactory::getDbo();
		$query 	= $db->getQuery(true);

		$query->select('a.*')
			->from($db->quoteName('#__spproperty_properties', 'a'))
			->where($db->quoteName('a.published') . ' = 1');
		if (isset($this->property_categories) && !empty($this->property_categories)) {
			$query->where($db->quoteName('a.category_id') . ' IN (' . implode(',', $this->property_categories) . ' )');
		}

		$db->setQuery($query);
		$result = $db->loadObjectList();
		return $result;
	}

	public function scripts()
	{

		jimport('joomla.application.component.helper');
		$params = JComponentHelper::getParams('com_sppagebuilder');
		$gmap_api = $params->get('gmap_api', '');
		$return = [];
		$tmpl = "shaper_estate";


		if (isset($this->addon->settings->map_type) && $this->addon->settings->map_type == 'google') {
			$return[] = '//maps.googleapis.com/maps/api/js?key=' . $gmap_api;
			$return[] = JURI::base(true) . '/templates/' . $tmpl . '/js/addon_spproperties_gmap.js';
			$return[] = 'https://developers.google.com/maps/documentation/javascript/examples/markerclusterer/markerclusterer.js';
		} else {
			$return[] = JURI::base(true) . '/administrator/components/com_spproperty/assets/js/leaflet.js';
			$return[] = JURI::base(true) . '/templates/' . $tmpl . '/js/osm.js';
			$return[] = JURI::base(true) . '/templates/' . $tmpl . '/js/osm.provider.js';
			$return[] = JURI::base(true) . '/components/com_spproperty/assets/js/leaflet.markercluster.js';
		}

		return $return;
	}

	public function stylesheets()
	{

		return array(
			JURI::base(true) . '/administrator/components/com_spproperty/assets/css/leaflet.css',
			JURI::base(true) . '/components/com_spproperty/assets/css/MarkerCluster.css',
			JURI::base(true) . '/components/com_spproperty/assets/css/MarkerCluster.Default.css'
		);
	}

	public function css()
	{


		if ($this->addon->settings->map_type == 'google') {
			$addon_id = '#sppb-addon-' . $this->addon->id;
			$height = (isset($this->addon->settings->height) && $this->addon->settings->height) ? $this->addon->settings->height : 0;
			$height_sm = (isset($this->addon->settings->height_sm) && $this->addon->settings->height_sm) ? $this->addon->settings->height_sm : 0;
			$height_xs = (isset($this->addon->settings->height_xs) && $this->addon->settings->height_xs) ? $this->addon->settings->height_xs : 0;

			$css = '';

			if (isset($height) && is_object($height)) {
				$height = $height->md;
			}
			if ($height) {
				$css .= $addon_id . ' .sppb-addon-gmap-canvas {';
				$css .= 'height:' . (int) $height . 'px;';
				$css .= '}';
			}
			$css .= ".gm-style-iw {width: 250px !important;top: 15px !important;left: 0 !important;background-color: #fff;border-radius: 2px 2px 0 0;}.infowindow .info-wrapper {padding: 10px;}";

			if ($height_sm) {
				$css .= '@media (min-width: 768px) and (max-width: 991px) {';
				$css .= $addon_id . ' .sppb-addon-gmap-canvas {';
				$css .= 'height:' . (int) $height_sm . 'px;';
				$css .= '}';
				$css .= '}';
			}

			if ($height_xs) {
				$css .= '@media (max-width: 767px) {';
				$css .= $addon_id . ' .sppb-addon-gmap-canvas {';
				$css .= 'height:' . (int) $height_xs . 'px;';
				$css .= '}';
				$css .= '}';
			}
		} else {
			$addon_id = '#sppb-addon-' . $this->addon->id;
			$height = (isset($this->addon->settings->height) && $this->addon->settings->height) ? $this->addon->settings->height : 0;
			$height_sm = (isset($this->addon->settings->height_sm) && $this->addon->settings->height_sm) ? $this->addon->settings->height_sm : 0;
			$height_xs = (isset($this->addon->settings->height_xs) && $this->addon->settings->height_xs) ? $this->addon->settings->height_xs : 0;

			$css = '';

			if (isset($height) && is_object($height)) {
				$height = $height->md;
			}

			if ($height) {
				$css .= $addon_id . ' .sppb-addon-openstreetmap {';
				$css .= 'height:' . (int) $height . 'px;';
				$css .= '}';
			}

			if ($height_sm) {
				$css .= '@media (min-width: 768px) and (max-width: 991px) {';
				$css .= $addon_id . ' .sppb-addon-openstreetmap {';
				$css .= 'height:' . (int) $height_sm . 'px;';
				$css .= '}';
				$css .= '}';
			}

			if ($height_xs) {
				$css .= '@media (max-width: 767px) {';
				$css .= $addon_id . ' .sppb-addon-openstreetmap {';
				$css .= 'height:' . (int) $height_xs . 'px;';
				$css .= '}';
				$css .= '}';
			}
		}

		return $css;
	}
}
