/**
 * @copyright   Copyright (C) 2020 JoomShaper. All rights reserved.
 * @license     GNU General Public License version 3; see LICENSE
 * @since       1.0.0
 */

Joomla = window.Joomla || {};
(function (Joomla, document) {
	document.addEventListener('DOMContentLoaded', function () {

		let paymentEnvironment = '';
		
		document.addEventListener('change',  function (event) {

			if (document.getElementById('jform_params_payment_environment').contains(event.target)) {
				paymentEnvironment = event.target.value;
			}
		})

		document.addEventListener('click', function (event) {
			if (event.target.id === 'easystore-create-webhook') {
				event.preventDefault();

				const url = `${Joomla.getOptions(
					'easystore.base',
				)}/administrator/index.php?option=com_ajax&plugin=stripe&group=easystore&format=json`;

				event.target.innerText = Joomla.Text._('PLG_EASYSTORE_STRIPE_WEBHOOK_BUTTON_CREATE');

				let formData = new FormData();
				formData.append('payment_environment', paymentEnvironment);

				Joomla.request({
					url,
					data: formData, 
					method: 'POST',
					onSuccess: response => {
						response = JSON.parse(response)

						const webhookSecretKey = paymentEnvironment === 'test' ? 'secret_key' : 'live_secret_key';

						if (response.data !== undefined && response.data !== null) {
							if (response.data.webhook_secret) {
								document.querySelector('#jform_params_stripe_webhook_' + webhookSecretKey).value = response.data.webhook_secret;
								event.target.innerText = Joomla.Text._('PLG_EASYSTORE_STRIPE_WEBHOOK_ENDPOINT_CREATED');

								Joomla.renderMessages({
									message: [Joomla.Text._(response.data.message)],
								});

								// Trigger the save button
								Joomla.submitbutton('plugin.apply');
							} else {
								Joomla.renderMessages({
									error: [Joomla.Text._(response.data.message)],
								});
								event.target.innerText = Joomla.Text._('PLG_EASYSTORE_STRIPE_WEBHOOK_BUTTON_DESC');
							}
						}

						if (!response.success && response.message !== null) {
							Joomla.renderMessages({
								error: [Joomla.Text._(response.message)],
							});
							event.target.innerText = Joomla.Text._('PLG_EASYSTORE_STRIPE_WEBHOOK_BUTTON_DESC');
						}
					},
					onError: xhr => {
						Joomla.renderMessages(Joomla.ajaxErrorsMessages(xhr));
					},
				});
			}
		});
	});
})(Joomla, document);
