<?php

/**
 * @package    	Joomla.Site
 * @subpackage 	com_spstrings
 * @author 		JoomShaper support@joomshaper.com
 * @copyright 	Copyright (c) 2010 - 2022 JoomShaper <https://www.joomshaper.com>. All rights reserved.
 * @license     	GNU General Public License version 2 or later; see http://www.gnu.org/licenses/gpl-2.0.html
 */

// No Direct Access
defined('_JEXEC') or die('Restricted Access');

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;

$doc = Factory::getDocument();
$doc->addScript(Uri::root(true) . '/components/com_spstrings/assets/js/wavesurfer-min.js');
$doc->addScript(Uri::root(true) . '/components/com_spstrings/assets/js/wavesurfer-player.js');
$doc->addStylesheet(Uri::root(true) . '/components/com_spstrings/assets/css/wavesurfer-player.css');
?>

<div id="spstrings" class="spstrings spstrings-view-album">
    <div class="spstrings-album-content">
        <div class="row">
            <div class="col-sm-4">
                <div class="spstrings-album-img">
                    <div class="spstrings-album-img"><img class="sppb-img-responsive" src="<?php echo Uri::root() . $this->item->image; ?>" alt="<?php echo $this->item->title; ?>"></div>
                </div> <!-- //.col-sm-4 -->
            </div> <!-- //.spstrings-album-img -->
            <div class="col-sm-8">
                <h4 class="spstrings-album-name"><?php echo $this->item->title; ?></h4>
                <?php if ($this->item->production_by) { ?>
                    <h5 class="spstrings-album-designation"><?php echo $this->item->production_by; ?></h5>
                <?php } ?>
                <?php if ($this->item->description) { ?>
                    <div class="spstrings-album-info"><?php echo $this->item->description; ?></div> <!-- //.spstrings-album-info -->
                <?php  } ?>
            </div> <!-- //.col-sm-8 -->
        </div> <!-- //.spstrings-album-content -->
    </div> <!-- //.row -->

    <?php
    $this->item->tracks = json_decode($this->item->tracks);
    if (count((array) $this->item->tracks)) { ?>
        <div class="spstrings-album-track-list">
            <div class="row">
                <div class="col-sm-6 col-xs-6">
                    <h2 class="title"><?php echo Text::_('COM_SPSTRINGS_ALBUMS_TRACK_LIST'); ?></h2>
                </div> <!-- /.col-sm-4 -->
                <?php if ($this->item->purchase_url) { ?>
                    <div class="col-sm-6 col-xs-6">
                        <a href="<?php echo htmlspecialchars($this->item->purchase_url, ENT_QUOTES, 'UTF-8'); ?>"
                        class="btn btn-primary tset"
                        target="_blank" rel="noopener noreferrer">
                            <?php echo Text::_('COM_SPSTRINGS_ALBUMS_BUY_URL'); ?>
                        </a>
                    </div>
                <?php } ?>
            </div> <!-- /.row -->

            <!-- Start Audio controls -->
            <div class="canvas-wrapp">
                <div id="waveform">
                    <div class="current-ellapsed-time">
                        <div id="current-time"><span class="ellapsed-time pull-left"></span></div>
                    </div>
                </div>
            </div>

            <div class="audio-control">
                <div class="song-title-wrap">
                    <h4 id="current-song"></h4>
                </div>

                <div class="next-pre-wrapp">
                    <div id="previous" class="button">
                        <i class="fa fa-backward" aria-hidden="true" title="Previous Song"></i>
                    </div>
                    <div id="play-pause" class="button">
                        <i class="fa fa-play-circle" aria-hidden="true" title="Play / Pause"></i>
                    </div>
                    <div id="next" class="button">
                        <i class="fa fa-forward" aria-hidden="true" title="Next Song"></i>
                    </div>
                    <div id="repeat" class="button repeat-audio">
                        <i class="fa fa-repeat" aria-hidden="true" title="Toggle Repeat"></i>
                    </div>
                    <div id="shuffle" class="button shuffle-audio">
                        <i class="fa fa-random" aria-hidden="true" title="Toggle Shuffle"></i>
                    </div>
                </div>

                <div id="volume-control" class="volume-control">
                    <div id="mute" class="button pull-left">
                        <i class="fa fa-volume-up" aria-hidden="true"></i>
                    </div>
                    <div class="volume-wrap">
                        <div class="volume pull-left" title="Set volume ">
                            <div class="volume-bar"></div>
                        </div>
                    </div>
                </div>
            </div> <!-- /.audio-controls -->

            <!-- Album Track list -->
            <ul class="list-group" id="playlist">
                <?php foreach ($this->item->tracks as $track) {
                    if (isset($track->track_url) && $track->track_url && strpos($track->track_url, 'http') !== true) {
                        $track->track_url = Uri::root() . $track->track_url;
                    } ?>
                    <?php if (isset($track->track_url) && $track->track_url) { ?>
                        <li data-src="<?php echo $track->track_url; ?>" data-title="<?php echo $track->title; ?>" class="song-row">
                            <span class="song"><?php echo $track->title; ?></span>
                            <span class="length"><?php echo $track->lengh; ?></span>
                            <span class="play-icon"><i class="fa fa-play play-song button" aria-hidden="true"></i></span>
                        </li>
                    <?php } ?>
                <?php } ?>
            </ul> <!-- /.Album Track list -->
        </div> <!-- /.spstrings-album-track-list -->
    <?php } ?>

    <?php if (count($this->latest_albums)) { ?>
        <div class="spstrings-related-albums">
            <h3 class="related-title"><?php echo Text::_('COM_SPSTRINGS_ALBUMS_RELATED_ALBUMS'); ?></h3>
            <!-- load artist layout -->
            <?php echo LayoutHelper::render('albums.albums', array('albums' => $this->latest_albums, 'columns' => $this->albums_columns)); ?>
        </div> <!-- /.spstrings-related-albums -->
    <?php } ?>
</div> <!-- /.spstrings -->