<?php

/**
 * @package Qubic
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2016 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */
//no direct accees
defined('_JEXEC') or die('resticted aceess');

class SppagebuilderAddonSlideshow_full extends SppagebuilderAddons {

    public function render() {
        $autoplay = (isset($this->addon->settings->autoplay) && $this->addon->settings->autoplay) ? $this->addon->settings->autoplay : '';
        $controllers = (isset($this->addon->settings->controllers) && $this->addon->settings->controllers) ? $this->addon->settings->controllers : '';
        $arrows = (isset($this->addon->settings->arrows) && $this->addon->settings->arrows) ? $this->addon->settings->arrows : '';
        $class = (isset($this->addon->settings->class) && $this->addon->settings->class) ? $this->addon->settings->class : '';


        //Check Auto Play
        $slide_autoplay = ($autoplay) ? 'data-sppb-slide-ride="true"' : '';
        $slide_controllers = ($controllers) ? 'data-sppb-slidefull-controllers="true"' : '';


        //output
        $output = '<div class="sppb-addon sppb-slider-wrapper sppb-slider-fullwidth-wrapper' . $class . '">';
        $output .= '<div class="sppb-slider-item-wrapper">';
        $output .= '<div id="slide-fullwidth" class="owl-carousel" ' . $slide_controllers . ' ' . $slide_autoplay . ' >';

        foreach ($this->addon->settings->sp_slideshow_full_item as $key => $slide_item) {
            $src = "";
            if (isset($slide_item->bg)) {
                if (is_object($slide_item->bg)) {
                    $src = $slide_item->bg->src;
                } elseif (is_string($slide_item->bg)) {
                    $src = $slide_item->bg;
                }
            }
            $bg_image = "";
            // if have bg
            $bg_image = ($src) ? 'style="background-image: url(' . JURI::base() . $src . ');"' : '';

            // Before button icon
            $button_one_before_icon = (isset($slide_item->button_one_before_icon) && $slide_item->button_one_before_icon) ? '<i class="fa ' . $slide_item->button_one_before_icon . '"></i>' : '';

            $output .= '<div class="sppb-slideshow-fullwidth-item item">';
            $output .= '<div class="sppb-slide-item-bg sppb-slideshow-fullwidth-item-bg" ' . $bg_image . '>';
            $output .= '<div class="container">';
            $output .= '<div class="sppb-slideshow-fullwidth-item-text">';

            if (($slide_item->title) || ($slide_item->content)) {

                $sub_title = ($slide_item->sub_title) ? '<small class="sppb-slidehsow-sub-title">' . $slide_item->sub_title . '</small>' : '';

                if ($slide_item->title) {
                    $output .= '<h1 class="sppb-fullwidth-title">' . $slide_item->title . $sub_title . ' </h1>';
                }

                if ($slide_item->content) {
                    $output .= '<p class="details">' . $slide_item->content . '</p>';
                }

                if (($slide_item->button_one_text && $slide_item->button_one_url) || ($slide_item->button_two_text && $slide_item->button_two_url)) {
                    $output .= '<div class="sppb-fw-slider-button-wrapper "> ';
                    if ($slide_item->button_one_text && $slide_item->button_one_url) {
                        $output .= '<a target="' . $slide_item->target . '" href="' . $slide_item->button_one_url . '" class="sppb-slideshow-fullwidth-read-more btn"> <span>' . $button_one_before_icon . $slide_item->button_one_text . '</span></a>';
                    }

                    $output .= '</div>';
                }
            }

            $output .= '</div>'; // END:: /.sppb-slideshow-fullwidth-item-text
            $output .= '</div>'; // END:: /.container
            $output .= '</div>'; // END:: /.sppb-slideshow-fullwidth-item-bg
            $output .= '</div>'; // END:: /.sppb-slideshow-fullwidth-item
        }

        $output .= '</div>'; //END:: /.sppb-slider-items
        $output .= '<div class="footer-animation"> <a class="slideshow-angle-down-link" href="javascript:void(0)"><i class="fa fa-angle-down animated infinite slideInDown"></i></a></div>'; // /.footer-animation
        $output .= '</div>'; // END:: /.sppb-slider-item-wrapper
        // has next/previous arrows
        if ($arrows) {
            $output .= '<div class="customNavigation">';
            $output .= '<div class="container">';
            $output .= '<a class="sppbSlidePrev"><i class="pe pe-7s-angle-left"></i></a>';
            $output .= '<a class="sppbSlideNext"><i class="pe pe-7s-angle-right"></i></a>';
            $output .= '</div>';
            $output .= '</div>'; // END:: /.customNavigation
        }

        $output .= '</div>'; // /.sppb-slider-wrapper
        // has dot controls
        if ($controllers) {
            $output .= '<div class="owl-dots">';
            $output .= '<div class="owl-dot active"><span></span></div>';
            $output .= '<div class="owl-dot"><span></span></div>';
            $output .= '<div class="owl-dot"><span></span></div>';
            $output .= '</div>';
        }

        return $output;
    }

    public function scripts() {
        $app = JFactory::getApplication();
        $base_path = JURI::base() . '/templates/' . $app->getTemplate() . '/js/';
        return array($base_path . 'owl.carousel.min.js', $base_path . 'addon.slider.js');
    }

    public function stylesheets() {
        $app = JFactory::getApplication();
        $base_path = JURI::base() . '/templates/' . $app->getTemplate() . '/css/';
        return array($base_path . 'owl.carousel.css', $base_path . 'owl.theme.css', $base_path . 'owl.transitions.css', $base_path . 'slide-animate.css');
    }

    public function css() {
        $addon_id = '#sppb-addon-' . $this->addon->id;
        $addont_styles = '';
        $addont_styles .= (isset($this->addon->settings->background) && $this->addon->settings->background) ? 'background: ' . $this->addon->settings->background . '; ' : '';
        $addont_styles .= (isset($this->addon->settings->color) && $this->addon->settings->color) ? 'color: ' . $this->addon->settings->color . '; ' : '';

        $css = '';
        if ($addont_styles) {
            $css .= $addon_id . ' .sppb-slider-fullwidth-wrapper .sppb-slider-item-wrapper {';
            $css .= $addont_styles;
            $css .= '}';
        }

        return $css;
    }

    public function js() {
        $addon_id = '#sppb-addon-' . $this->addon->id;
        return '
          jQuery(document).ready(function ($) {
            "use strict";

            // Full width Slideshow
            var $slideFullwidth = $("' . $addon_id . ' #slide-fullwidth");

            // Autoplay
            var $autoplay = $slideFullwidth.attr("data-sppb-slide-ride");
            if ($autoplay == "true") {
                var $autoplay = true;
            } else {
                var $autoplay = false
            }

            // controllers
            var $controllers = $slideFullwidth.attr("data-sppb-slidefull-controllers");
            if ($controllers == "true") {
                var $controllers = true;
            } else {
                var $controllers = false
            }

            $slideFullwidth.owlCarousel({
                margin: 0,
                loop: true,
                video: true,
                autoplay: $autoplay,
                animateIn: "fadeIn",
                animateOut: "fadeOut",
                responsive: {
                    0: {
                        items: 1
                    },
                    600: {
                        items: 1
                    },
                    1000: {
                        items: 1
                    }
                },
                dots: $controllers,
            });

            $(".sppbSlidePrev").click(function () {
                $slideFullwidth.trigger("prev.owl.carousel", [400]);
            });

            $(".sppbSlideNext").click(function () {
                $slideFullwidth.trigger("next.owl.carousel", [400]);
            });

        });
        ';
    }

    public static function getTemplate() {
        $output = '
        <#
            let autoplay = (typeof data.autoplay !=="undefined") ? data.autoplay : 0;
            let controllers = (typeof data.controllers !=="undefined") ? data.controllers : 0;
            let arrows = (typeof data.arrows !=="undefined") ? data.arrows : 0;
            let contentClass = (!_.isEmpty(data.class) && data.class) ? data.class : "";

            let slide_autoplay = (autoplay > 0) ? \'data-sppb-slide-ride="true"\' : "";
            let slide_controllers = (controllers > 0) ? \'data-sppb-slidefull-controllers="true"\' : "";
        #>
            <div class="sppb-addon sppb-slider-wrapper sppb-slider-fullwidth-wrapper {{contentClass}}">
            <div class="sppb-slider-item-wrapper">
            <div id="slide-fullwidth" class="owl-carousel" {{{slide_controllers}}} {{{slide_autoplay}}}>

            <# _.each (data.sp_slideshow_full_item, function(slide_item, key) {

                let button_one_before_icon = (!_.isEmpty(slide_item.button_one_before_icon) && slide_item.button_one_before_icon) ? \'<i class="fa \' + slide_item.button_one_before_icon + \'"></i>\' : "";
            #>
                <div class="sppb-slideshow-fullwidth-item item">
                <div class="sppb-slide-item-bg sppb-slideshow-fullwidth-item-bg" style="background-image: url({{slide_item.bg.src}});">
                <div class="container">
                <div class="sppb-slideshow-fullwidth-item-text">

                <# if ((slide_item.title) || (slide_item.content)) {

                    let sub_title = (slide_item.sub_title) ? \'<small class="sppb-slidehsow-sub-title">\' + slide_item.sub_title + \'</small>\' : "";

                    if (slide_item.title) {
                #>
                        <h1 class="sppb-fullwidth-title">{{slide_item.title}} {{sub_title}}</h1>
                <#  }

                    if (slide_item.content) {
                #>
                        <p class="details">{{slide_item.content}}</p>
                <#  }

                    if ((slide_item.button_one_text && slide_item.button_one_url) || (slide_item.button_two_text && slide_item.button_two_url)) {
                #>
                        <div class="sppb-fw-slider-button-wrapper ">
                        <# if (slide_item.button_one_text && slide_item.button_one_url) { #>
                            <a target="{{slide_item.target}}" href="{{slide_item.button_one_url}}" class="sppb-slideshow-fullwidth-read-more btn"> <span>{{{button_one_before_icon}}} {{slide_item.button_one_text}}</span></a>
                        <# } #>

                        </div>
                    <# }
                } #>

                </div>
                </div>
                </div>
                </div>
            <# }) #>

            </div>
            <div class="footer-animation">
                <a class="slideshow-angle-down-link" href="javascript:void(0)">
                    <i class="fa fa-angle-down animated infinite slideInDown"></i>
                </a>
            </div>
            </div>
            <# if (arrows > 0 ) { #>
                <div class="customNavigation">
                <div class="container">
                <a class="sppbSlidePrev"><i class="pe pe-7s-angle-left"></i></a>
                <a class="sppbSlideNext"><i class="pe pe-7s-angle-right"></i></a>
                </div>
                </div>
            <# } #>

            </div>
            <# if (controllers > 0) { #>
                <div class="owl-dots">
                <div class="owl-dot active"><span></span></div>
                <div class="owl-dot"><span></span></div>
                <div class="owl-dot"><span></span></div>
                </div>
            <# } #>
            ';
        return $output;
    }

}
