<?php

/**
 * @package J2Store
 * @copyright Copyright (c)2014-17 Ramesh Elamathi / J2Store.org
 * @license GNU GPL v3 or later
 */

// No direct access
defined('_JEXEC') or die;
$image_path = JUri::root();
$main_image = "";
$main_image_width = $this->params->get('item_product_main_image_width', '200');
$additional_image_width = $this->params->get('item_product_additional_image_width', '100');

$document = JFactory::getDocument();
$document->addStyleSheet(JURI::root(true) . '/templates/arino/css/magnific-popup.css');
$document->addScript(JUri::base() . 'templates/arino/js/jquery.magnific-popup.min.js');

?>


<?php if ($this->params->get('item_show_product_main_image', 1) && !empty($this->product->main_image)) : ?>
    <div class="j2store-mainimage">
        <?php $main_image = $this->product->main_image; ?>
        <?php if ($main_image &&  JFile::exists(JPATH_SITE . '/' . $main_image)) : ?>
            <?php $class = $this->params->get('item_enable_image_zoom', 1) ? 'zoom' : 'nozoom'; ?>

            <span class="<?php echo $class; ?>" id="j2store-item-main-image-<?php echo $this->product->j2store_product_id; ?>">
                <img itemprop="image" alt="<?php echo (!empty($this->product->main_image_alt)) ? $this->product->main_image_alt : $this->product->product_name; ?>" title="<?php echo $this->product->product_name; ?>" class="j2store-product-main-image j2store-img-responsive" src="<?php echo $image_path . $main_image; ?>" width="<?php echo intval($main_image_width); ?>" />
            </span>
            <script type="text/javascript">
                var main_image = "<?php echo $image_path . $main_image; ?>";
                j2store.jQuery(document).ready(function() {
                    var enable_zoom = <?php echo $this->params->get('item_enable_image_zoom', 1); ?>;
                    if (enable_zoom) {
                        j2store.jQuery('#j2store-item-main-image-<?php echo $this->product->j2store_product_id; ?>').zoom();
                    }
                });
            </script>
        <?php elseif (!empty($this->product->main_image)) : ?>
            <?php echo J2Store::product()->displayImage($this->product, array('type' => 'ViewMain', 'params' => $this->params, 'alt' => $this->product->main_image_alt)); ?>
        <?php endif; ?>
    </div>

<?php endif; ?>

<?php if ($this->params->get('item_show_product_additional_image', 1) && isset($this->product->additional_images) && !empty($this->product->additional_images)) : ?>
    <?php
    $additional_images = json_decode($this->product->additional_images);
    $additional_images = array_filter((array) $additional_images);
    if (count($additional_images)) :
        $additional_images_alt = (array) json_decode($this->product->additional_images_alt);
    ?>
        <div class="j2store-product-additional-images">
            <h1>Comilla</h1>
            <ul class="additional-image-list popup-gallery">
                <?php
                foreach ($additional_images as $key => $image) : ?>
                    <?php
                    if (JFile::exists(JPATH_SITE . '/' . $image)) :
                        $image_src = $image_path . $image;
                    ?>
                        <li href="<?php echo $image_src; ?>">
                            <img id="addimage-<?php echo $this->product->j2store_product_id; ?>-<?php echo $key; ?>" class="j2store-item-additionalimage j2store-img-responsive mfp-with-zoom" src="<?php echo $image_src; ?>" alt="<?php echo (isset($additional_images_alt[$key]) && !empty($additional_images_alt[$key])) ? $additional_images_alt[$key] : $this->product->product_name; ?>" title="<?php echo $this->product->product_name; ?>" width="<?php echo intval($additional_image_width); ?>" />
                        </li>
                    <?php elseif (!empty($image)) : ?>
                        <?php echo J2Store::product()->displayImage($this->product, array('type' => 'ViewAdditional', 'params' => $this->params, 'key' => $key, 'image' => $image, 'alt' => (isset($additional_images_alt[$key]) && !empty($additional_images_alt[$key])) ? $additional_images_alt[$key] : $this->product->product_name)); ?>
                    <?php endif; ?>
                <?php endforeach; ?>
                <?php if ($main_image &&  JFile::exists(JPATH_SITE . '/' . $main_image)) :
                    $image_src = $image_path . $main_image; ?>
                    
                    <li href="<?php echo $image_src; ?>">
                        <img id="additial-main-image-<?php echo $this->product->j2store_product_id; ?>" alt="<?php echo (!empty($this->product->main_image_alt)) ? $this->product->main_image_alt : $this->product->product_name; ?>" title="<?php echo $this->product->product_name; ?>" class="j2store-item-additionalimage-preview j2store-img-responsive additional-mainimage" src="<?php echo $image_path . $main_image; ?>" width="<?php echo intval($additional_image_width); ?>" />
                    </li>
                <?php elseif (!empty($this->product->main_image)) : ?>
                    <?php echo J2Store::product()->displayImage($this->product, array('type' => 'AdditionalMain', 'params' => $this->params, 'alt' => $this->product->main_image_alt)); ?>
                <?php endif; ?>
            </ul>
        </div>
    <?php endif; ?>
<?php endif; ?>

<script type="text/javascript">
    jQuery(function($) {
        $(document).ready(function() {
            $('.popup-gallery').magnificPopup({
                delegate: 'li',
                type: 'image',
                tLoading: 'Loading image #%curr%...',
                mainClass: 'mfp-img-mobile',
                gallery: {
                    enabled: true,
                    navigateByImgClick: true,
                    preload: [0, 1]
                }
            });
        })
    });
</script>