<?php

/**
 * @package com_spmedical
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2021 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Restricted Access');

use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
?>

<div id="spmedical" class="spmedical view-spmedical-costestimates spmedical-costestimates">
  <h3 class="spmedical-title"><?php echo Text::_('TMPL_NURON_COST_ESTIMATE_TITLE'); ?></h3>
  <p class="spmedical-subtitle"><?php echo Text::_('TMPL_NURON_COST_ESTIMATE_SUBTITLE'); ?></p>

  <div class="spmedical-services-list-wrapper">
    <!-- Total cost -->
    <div class="spmedical-total-cost-wrapper">
      <div class="spmedical-test-total-wrap d-flex align-items-center justify-content-between">
          <div>
              <div class="small"><?php echo Text::_('COM_SPMEDICAL_COST_ESTIMATE_TOTAL_COST'); ?></div>
              <span class="spmedical-test-total-cost">0.00</span>
              <?php echo $this->currency[1]; ?>
          </div>
          <div class="spmedical-test-total-items-wrap">
            <div class="small"><?php echo Text::_('COM_SPMEDICAL_COST_ESTIMATE_SELECTED_ITEMS'); ?></div>
            <span class="spmedical-test-total-items">0</span>
          </div>
          <div>
              <span class="reset-items" data-bs-toggle="tooltip" data-bs-placement="top" title="Reset"><svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" fill="currentColor" class="bi bi-arrow-counterclockwise" viewBox="0 0 16 16"><path fill-rule="evenodd" d="M8 3a5 5 0 1 1-4.546 2.914.5.5 0 0 0-.908-.417A6 6 0 1 0 8 2v1z"/><path d="M8 4.466V.534a.25.25 0 0 0-.41-.192L5.23 2.308a.25.25 0 0 0 0 .384l2.36 1.966A.25.25 0 0 0 8 4.466z"/></svg></span>
          </div>
      </div>
    </div>

    <div class="spmedical-services-list">
        <h3 class="spmedical-services-title"><?php echo Text::_('TMPL_NURON_COST_ESTIMATE_CHOOSE_DEPERTMENT'); ?></h3>
      <select name="services" class="spmedical-custom-select">
        <?php foreach ($this->has_services as $service) {
          $selected = '';
          if ($this->department_id == $service->id) {
            $selected = 'selected';
          }
        ?>
          <option <?php echo $selected; ?> value="<?php echo $service->id; ?>"><?php echo $service->title; ?></option>
        <?php } ?>
      </select>
    </div> <!-- //list -->

    <div class="spmedical-services-test">
      <!-- Each service tests -->
      <?php foreach ($this->has_services as $key => $service) {
        $active_class = '';
        if (($this->department_id == $service->id) || ($this->department_id == '' &&  $key == 0)) {
          $active_class = 'active';
        }
      ?>
        <div class="spmedical-service-tests <?php echo $active_class; ?>" data-tab="<?php echo $service->id; ?>">
          <div class="spmedical-row">
            <?php if ($service->investigations) { ?>
              <?php echo LayoutHelper::render('costestimates.services', array('services' => $service->investigations, 'type' => 'investigations', 'services_title' => 'Investigations', 'service_id' => $service->id, 'columns' => 1)); ?>
            <?php } // has item 
            ?>

            <?php if ($service->treatments) { ?>
              <?php echo LayoutHelper::render('costestimates.services', array('services' => $service->treatments, 'type' => 'treatments', 'services_title' => 'treatments', 'service_id' => $service->id, 'columns' => 1)); ?>
            <?php } // has item 
            ?>

            <?php if ($service->others_services) { ?>
              <?php echo LayoutHelper::render('costestimates.services', array('services' => $service->others_services, 'type' => 'others_services', 'services_title' => 'Tests', 'service_id' => $service->id, 'columns' => 1)); ?>
            <?php } // has item 
            ?>

          </div> <!-- //.spmedical-row -->
        </div>
      <?php } ?>

    </div><!-- //.services-content -->
  </div>
</div> <!-- /#spmedical -->