<?php

/**
 * @package mod_spproperty_properties
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2018 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');
$user = Factory::getUser();
//Load porperties model
JLoader::register('SppropertyModelProperties', JPATH_SITE . '/components/com_spproperty/models/properties.php');
$properties_model = new SppropertyModelProperties();
?>

<div id="sp-property-properties<?php echo $module->id; ?>" class="spproperty <?php echo $params->get('moduleclass_sfx') ?>">

    <?php foreach (array_chunk($properties, $columns) as $properties) { ?>
        <div class="row">
            <?php foreach ($properties as $property) { ?>

                <?php
                $gallery  = json_decode($property->gallery, true);
                if (!is_bool($photo = SppropertyHelper::old2new($gallery, ['photo', 'alt_text'], 'gallery'))) {
                    $gallery = $photo;
                }

                if ($user->guest) {
                    $property->isFavorite = false;
                } else {
                    $property->isFavorite = $properties_model->isFavorite($property->id, $user->get('id'));
                }
                ?>
                <div class="spproperty-col-sm-<?php echo round(12 / $columns); ?>">
                    <div class="sp-properties-wrapper property-status-<?php echo $property->property_status; ?>">
                        <?php $has_gallery = isset($gallery) ? "" : "no-gallery"; ?>
                        <div class="property-image <?php echo $has_gallery; ?>">
                            <?php if (!isset($gallery) || empty($gallery)) { ?>
                                <a class="property-title-link" href="<?php echo $property->url; ?>">
                                    <img src="<?php echo $property->thumb; ?>" alt="<?php echo $property->title; ?>">
                                </a>
                                <div class="property-image-gradient-overlay"></div>
                            <?php } else { ?>
                                <div class="owl-carousel owl-theme spproperty-gallery">
                                    <?php if (!empty($property->image)) { ?>
                                        <div class="item">
                                            <a class="property-title-link" href="<?php echo $property->url; ?>">
                                                <img src="<?php echo $property->thumb; ?>" alt="<?php echo $property->title; ?>">
                                            </a>
                                        </div>
                                    <?php } ?>
                                    <?php foreach ($gallery as $v) { ?>
                                        <div class="item">
                                            <?php if (isset($v['photo']) && !empty($v['photo'])) { ?>
                                                <a class="property-title-link" href="<?php echo $property->url; ?>">
                                                    <img src="<?php echo SppropertyHelper::getThumbs($v['photo'], 'property_thumbnail', '360x207'); ?>" alt="<?php echo $v['alt_text']; ?>">
                                                </a>
                                            <?php } ?>
                                        </div>
                                    <?php } ?>
                                </div>
                            <?php } ?>
                            <!-- Add or remove to favourite -->
                            <?php if ($cParams['enable_add_to_fav']) { ?>
                                <div class="property-favourite pull-right">
                                    <form action="#" class="property-fav-form-mod">
                                        <input type="hidden" name="fav-url" class='property-fav-url' value='<?php echo Uri::root() . 'index.php?option=com_spproperty'; ?>'>
                                        <input type="hidden" name="property_id" class="property-fav-id" value="<?php echo $property->id; ?>">
                                        <input type="hidden" name="property_fav_flag" class="property_fav_flag" value="<?php echo ($property->isFavorite) ? 0 : 1; ?>">
                                        <?php echo HTMLHelper::_('form.token'); ?>
                                        <?php if ($user->id) { ?>
                                            <button class="property-fav-btn" type="submit">
                                                <span class="fav-heart fa <?php echo $property->isFavorite ? 'fa-heart' :  'fa-heart-o'; ?>"></span>
                                            </button>
                                        <?php } else { ?>
                                            <a href="<?php echo Route::_('index.php?option=com_users&view=login'); ?>"><span class="fa fa-heart-o"></span></a>
                                        <?php } ?>
                                    </form>
                                </div>
                            <?php } ?>
                        </div>

                        <div class="property-details">
                            <a class="property-title-link" href="<?php echo $property->url; ?>"></a>
                            <div class="property-details-wrap">
                                <div class="property-price">
                                    <?php if ($property->price_request == 'show' || is_null($property->price_request)) { ?>
                                        <?php if ($property->price) { ?>
                                        <?php
                                        $calc_price = (float)$property->solid_price * (float)$property->psize;
                                        if ($calc_price == 0) {
                                            $calc_price = $property->solid_price;
                                        }
                                        $total_price = SppropertyHelper::generateCurrency($calc_price, $property->currency, $property->currency_position, $property->currency_format);
                                        ?>

                                        <?php if ($property->fixed_price) { ?>
                                            <?php echo $property->price; ?>
                                        <?php } else { ?>
                                            <?php if ($property->property_status == 'rent') { ?>
                                                <?php echo $total_price; ?>
                                            <?php } else { ?>
                                                <?php echo $property->price; ?>
                                            <?php } ?>
                                        <?php } ?>


                                        <span class="price-tag">
                                        <?php if ($property->property_status == 'rent') { ?>
                                            <?php
                                            echo !empty(trim($property->rent_period)) ? ' / ' . $property->rent_period : ' / ' . Text::_('COM_SPPROPERTY_RENT_PERIOD_DEFAULT');
                                            ?>
                                        <?php } else { ?>
                                            <?php
                                            if (!$property->fixed_price) {
                                                if($cParams['measurement']){
                                                    echo empty(trim($cParams['measurement'])) ?  ' / ' . Text::_('COM_SPPROPERTY_PROPERTIES_SQFT') : ' / ' . $cParams['measurement'];
                                                }
                                            }
                                            ?>

                                        <?php } //end of else
                                        ?>
                                        </span>
                                    <?php } ?>
                                    <?php } else { ?>
                                        <span class="price-not-available">
                                            <?php echo Text::_('MOD_SPPROPERTY_PRICE_PREVIEW_NOT_AVAILABLE'); ?>
                                        </span>
                                    <?php } ?>
                                </div>
                                <div class="property-status-wrapper">
                                    <?php
                                    $status_class = "";
                                    if ($property->property_status == 'sell') {
                                        $status_class = "status-sell";
                                    } else if ($property->property_status == 'under_offer') {
                                        $status_class = "status-offer";
                                    } ?>
                                    <?php if ($property->property_status == 'pending' || $property->property_status == 'in_hold') { ?>
                                        <span class="property-status status-sell"><?php echo strtoupper(Text::_('COM_SPPROPERTY_FIELD_PROPERTY_STATUS_SELL')); ?></span>
                                    <?php } ?>
                                    <span class="property-status <?php echo $status_class; ?>">
                                        <?php echo $property->property_status_txt; ?>
                                    </span>
                                    <?php if ($property->featured) { ?>
                                        <span class="property-featured">
                                            <?php echo Text::_('MOD_SPPROPERTY_PROPERTOES_FIELD_FEATURED'); ?>
                                        </span>
                                    <?php } ?>
                                </div>
                                <h4 class="property-title">
                                    <a href="<?php echo $property->url; ?>">
                                        <?php echo $property->title; ?>
                                    </a>
                                </h4>
                                <p class="property-address"><i class="fa fa-map-marker"></i> <?php echo $property->address; ?>
                                </p>
                            </div>
                            <?php if ($property->psize || $property->beds || $property->baths || $property->garages) { ?>
                                <div class="property-summery">
                                    <ul>
                                        <?php if ($property->beds) { ?>
                                            <li class="bedroom">
                                                <i class="fa fa-hotel"></i>
                                                <?php echo $property->beds; ?> <?php echo Text::_('MOD_SPPROPERTY_PROPERTIES_BED'); ?>
                                            </li>
                                        <?php }
                                        if ($property->baths) { ?>
                                            <li class="bathroom">
                                                <i class="fa fa-s15"></i>
                                                <?php echo $property->baths; ?>
                                                <?php echo Text::_('MOD_SPPROPERTY_PROPERTIES_BATH'); ?>
                                            </li>
                                        <?php }
                                        if ($property->psize) { ?>
                                            <li class="area-size">
                                                <span class="img-wrap">
                                                    <img src="<?php echo Uri::root(true) . '/templates/shaper_estate/images/sqft.svg' ?>" alt="<?php echo Text::_('MOD_SPPROPERTY_PROPERTIES_SQFT'); ?>">
                                                </span>
                                                <?php echo $property->psize; ?>
                                                <?php echo empty(trim($cParams['measurement'] ?? "")) ?  Text::_('MOD_SPPROPERTY_PROPERTIES_SQFT') : $cParams['measurement']; ?>
                                            </li>
                                        <?php } ?>
                                    </ul>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>
        <!--/.row-->
    <?php } ?>
    <?php if (!empty($seeAllUrl)) { ?>
        <div class="row see-all-wrapper">
            <div class="col-sm-12 text-center">
                <a class="sppb-btn sppb-btn-primary" href="<?php echo $seeAllUrl; ?>" class=""><?php echo Text::_('MOD_SPPROPERTY_PROPERTIES_SEE_ALL') . ' (' . $countResult . ' ' . JText::_('MOD_SPPROPERTY_PROPERTIES_SEE_ALL_RESULT_' . ($countResult <= 1 ? 'SINGULAR' : 'PLURAL')) . ')'; ?></a>
            </div>
        </div>
    <?php } ?>
</div>