<?php

/**
 * @package com_spproperty
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2018 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;

// get component params

$cParams = ComponentHelper::getParams('com_spproperty');
$property_rm_btn = $cParams->get('prpry_rm_btn_text', Text::_('COM_SPPROPERTY_PROPERTIES_BTN_TEXT'));

$property     = $displayData['property'];
if (!empty($property)) {
    $gallery  = json_decode($property->gallery, true);
    if (!is_bool($photo = SppropertyHelper::old2new($gallery, ['photo', 'alt_text'], 'gallery'))) {
        $gallery = $photo;
    }
}
$user = Factory::getUser();

if ($property) { ?>
<div class="sp-properties-wrapper property-status-<?php echo $property->property_status; ?>">
    <?php if ($property->property_status == 'sold') { ?>
    <span class="spproperty-badge-sold"><?php echo Text::_('COM_SPPROPERTY_PROPERTIES_SOLD'); ?></span>
    <?php } ?>
    <div class="property-image">
        <?php if (!isset($gallery) || empty($gallery)) { ?>
            <a href="<?php echo $property->url; ?>">
                <img src="<?php echo $property->thumb; ?>" alt="<?php echo $property->title; ?>">
            </a>
        <?php } else { ?>
        <div class="owl-carousel owl-theme spproperty-gallery">
            <?php if (!empty($property->image)) { ?>
            <div class="item">
                <a href="<?php echo $property->url; ?>">
                    <img src="<?php echo $property->thumb; ?>" alt="<?php echo $property->title; ?>">
                </a>
            </div>
            <?php } ?>
            <?php foreach ($gallery as $v) { ?>
            <div class="item">
                <?php if (isset($v['photo']) && !empty($v['photo'])) { ?>
                    <a href="<?php echo $property->url; ?>">
                        <img src="<?php echo SppropertyHelper::getThumbs($v['photo'], 'property_thumbnail', '360x207'); ?>"
                    alt="<?php echo $v['alt_text']; ?>">
                    </a>
                <?php } ?>
            </div>
            <?php } ?>
        </div>
        <?php } ?>
        <!-- Add or remove to favourite -->
        <div class="property-favourite">
            <form action="#" class="property-fav-form">
                <input type="hidden" name="fav-url" class='property-fav-url'
                    value='<?php echo Uri::root() . 'index.php?option=com_spproperty'; ?>'>
                <input type="hidden" name="property_id" class="property-fav-id" value="<?php echo $property->id; ?>">
                <input type="hidden" name="property_fav_flag" class="property_fav_flag"
                    value="<?php echo (isset($property->fav_user_id) && !empty($property->fav_user_id) && $property->fav_user_id == $user->id) ? 0 : 1; ?>">
                <?php echo HTMLHelper::_('form.token'); ?>
                <?php if ($user->id) { ?>
                <button class="property-fav-btn" type="submit">
                    <?php if (isset($property->fav_user_id) && !empty($property->fav_user_id) && $property->fav_user_id == $user->id) { ?>
                    <span class="property-fav-icon-fill fa fa-heart"></span>
                    <?php } else { ?>
                    <span class="property-fav-icon-o fa fa-heart-o"></span>
                    <?php } ?>
                </button>
                <?php } else { ?>
                <a href="<?php echo Route::_('index.php?option=com_users&view=login'); ?>"><span
                        class="fa fa-heart-o"></span></a>
                <?php } ?>
            </form>
        </div>
        <?php if (!isset($gallery) || empty($gallery)) { ?>
        <div class="property-image-gradient-overlay"></div>
        <?php } ?>
    </div>
    <div class="property-details">
        <div class="property-details-wrap">
            <span class="property-price">
            <?php if ($property->price_request == 'show' || is_null($property->price_request)) { ?>
                <?php if ($property->price) { ?>
                    <?php
                    $calc_price = (float)$property->solid_price * (float)$property->psize;
                    if ($calc_price == 0) {
                        $calc_price = $property->solid_price;
                    }
                    $total_price = SppropertyHelper::generateCurrency($calc_price, $property->currency, $property->currency_position, $property->currency_format);
                    ?>

                    <?php if ($property->fixed_price) { ?>
                        <?php echo $property->price; ?>
                    <?php } else { ?>
                        <?php if ($property->property_status == 'rent') { ?>
                            <?php echo $total_price; ?>
                        <?php } else { ?>
                            <?php echo $property->price; ?>
                        <?php } ?>
                    <?php } ?>

                    <span class="price-tag">
                        <?php if ($property->property_status == 'rent') { ?>
                            <?php
                            echo !empty(trim($property->rent_period)) ? ' / ' . $property->rent_period : ' / ' . Text::_('COM_SPPROPERTY_RENT_PERIOD_DEFAULT');
                            ?>
                        <?php } else { ?>
                            <?php
                            if (!$property->fixed_price) {
                                if($cParams['measurement']){
                                    echo empty(trim($cParams['measurement'])) ?  ' / ' . Text::_('COM_SPPROPERTY_PROPERTIES_SQFT') : ' / ' . $cParams['measurement'];
                                }
                            }
                            ?>

                        <?php } //end of else
                        ?>
                    </span>
                <?php } ?>
            <?php } else { ?>
                <span class="price-not-available">
                    <?php echo Text::_('COM_SPPROPERTY_PRICE_PREVIEW_NOT_AVAILABLE'); ?>
                </span>
                <?php } ?>
            </span>
            <div class="property-status-wrapper">
                <span class="property-status">
                    <?php echo $property->property_status_txt; ?>
                </span>
                <?php if ($property->featured) { ?>
                <span class="property-featured">
                    <?php echo Text::_('COM_SPPROPERTY_FEATURED'); ?>
                </span>
                <?php } ?>
            </div>
            <h4 class="property-title">
                <a href="<?php echo $property->url; ?>">
                    <?php echo $property->title; ?>
                </a>
            </h4>
            <p class="property-address"><i class="fa fa-map-marker"></i> <?php echo $property->address; ?></p>
        </div>
        <?php if ($property->psize || $property->beds || $property->baths || $property->garages) { ?>
        <div class="property-summery">
            <ul>
                <?php if ($property->beds) { ?>
                <li class="bedroom">
                    <i class="fa fa-hotel"></i>
                    <?php echo $property->beds; ?> <?php echo Text::_('COM_SPPROPERTY_PROPERTIES_BEDROOMS'); ?>
                </li>
                <?php }
                        if ($property->baths) { ?>
                <li class="bathroom">
                    <i class="fa fa-s15"></i>
                    <?php echo $property->baths; ?> <?php echo Text::_('COM_SPPROPERTY_PROPERTIES_BATHS'); ?>
                </li>
                <?php }
                        if ($property->psize) { ?>
                <li class="area-size">
                    <i class="fa fa-object-group"></i>
                    <?php echo $property->psize; ?>
                    <?php echo empty(trim($cParams['measurement'] ?? "")) ?  Text::_('COM_SPPROPERTY_PROPERTIES_SQFT') : $cParams['measurement']; ?>
                </li>
                <?php } ?>
            </ul>
        </div>
        <?php } ?>
    </div>
</div> <!-- /.sp-properties-wrapper -->
<?php } ?>