<?php
/**
 * @package Helix Ultimate Framework
 * @author JoomShaper https://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2018 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or Later
*/

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Session\Session;

defined ('_JEXEC') or die();

$user = Factory::getUser();
$data = $displayData;
$menu_type = $displayData->params->get('menu_type');
$offcanvs_position = $displayData->params->get('offcanvas_position', 'right');
$show_login_button = $displayData->params->get('show_login_button');
$show_secondary_button = $displayData->params->get('show_secondary_button');
$secondary_button_text = $displayData->params->get('secondary_button_text');
$secondary_button_link = $displayData->params->get('secondary_button_link');

$feature_folder_path     = JPATH_THEMES . '/' . $data->template->template . '/features/';

include_once $feature_folder_path.'logo.php';
include_once $feature_folder_path.'menu.php';

// offcanvas
$offcanvas_margin = ($offcanvs_position == 'right') ? 'ms-3' : 'me-3';
if ($menu_type == 'mega')
{
    $offcanvas = '<a id="offcanvas-toggler" class="btn btn-outline-secondary py-2 px-3 '. $offcanvas_margin .' d-inline-block d-lg-none" aria-label="'. Text::_('HELIX_ULTIMATE_NAVIGATION') .'" href="#"><span class="fa fa-bars" aria-hidden="true" title="'. Text::_('HELIX_ULTIMATE_NAVIGATION') .'"></span></a>';
}
else
{
    $offcanvas = '<a id="offcanvas-toggler" class="btn btn-outline-secondary py-2 px-3 '. $offcanvas_margin .'" aria-label="'. Text::_('HELIX_ULTIMATE_NAVIGATION') .'" href="#"><span class="fa fa-bars" aria-hidden="true" title="'. Text::_('HELIX_ULTIMATE_NAVIGATION') .'"></span></a>';
}
?>

<div id="sp-top-bar">
	<div class="container">
		<div class="container-inner">
			<div class="row">
				<div id="sp-top1" class="col-lg-6">
					<div class="sp-column text-center text-lg-start">
						<jdoc:include type="modules" name="top1" style="sp_xhtml"/>
					</div>
				</div>

				<div id="sp-top2" class="col-lg-6">
					<div class="sp-column text-center text-lg-end">
						<jdoc:include type="modules" name="top2" style="sp_xhtml" />
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<?php

// output
$output  = '';

$output .= '<header id="sp-header">';
$output .= '<div class="d-flex">';

$class1 = 'col-8 col-md-3';
$class2 = 'col-4 col-md-6';
if($offcanvs_position == 'left')
{
    $class1 = 'col-12 col-lg-3';
    $class2 = 'd-none d-lg-block col-lg-6';
}

$output .= '<div id="sp-logo" class="mr-auto">';
$output .= '<div class="sp-column d-flex align-items-center">';

if($offcanvs_position == 'left')
{
    $output .= $offcanvas ;
}

$logo    = new HelixUltimateFeatureLogo($data->params);
if(isset($logo->load_pos) && $logo->load_pos == 'before')
{
    $output .= $logo->renderFeature();
    $output .= '<jdoc:include type="modules" name="logo" style="sp_xhtml" />';
}
else
{
    $output .= '<jdoc:include type="modules" name="logo" style="sp_xhtml" />';
    $output .= $logo->renderFeature();
}
$output .= '</div>';
$output .= '</div>';

$output .= '<div id="sp-menu" class="d-none d-lg-block text-center">';
$output .= '<div class="sp-column d-inline-block">';
$menu    = new HelixUltimateFeatureMenu($data->params);
if(isset($menu->load_pos) && $menu->load_pos == 'before')
{
    $output .= $menu->renderFeature();
    $output .= '<jdoc:include type="modules" name="menu" style="sp_xhtml" />';
}
else
{
    $output .= '<jdoc:include type="modules" name="menu" style="sp_xhtml" />';
    $output .= $menu->renderFeature();
}
$output .= '</div>';
$output .= '</div>';

$output .= '<div class="ml-auto d-flex align-items-center justify-content-end">';
$output .= '<div class="sp-column">';
if(!$user->id && $show_login_button)
{
    $output .= '<a class="btn btn-outline-primary" href="'. Text::_('index.php?option=com_users&view=login') .'">'. Text::_('HELIX_ULTIMATE_LOGIN') .'</a>';
}

if ($show_secondary_button)
{
    $output .= '<a class="btn btn-primary d-none d-md-inline-block ml-3" href="'. $secondary_button_link .'">'. $secondary_button_text .'</a>';
}

if($user->id && $show_login_button)
{
    $output .= '<a class="btn btn-secondary btn-iconic ms-4" href="#" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><span class="far fa-user"></span></a>';

    $output .= '<div class="dropdown-menu dropdown-menu-right">';
    $output .= '<p class="px-4 pt-2"><strong>'. Text::_('HELIX_ULTIMATE_HI') .', '. $user->name .'</strong></p>';
    $output .= '<div class="dropdown-divider"></div>';
    $output .= Factory::getDocument()->getBuffer('modules', 'user-account', array('style' => 'none'));
    $output .= '<div class="dropdown-divider"></div>';
    $output .= '<a class="dropdown-item" href="' . Route::_('index.php?option=com_users&task=user.logout&' . Session::getFormToken() . '=1') .'">'. Text::_('HELIX_ULTIMATE_LOGOUT') .' <span class="fas fa-sign-out-alt mr-2"></span></a>';
    $output .= '</div>';
}

if($offcanvs_position == 'right')
{
    $output .= $offcanvas;
}

$output .= '</div>';
$output .= '</div>';

$output .= '</div>';
$output .= '</header>';

echo $output;