<?php
/**
 * @package SP Page Builder
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2018 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
//no direct accees
defined ('_JEXEC') or die ('Restricted access');

class SppagebuilderAddonWayne_corp_case_study extends SppagebuilderAddons {

	public function render() {
		$settings = $this->addon->settings;
		$class = (isset($settings->class) && $settings->class) ? $settings->class : '';
		$title = (isset($settings->title) && $settings->title) ? $settings->title : '';
		$heading_selector = (isset($settings->heading_selector) && $settings->heading_selector) ? $settings->heading_selector : 'h3';

		//Options
		$text = (isset($settings->text) && $settings->text) ? $settings->text : '';
		$alignment = (isset($settings->alignment) && $settings->alignment) ? $settings->alignment : '';
		$dropcap = (isset($settings->dropcap) && $settings->dropcap) ? $settings->dropcap : 0;
		$lead_item = (isset($settings->lead_item) && $settings->lead_item) ? $settings->lead_item : 0;
        $feature_image = (isset($settings->feature_image) && $settings->feature_image) ? $settings->feature_image : '';
        $button_text = (isset($this->addon->settings->button_text) && $this->addon->settings->button_text) ? $this->addon->settings->button_text : '';
		$button_url = (isset($this->addon->settings->button_url) && $this->addon->settings->button_url) ? $this->addon->settings->button_url : '';
		$button_attribs = (isset($this->addon->settings->button_target) && $this->addon->settings->button_target) ? ' target="' . $this->addon->settings->button_target . '"' : '';
		$button_attribs .= (isset($this->addon->settings->button_url) && $this->addon->settings->button_url) ? ' href="' . $this->addon->settings->button_url . '"' : '';
		$button_icon = (isset($this->addon->settings->button_icon) && $this->addon->settings->button_icon) ? $this->addon->settings->button_icon : '';
		$button_icon_position = (isset($this->addon->settings->button_icon_position) && $this->addon->settings->button_icon_position) ? $this->addon->settings->button_icon_position: 'left';

		$dropcapCls = '';
		if($dropcap){
			$dropcap = 'sppb-dropcap';
		}

        $lead_item_class = "";
        if($lead_item){
            $lead_item_class = "lead-item";
        }

        if($button_icon_position == 'left') {
			$button_text = ($button_icon) ? '<i class="fa ' . $button_icon . '"></i> ' . $button_text : $button_text;
		} else {
			$button_text = ($button_icon) ? $button_text . ' <i class="fa ' . $button_icon . '"></i>' : $button_text;
		}
        $button_output = ($button_text) ? '<a' . $button_attribs . ' class="main-btn sppb-btn sppb-btn-link">' . $button_text . '</a>' : '';
        
		//Output
		$output  = '<div class="sppb-addon sppb-addon-text-block sppb-addon-case-study '. $lead_item_class . ' ' . $dropcap . ' ' . $alignment . ' ' . $class . '">';
        $output .= '<div class="sppb-addon-content d-flex align-items-center">';
        $output .= '<div class="case-study-content">';
		$output .= ($title) ? '<'.$heading_selector.' class="sppb-addon-title">' . $title . '</'.$heading_selector.'>' : '';
        $output .= '<div class="d-flex sppb-addon-case-study-features-list">';
        foreach ($this->addon->settings->sp_features_item as $key => $featureItem) {
            $output .= '<div class="item d-flex">';	
            $output .= '<span class="title">'. $featureItem->title .'</span>';	
            $output .= '<span class="text">'. $featureItem->text_content .'</span>';	
            $output .= '</div>';
        }
        $output .= '</div>'; //.features-list
        $output .= '<div class="case-study-text-content">';
		$output .= $text;
        $output .= '</div>'; //.case-study-text-content
        $output .= $button_output;
        $output .= '</div>'; //.case-study-content
        $output .= '<div class="case-study-img">';
        $output .= '<img class="sppb-img-responsive" src="' .JURI::base(true) . '/' . (is_string($feature_image) ? $feature_image : $feature_image->src) . '" alt="'.strip_tags($title).'">';
		$output .= '</div>';
		$output .= '</div>';
		$output .= '</div>';

		return $output;

	}

	public function css() {
		$settings = $this->addon->settings;
		$css = '';
		$dropcap_style = (isset($settings->dropcap_color) && $settings->dropcap_color) ? "color: " . $settings->dropcap_color . ";" : "";

		$style = '';
		$style_sm = '';
		$style_xs = '';

		$style .= (isset($settings->text_fontsize) && $settings->text_fontsize) ? "font-size: " . $settings->text_fontsize . "px;" : "";
		$style .= (isset($settings->text_fontweight) && $settings->text_fontweight) ? "font-weight: " . $settings->text_fontweight . ";" : "";
		$style_sm .= (isset($settings->text_fontsize_sm) && $settings->text_fontsize_sm) ? "font-size: " . $settings->text_fontsize_sm . "px;" : "";
		$style_xs .= (isset($settings->text_fontsize_xs) && $settings->text_fontsize_xs) ? "font-size: " . $settings->text_fontsize_xs . "px;" : "";

		$style .= (isset($settings->text_lineheight) && $settings->text_lineheight) ? "line-height: " . $settings->text_lineheight . "px;" : "";
		$style_sm .= (isset($settings->text_lineheight_sm) && $settings->text_lineheight_sm) ? "line-height: " . $settings->text_lineheight_sm . "px;" : "";
		$style_xs .= (isset($settings->text_lineheight_xs) && $settings->text_lineheight_xs) ? "line-height: " . $settings->text_lineheight_xs . "px;" : "";

		if(isset($settings->dropcap) && $settings->dropcap && !empty($dropcap_style)){
			$css .= '#sppb-addon-' . $this->addon->id . ' .sppb-dropcap .sppb-addon-content:first-letter{ ' . $dropcap_style . ' }';
		}

		if($style){
			$css .= '#sppb-addon-' . $this->addon->id . '{ ' . $style . ' }';
		}

		if($style_sm){
			$css .= '@media (min-width: 768px) and (max-width: 991px) {#sppb-addon-' . $this->addon->id . '{ ' . $style_sm . ' }}';
		}

		if($style_xs){
			$css .= '@media (max-width: 767px) {#sppb-addon-' . $this->addon->id . '{ ' . $style_xs . ' }}';
		}

		return $css;
	}

	public static function getTemplate()
	{
		$output = '
		<#
			var dropcap = "";

			if(data.dropcap){
				dropcap = "sppb-dropcap";
			}
            var lead_item_class = "";
            if(data.lead_item){
                lead_item_class = "lead-item";
            }

			if(!data.heading_selector){
				data.heading_selector = "h3";
			}
		#>
		<style type="text/css">
			#sppb-addon-{{ data.id }}{
				<# if(_.isObject(data.text_fontsize)){ #>
					font-size: {{ data.text_fontsize.md }}px;
				<# } else { #>
					font-size: {{ data.text_fontsize }}px;
				<# } #>

				<# if(_.isObject(data.text_lineheight)){ #>
					line-height: {{ data.text_lineheight.md }}px;
				<# } else { #>
					line-height: {{ data.text_lineheight }}px;
				<# } #>
				font-weight:{{data.text_fontweight}};
			}
			#sppb-addon-{{ data.id }} .sppb-dropcap .sppb-addon-content:first-letter {
				color: {{ data.dropcap_color }};
			}

			@media (min-width: 768px) and (max-width: 991px) {
				#sppb-addon-{{ data.id }}{
					<# if(_.isObject(data.text_fontsize)){ #>
						font-size: {{ data.text_fontsize.sm }}px;
					<# } #>

					<# if(_.isObject(data.text_lineheight)){ #>
						line-height: {{ data.text_lineheight.sm }}px;
					<# } #>
				}
			}
			@media (max-width: 767px) {
				#sppb-addon-{{ data.id }}{
					<# if(_.isObject(data.text_fontsize)){ #>
						font-size: {{ data.text_fontsize.xs }}px;
					<# } #>

					<# if(_.isObject(data.text_lineheight)){ #>
						line-height: {{ data.text_lineheight.xs }}px;
					<# } #>
				}
			}
		</style>
        <div class="sppb-addon sppb-addon-text-block sppb-addon-case-study {{lead_item_class}} {{ dropcap }} {{ data.alignment }} {{ data.class }}">
        <div class="sppb-addon-content d-flex align-items-center">
        <div class="case-study-content">
		<# if( !_.isEmpty( data.title ) ){ #><{{ data.heading_selector }} class="sppb-addon-title sp-inline-editable-element" data-id={{data.id}} data-fieldName="title" contenteditable="true">{{{ data.title }}}</{{ data.heading_selector }}><# } #>
        <div class="d-flex sppb-addon-case-study-features-list">
        <# _.each (data.sp_features_item, function(item, key) { #>
            <div class="item d-flex">
            <span class="title">{{item.title}}</span>
            <span class="text">{{item.text_content}}</span>
            </div>
        <# }) #>
        </div>
        <div class="case-study-text-content sp-editable-content" data-id={{data.id}} data-fieldName="text">{{{data.text}}}</div>
        <# if(data.button_text){ #>
            <a href="{{data.button_url}}" class="main-btn sppb-btn sppb-btn-link"><# if(data.button_icon_position == "left" && !_.isEmpty(data.button_icon)) { #><i class="fa {{ data.button_icon }}"></i> <# } #>{{ data.button_text }}<# if(data.button_icon_position == "right" && !_.isEmpty(data.button_icon)) { #> <i class="fa {{ data.button_icon }}"></i><# } #></a>
        <# } #>
        </div>
        <div class="case-study-img">
        <img class="sppb-img-responsive" src="{{data.feature_image}}" alt="{{data.title}}">
		</div>
        </div>
		</div>';
		return $output;
	}
}
