<?php

/**
 * @package SP Page Builder
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2016 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */
//no direct accees
defined('_JEXEC') or die('restricted aceess');

class SppagebuilderAddonCuisine_menu extends SppagebuilderAddons {

    public function render() {
        $class = (isset($this->addon->settings->class) && $this->addon->settings->class) ? $this->addon->settings->class : '';
        $title = (isset($this->addon->settings->title) && $this->addon->settings->title) ? $this->addon->settings->title : '';

        // Addon
        $icon = (isset($this->addon->settings->icon) && $this->addon->settings->icon) ? $this->addon->settings->icon : '';
        $image = (isset($this->addon->settings->image) && $this->addon->settings->image) ? $this->addon->settings->image : '';
        $image_position = (isset($this->addon->settings->image_position) && $this->addon->settings->image_position) ? $this->addon->settings->image_position : '';


        $output = '<div class="sppb-addon sppb-addon-fancy-menu ' . $class . '">';
        $output .= '<div class="sppb-row sppb-no-gutter">';

        if (($image_position == 'position-left-top') || ($image_position == 'position-left-bottom')) {
            $output .= '<div class="sppb-col-sm-5 sbbp-img-container">';

            if ($image) {
                $output .= '<div class="' . $image_position . '">';
                $output .= '<img src="' . $image . '" alt="' . $title . '">';
                $output .= '</div>';
            }

            $output .= '</div>';
        }


        $output .= '<div class="sppb-col-sm-7">';
        $output .= '<div class="sppb-addon-content">';

        if ($title) {
            if ($icon) {
                $output .= '<i class="' . $icon . ' sppb-fancy-menu-icon"></i>';
            }
            $output .= '<h3 class="sppb-fancy-menu-title">' . $title . '</h3>';
        }

        $output .= '<div class="sp-fancy-menu-content"><ol>';

        if (count($this->addon->settings->sp_cuisine_menu_item)) {
            foreach ($this->addon->settings->sp_cuisine_menu_item as $key => $item) {
                $output .= '<li class="sppb-wow fadeInLeft" data-sppb-wow-delay="' . $key * 100 . 'ms">';
                $output .= '<h4>' . $item->title . '</h4>';
                $output .= '<span class="sppb-menu-price">' . $item->price . '</span>';
                $output .= '<div class="sppb-menu-dots"></div>';
                $output .= '<div class="sppb-menu-text">' . $item->content . '</div>';
                $output .= '</li>';
            }
        }

        $output .= '</ol></div>';

        $output .= '</div>';
        $output .= '</div>';

        if (($image_position == 'position-right-top') || ($image_position == 'position-right-bottom')) {
            $output .= '<div class="sppb-col-sm-5 sbbp-img-container">';

            if ($image) {
                $output .= '<div class="' . $image_position . '">';
                $output .= '<img src="' . (is_string($image) ? $image : $image->src) . '" alt="' . $title . '">';
                $output .= '</div>';
            }

            $output .= '</div>';
        }

        $output .= '</div>';
        $output .= '</div>';

        return $output;
    }

    public function css() {
        $addon_id = '#sppb-addon-' . $this->addon->id;

        $style = (isset($this->addon->settings->background) && $this->addon->settings->background) ? "background-color: " . $this->addon->settings->background . ";" : '';
        $style .= (isset($this->addon->settings->pattern) && $this->addon->settings->pattern) ? 'background-image:url(' . JURI::base() . '/' . $this->addon->settings->pattern . ');' : '';

        $css = '';
        if ($style) {
            $css .= $addon_id . ' .sppb-addon-content {';
            $css .= $style;
            $css .= '}';
        }

        return $css;
    }

    public static function getTemplate() {
        $output = '
            <#
                let contentClass = (!_.isEmpty(data.class) && data.class) ? data.class : "";
                let title = (!_.isEmpty(data.title) && data.title) ? data.title : "";
                let icon = (!_.isEmpty(data.icon) && data.icon) ? data.icon : "";
                let image = (!_.isEmpty(data.image) && data.image) ? data.image : "";
                let image_position = (!_.isEmpty(data.image_position) && data.image_position) ? data.image_position : "";
            #>

                <div class="sppb-addon sppb-addon-fancy-menu {{contentClass}}">
                <div class="sppb-row sppb-no-gutter">

                <# if((image_position=="position-left-top") || (image_position=="position-left-bottom")) { #>
                    <div class="sppb-col-sm-5 sbbp-img-container">

                    <# if(image) { #>
                        <div class="{{image_position}}">
                        <img src="{{image}}" alt="{{{title}}}">
                        </div>
                    <# } #>

                    </div>
                <# } #>


                <div class="sppb-col-sm-7">
                <div class="sppb-addon-content">

                <# if(title) {
                    if(icon) {
                    #>
                        <i class="{{icon}} sppb-fancy-menu-icon"></i>
                    <# } #>
                    <h3 class="sppb-fancy-menu-title">{{{title}}}</h3>
                <# } #>

                <div class="sp-fancy-menu-content">
                <ol>

                <# if((data.sp_cuisine_menu_item).length) {
                    _.each(data.sp_cuisine_menu_item, function(item, key) {
                    #>
                        <li>
                        <h4>{{{item.title}}}</h4>
                        <span class="sppb-menu-price">{{item.price}}</span>
                        <div class="sppb-menu-dots"></div>
                        <div class="sppb-menu-text">{{{item.content}}}</div>
                        </li>
                    <# }) #>
                <# } #>

                </ol>
                </div>

                </div>
                </div>

                <# if((image_position=="position-right-top") || (image_position=="position-right-bottom")) { #>
                    <div class="sppb-col-sm-5 sbbp-img-container">

                    <# if(image) { #>
                        <div class="{{image_position}}">
                        <img src="{{image}}" alt="{{{title}}}">
                        </div>
                    <# } #>

                    </div>
                <# } #>

                </div>
                </div>
                ';
        return $output;
    }

}
