<?php
/**
 * @package SP Page Builder
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2022 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

//no direct accees
defined ('_JEXEC') or die ('restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Language\Text;


$user   = Factory::getUser();
$input  = Factory::getApplication()->input;
$view   = $input->get('view', null, 'STRING');
$option = $input->get('option', null, 'STRING');
$layout = $input->get('layout', null, 'STRING');

if ($user->authorise('core.manage', 'com_sppagebuilder')) { ?>

<ul id="sp-pagebuiler-menu" class="nav <?php echo ($layout == 'edit') ? 'disabled': ''; ?>">
	<li class="dropdown <?php echo ($option == 'com_sppagebuilder' && $layout != 'edit') ? 'active': ''; ?> <?php echo ($layout == 'edit') ? 'disabled': ''; ?> ">

	<?php if($layout == 'edit') : ?>
		<a class="no-dropdown">
			<?php echo Text::_('MOD_MENU_COM_SPPAGEBUILDER');?>
		</a>
	<?php else : ?>
		<a class="dropdown-toggle" data-toggle="dropdown" href="#">
			<?php echo Text::_('MOD_MENU_COM_SPPAGEBUILDER');?> <span class="caret"></span>
		</a>
		<ul aria-labelledby="dropdownMenu" role="menu" class="dropdown-menu">
			<li <?php echo ($option == 'com_sppagebuilder' && $view == 'page') ? 'class="active"': '';?>>
				<a href="<?php echo Route::_('index.php?option=com_sppagebuilder&task=page.redirectSite&landing=create'); ?>">
					<?php echo Text::_('MOD_MENU_COM_SPPAGEBUILDER_ADD_PAGE');?>
				</a>
			</li>
			
				<li <?php echo ($option == 'com_sppagebuilder' && ($view == '' || $view == 'pages') ) ? 'class="active"': '';?>>
				<a href="<?php echo Route::_('index.php?option=com_sppagebuilder&task=page.redirectSite&landing=dashboard'); ?>">
					<?php echo Text::_('MOD_MENU_COM_SPPAGEBUILDER_PAGES');?>
				</a>
			</li>
			
			<li <?php echo ($option == 'com_sppagebuilder' && ($view == '' || $view == 'pages') ) ? 'class="active"': '';?>>
				<a href="<?php echo Route::_('index.php?option=com_sppagebuilder'); ?>">
					<?php echo Text::_('MOD_MENU_COM_SPPAGEBUILDER');?>
				</a>
			</li>


		 
		 
		 
	 

	 
		</ul>
	<?php endif; ?>
	</li>
</ul>

<?php
}
