<?php

/**
 * @package SP Page Builder
 * @author JoomShaper https: //www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http: //www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */
//no direct access
defined('_JEXEC') or die('Restricted Access');

use Joomla\CMS\Language\Text;

SpAddonsConfig::addonConfig([
    'type'       => 'repeatable',
    'addon_name' => 'sp_decoraproject',
    'category'   => 'decora',
    'title'      => Text::_('COM_SPPAGEBUILDER_ADDON_DECORAPROJECT'),
    'desc'       => Text::_('COM_SPPAGEBUILDER_ADDON_DECORAPROJECT_DESC'),
    'settings' => [

        'general' => [
            'title'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_GENERAL'),
            'fields' => [

                'admin_label' => [
                    'type'  => 'text',
                    'title' => Text::_('COM_SPPAGEBUILDER_ADDON_ADMIN_LABEL'),
                    'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_ADMIN_LABEL_DESC'),
                    'std'   => ''
                ],
                'class' => [
                    'type'  => 'text',
                    'title' => Text::_('COM_SPPAGEBUILDER_ADDON_CLASS'),
                    'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_CLASS_DESC'),
                    'std'   => ''
                ],

                // 1) Outer repeatable: sp_decoraproject_item
                'sp_decoraproject_item' => [
                    'title' => Text::_('COM_SPPAGEBUILDER_ADDON_DECORAPROJECT_ITEMS'),
                    'type'  => 'repeatable',
                    'attr' => [

                        // Sub‐Tab: "general" fields for each sp_decoraproject_item
                        'general' => [
                            'title'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_GENERAL'),
                            'fields' => [
                                'day' => [
                                    'type'  => 'text',
                                    'title' => Text::_('COM_SPPAGEBUILDER_ADDON_DECORAPROJECT_ITEM_DAY'),
                                    'std'   => 'Sun',
                                ],
                            ],
                        ],

                        'inner_items' => [
                            'title'  => Text::_('COM_SPPAGEBUILDER_ADDON_DECORAPROJECT_DAY_ITEM'),
                            'fields' => [
                                'decoraproject_inner_items' => [
                                    'type' => 'repeatable',

                                    'attr' => [
                                        'general' => [
                                            'title'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_GENERAL'),
                                            'fields' => [
                                                'image' => [
                                                    'type'       => 'media',
                                                    'title'      => Text::_('COM_SPPAGEBUILDER_ADDON_DECORAPROJECT_ITEM_IMAGE'),
                                                    'desc'       => Text::_('COM_SPPAGEBUILDER_ADDON_DECORAPROJECT_ITEM_IMAGE_DESC'),
                                                    'show_input' => true,
                                                    'std'        => 'https://sppagebuilder.com/addons/image/image1.jpg'
                                                ],
                                                'content' => [
                                                    'type'  => 'text',
                                                    'title' => Text::_('COM_SPPAGEBUILDER_ADDON_DECORAPROJECT_ITEM_CONTENT'),
                                                    'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_DECORAPROJECT_ITEM_CONTENT_DESC'),
                                                    'std'   => 'Felix Meritis Amsterdam'
                                                ],
                                                'use_link' => [
                                                    'type'  => 'checkbox',
                                                    'title' => Text::_('COM_SPPAGEBUILDER_ADDON_HEADING_USE_LINK'),
                                                    'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_HEADING_USE_LINK_DESC'),
                                                    'std'   => 0
                                                ],
                                                'content_link' => [
                                                    'type'        => 'text',
                                                    'title'       => Text::_('COM_SPPAGEBUILDER_GLOBAL_LINK'),
                                                    'desc'        => Text::_('COM_SPPAGEBUILDER_GLOBAL_LINK_DESC'),
                                                    'placeholder' => 'http://',
                                                    'std'         => '',
                                                    'depends'     => [
                                                        ['use_link', '=', 1]
                                                    ]
                                                ],
                                            ],
                                        ],
                                    ],
                                ],

                            ],
                        ],

                    ],
                ],

            ],
        ],
    ],
]);