<?php
/**
 * @package SP Page Builder
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2019 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
//no direct accees
defined ('_JEXEC') or die ('Restricted access');

class SppagebuilderAddonDecoraproject extends SppagebuilderAddons {

	public function render() {
		// Variables
		$settings = $this->addon->settings;
		$class 	= (isset($settings->class) && $settings->class) ? $settings->class : '';
		$column = (isset($settings->column) && $settings->column) ? $settings->column : 3;
		
		$output  = '<div id="sppb-decoraproject-'. $this->addon->id .'" class="sppb-decoraproject ' . $class . '">';
			$output .= '<div class="sppb-addon-content sppb-tab tabs-tab">';
				$output .='<ul class="sppb-nav sppb-nav-tabs" role="tablist">';
					foreach ($settings->sp_decoraproject_item as $key => $tab) {
						$output .='<li class="'. ( ($key==0) ? "active" : "").'">';
						$output .= '<a data-toggle="sppb-tab" id="sppb-content-' . ((int) $this->addon->id + $key) . '" class="" href="#sppb-tab-' . ((int) $this->addon->id + $key) . '" role="tab" aria-controls="sppb-tab-' . ((int) $this->addon->id + $key) . '" aria-selected="' . (($key == 0) ? "true" : "false") . '">' . $tab->day . '</a>';
						$output .='</li>';
					}
				$output .='</ul>';

				//Tab Contnet
				$output .='<div class="sppb-tab-content sppb-tab-tabs-content">';
					foreach ($settings->sp_decoraproject_item as $key => $item) {

						$output .='<div id="sppb-tab-'. ((int) $this->addon->id + $key) .'" class="sppb-tab-pane sppb-fade'. ( ($key==0) ? " active in" : "").'" role="tabpanel" aria-labelledby="sppb-content-'. ((int) $this->addon->id + $key) .'">';

							$output .='<div class="sppb-decoraproject">';
								foreach ($item->decoraproject_inner_items as $key => $inner_item) {
									
									$src = "";
									if (isset($inner_item->image)) {
										if (is_object($inner_item->image)) {
											$src = $inner_item->image->src;
										} elseif (is_string($inner_item->image)) {
											$src = $inner_item->image;
										}
										if(strpos($src, "http://") === 0 || strpos($src, "https://") === 0){
											$src = $src;
										} else {
											$src = JURI::base() . $src;
										}
									}

									$output .='<div class="sppb-decoraproject-item">';
										$output .= '<div class="sppb-decoraproject-item-wrap">';
										// $output .= (isset($inner_item->image->src)) ? '<img src="'. $inner_item->image->src .'"></img>' : '';
										$output .= '<img src="'. $src .'"></img>';
										$output .= '<div class="sppb-decoraproject-content-wrap">';
											$output .= '<h3 class="sppb-decoraproject-content">';
											if($inner_item->content_link && $inner_item->use_link){
											$output .= '<a href="'. $inner_item->content_link .'">';
											}
											$output .= $inner_item->content ;
											if($inner_item->content_link && $inner_item->use_link){
											$output .= '</a>' ;
											}
											$output .= '</h3>';
										$output .='</div>';
									$output .='</div>';

									$output .='</div>'; //.sppb-col-md-3
								}
							$output .='</div>'; //.sppb-row
						$output .='</div>'; //Tab item
					}
				$output .='</div>';//.sppb-tab-content

			$output .= '</div>'; //.sppb-tab
		$output .= '</div>'; //.sppb-decoraproject

		return $output;
	}

	public static function getTemplate(){
		$output = '
			<div id="sppb-decoraproject-{{data.id}}" class="sppb-decoraproject {{data.class}}">
			<div class="sppb-addon-content sppb-tab tabs-tab">
				<ul class="sppb-nav sppb-nav-tabs" role="tablist">
					<# _.each (data.sp_decoraproject_item, function( tab, key) {
						let activeValue = (key == 0) ? "active" : "";
						let activeIn 		= (key == 0) ? " active in" : "";
						let keyValue 		= (key == 0) ? "true" : "false";
						#>
						<li class="{{activeValue}}">
							<a data-toggle="sppb-tab" id="sppb-content-{{data.id + key}}" class="" href="#sppb-tab-{{data.id + key}}" role="tab" aria-controls="sppb-tab-{{data.id + key}} aria-selected="{{keyValue}}">{{tab.day}}</a>
						</li>
					<# }) #>
				</ul>

				<div class="sppb-tab-content sppb-tab-tabs-content">
					<# _.each (data.sp_decoraproject_item, function(item, key) {
						let activeIn 		= (key == 0) ? " active in" : "";
					#>

						<div id="sppb-tab-{{data.id + key}}" class="sppb-tab-pane sppb-fade {{activeIn}}" role="tabpanel" aria-labelledby="sppb-content-{{data.id + key}}">

							<div class="sppb-decoraproject">
								<# _.each (item.decoraproject_inner_items, function(inner_item, key) {
									let timeData 					= (!_.isEmpty(inner_item.time) && !_.isEmpty(inner_item.time)) ? \'<span class="sppb-decoraproject-time">\' + inner_item.time + \'</span>\' : "";
									let title 				= (!_.isEmpty(inner_item.title) && !_.isEmpty(inner_item.title)) ? \'<span class="sppb-decoraproject-title"><i class="fa fa-map-marker"></i>\' + inner_item.title + \'</span>\' : "";
									let columnSize = _.round(12/data.column);


								let image_src = "";
								if(typeof inner_item.image !== "undefined") {
									if(typeof inner_item.image === "object"){
										if(inner_item.image.src.indexOf("http://") === 0 || inner_item.image.src.indexOf("https://") === 0){
											image_src = `src=${inner_item.image.src}`;
										} else {
											image_src = `src=${pagebuilder_base + inner_item.image.src}`;
										}
									} else {
										if(inner_item.image.indexOf("http://") === 0 || inner_item.image.indexOf("https://") === 0){
											image_src = `src=${inner_item.image}`;
										} else {
											image_src = `src=${pagebuilder_base + inner_item.image}`;
										}
									}
								}


								#>
									<div class="sppb-decoraproject-item">
										<div class="sppb-decoraproject-content-wrap">
											<div class="sppb-decoraproject-item-wrap">
												<# { #>
													<img {{image_src}}></img>
												<# } #>
												<h3 class="sppb-decoraproject-content">
												<# if(!_.isEmpty(inner_item.content_link) && inner_item.use_link){ #>
													<a href="{{inner_item.content_link}}">
												<# } #>
												{{{inner_item.content}}}
												<# if(!_.isEmpty(inner_item.content_link) && !_.isEmpty(inner_item.use_link)){ #>
													</a>
												<# } #>
												</h3>
											</div>
										</div>
									</div>
								<# }) #>
							</div>
						</div>
					<# }) #>
				</div>

			</div>
		</div>
		';

		return $output;
	}
}