<?php

/**
 * @package SP Page Builder
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2018 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */
//no direct accees
defined('_JEXEC') or die('Restricted access');

class SppagebuilderAddonRental_feature extends SppagebuilderAddons
{

    public function render()
    {

        $class = (isset($this->addon->settings->class) && $this->addon->settings->class) ? ' ' . $this->addon->settings->class : '';
        $class .= (isset($this->addon->settings->alignment) && $this->addon->settings->alignment) ? ' ' . $this->addon->settings->alignment : ' sppb-text-center';
        $title = (isset($this->addon->settings->title) && $this->addon->settings->title) ? $this->addon->settings->title : '';
        $heading_selector = (isset($this->addon->settings->heading_selector) && $this->addon->settings->heading_selector) ? $this->addon->settings->heading_selector : 'h2';

        //options
        $reverse_layout = (isset($this->addon->settings->reverse_layout) && $this->addon->settings->reverse_layout) ? $this->addon->settings->reverse_layout : 0;
        $use_link = (isset($this->addon->settings->use_link) && $this->addon->settings->use_link) ? $this->addon->settings->use_link : false;
        $title_link = ($use_link) ? ((isset($this->addon->settings->title_link) && $this->addon->settings->title_link) ? $this->addon->settings->title_link : '') : false;
        $link_target = (isset($this->addon->settings->link_new_tab) && $this->addon->settings->link_new_tab) ? 'target="_blank"' : '';
        $title_icon = (isset($this->addon->settings->title_icon) && $this->addon->settings->title_icon) ? $this->addon->settings->title_icon : '';
        $title_icon_position = (isset($this->addon->settings->title_icon_position) && $this->addon->settings->title_icon_position) ? $this->addon->settings->title_icon_position : 'before';
        $title_icon_color = (isset($this->addon->settings->title_icon_color) && $this->addon->settings->title_icon_color) ? $this->addon->settings->title_icon_color : '';
        $layout = (isset($this->addon->settings->layout) && $this->addon->settings->layout) ? $this->addon->settings->layout : '';
        $image = (isset($this->addon->settings->image) && $this->addon->settings->image) ? $this->addon->settings->image : '';
        $alt_text = (isset($this->addon->settings->alt_text) && $this->addon->settings->alt_text) ? $this->addon->settings->alt_text : '';
        $text = (isset($this->addon->settings->text) && $this->addon->settings->text) ? $this->addon->settings->text : '';
        $text_alignment = (isset($this->addon->settings->text_alignment) && $this->addon->settings->text_alignment) ? $this->addon->settings->text_alignment : '';
        $rental_price = (isset($this->addon->settings->rental_price) && $this->addon->settings->rental_price) ? $this->addon->settings->rental_price : '';
        $rental_price_info = (isset($this->addon->settings->rental_price_info) && $this->addon->settings->rental_price_info) ? $this->addon->settings->rental_price_info : '';

        $layout_class = '';
        if ($layout == '') {
            $layout_class = 'layout-default';
        } elseif ($layout == 'basic') {
            $layout_class = 'layout-basic';
        } elseif ($layout == 'advanced') {
            $layout_class = 'layout-advanced';
        } elseif ($layout == 'pro') {
            $layout_class = 'layout-pro';
        } elseif ($layout == 'offer_deal') {
            $layout_class = 'layout-offers';
        }

        if ($reverse_layout) {
            $reverse_layout = 'reverse-layout';
        }
        $output = '';
        $output .= '<div class="sppb-addon sppb-addon-rental-feature' . $class . ' ' . $layout_class . '">';
        if ($image) {
            $output .= '<div class="sppb-addon-rental-img-wrap">';

//            $output .= '<img class="sppb-img-responsive" src="' . (is_string($image) ? $image : $image->src) . '" alt="' . $alt_text . '">';
            if (is_object($image) && isset($image->src)) {
                $output .= '<img class="sppb-img-responsive" src="' . $image->src . '" alt="' . $alt_text . '">';
            } elseif (is_string($image)) {
                $output .= '<img class="sppb-img-responsive" src="' . $image . '" alt="' . $alt_text . '">';
            }

            if ($layout_class == 'layout-advanced') {
                $output .= '<div class="sppb-addon-rental-info-overlay">';
                if (isset($this->addon->settings->list_item) && is_array($this->addon->settings->list_item) && count($this->addon->settings->list_item)) {
                    $output .= '<ul class="feature-list-items">';
                    foreach ($this->addon->settings->list_item as $key => $item) {
                        $output .= '<li>';
                        if (isset($item->icon) && $item->icon != '') {
                            $output  .= '<i class="fa ' . $item->icon . '"></i> ';
                        }
                        if (isset($item->title) && $item->title != '') {
                            $output .= '<p class="list-title">' . $item->title . '</p>';
                        }
                        $output .= '</li>';
                    }
                    $output .= '</ul>';
                }
                if ($text) {
                    $output .= '<div class="sppb-addon-content' . ' ' . $text_alignment . '">';
                    $output .= $text;
                    $output .= '</div>';
                }
                $output .= '</div>'; //.info-overlay
            }
            $output .= '</div>'; //.sppb-addon-rental-img-wrap
        }
        $output .= '<div class="sppb-addon-rental-feature-details' . ' ' . $reverse_layout . '">';
        if ($layout_class == 'layout-pro') {
            $output .= '<div class="sppb-addon-title-wrapper">';
        }
        if ($layout_class == 'layout-basic') {
            $output .= '<div class="sppb-addon-title-wrap">';
        }
        if ($title) {
            $output .= '<' . $heading_selector . ' class="sppb-addon-title">';
            if ($title_link && is_string($title_link)) {
                $output .= '<a ' . $link_target . ' href="' . htmlspecialchars($title_link, ENT_QUOTES, 'UTF-8') . '">';
            }
            if ($title_icon && $title_icon_position == 'before') {
                $output .= '<span class="fa ' . $title_icon . ' sppb-addon-title-icon"></span> ';
            }
            $output .= nl2br(htmlspecialchars($title, ENT_QUOTES, 'UTF-8'));
            if ($title_icon && $title_icon_position == 'after') {
                $output .= ' <span class="fa ' . $title_icon . ' sppb-addon-title-icon"></span>';
            }
            if ($title_link && is_string($title_link)) {
                $output .= '</a>';
            }
            $output .= '</' . $heading_selector . '>';
        }
        
        if ($layout_class != 'layout-advanced') {
            if ($layout_class != 'layout-pro') {
                if ($text || isset($this->addon->settings->list_item) && is_array($this->addon->settings->list_item) && count($this->addon->settings->list_item) && $layout_class != 'layout-pro') {
                    $output .= '<div class="sppb-addon-content' . ' ' . $text_alignment . '">';
                    $output .= $text;
                    $output .= '</div>';
                    if ($layout_class == 'layout-default') {
                        $output .= '<div class="feature-list-items-wrapper">';
                    }
                    if (isset($this->addon->settings->list_item) && is_array($this->addon->settings->list_item) && count($this->addon->settings->list_item)) {
                        $output .= '<ul class="feature-list-items">';
                        foreach ($this->addon->settings->list_item as $key => $item) {
                            $output .= '<li>';
                            if (isset($item->icon) && $item->icon != '') {
                                $output  .= '<i class="fa ' . $item->icon . '"></i> ';
                            }
                            $output .= '<p class="list-title">' . $item->title . '</p>';
                            $output .= '</li>';
                        }
                        $output .= '</ul>';
                    }
                }
            }
            if ($layout_class == 'layout-basic') {
                $output .= '</div>';
            }
            $output .= '<div class="sppb-addon-rental-price">';
            if ($layout_class == 'layout-basic') {
                $output .= '<span class="price-info">' . $rental_price_info . '</span>';
            }
            $output .= '<span class="rental-numbers">' . $rental_price . '</span>';
            if ($layout_class != 'layout-basic') {
                $output .= '<span class="price-info">' . $rental_price_info . '</span>';
            }
            $output .= '</div>';
            if ($layout_class == 'layout-default') {
                $output .= '</div>';
            }
            if ($layout_class == 'layout-pro') {
                $output .= '</div>';
            }
            if ($text && $layout_class == 'layout-pro') {
                $output .= '<div class="sppb-addon-content' . ' ' . $text_alignment . '">';
                $output .= $text;
                $output .= '</div>';
            }
            if ($layout_class == 'layout-pro') {
                if (isset($this->addon->settings->list_item) && is_array($this->addon->settings->list_item) && count($this->addon->settings->list_item)) {
                    $output .= '<ul class="feature-list-items">';
                    foreach ($this->addon->settings->list_item as $key => $item) {
                        $output .= '<li>';
                        if (isset($item->icon) && $item->icon != '') {
                            $output  .= '<i class="fa ' . $item->icon . '"></i> ';
                        }
                        if (isset($item->title) && $item->title != '') {
                            $output .= '<p class="list-title">' . $item->title . '</p>';
                        }
                        $output .= '</li>';
                    }
                    $output .= '</ul>';
                }
            }
        }
        if ($layout_class == 'layout-advanced') {
            $output .= '<div class="sppb-addon-rental-price">';
            $output .= '<span class="rental-numbers">' . $rental_price . '</span>';
            $output .= '<span class="price-info">' . $rental_price_info . '</span>';
            $output .= '</div>';
        }
        $output .= '</div>';
        $output .= '</div>';

        return $output;
    }

    public function css()
    {
        $addon_id = '#sppb-addon-' . $this->addon->id;

        $style = '';
        $style_sm = '';
        $style_xs = '';

        $style_box_height = '';
        $style_box_height_sm = '';
        $style_box_height_xs = '';

        $style .= (isset($this->addon->settings->title_margin) && $this->addon->settings->title_margin) ? 'margin: ' . $this->addon->settings->title_margin  . '; ' : '';
        $style_sm .= (isset($this->addon->settings->title_margin_sm) && $this->addon->settings->title_margin_sm) ? 'margin: ' . $this->addon->settings->title_margin_sm  . '; ' : '';
        $style_xs .= (isset($this->addon->settings->title_margin_xs) && $this->addon->settings->title_margin_xs) ? 'margin: ' . $this->addon->settings->title_margin_xs  . '; ' : '';

        $style .= (isset($this->addon->settings->title_padding) && $this->addon->settings->title_padding) ? 'padding: ' . $this->addon->settings->title_padding  . '; ' : '';
        $style_sm .= (isset($this->addon->settings->title_padding_sm) && $this->addon->settings->title_padding_sm) ? 'padding: ' . $this->addon->settings->title_padding_sm  . '; ' : '';
        $style_xs .= (isset($this->addon->settings->title_padding_xs) && $this->addon->settings->title_padding_xs) ? 'padding: ' . $this->addon->settings->title_padding_xs  . '; ' : '';

        $style_box_height .= (isset($this->addon->settings->box_height) && $this->addon->settings->box_height) ? 'height: ' . $this->addon->settings->box_height  . 'px; ' : '';
        $style_box_height_sm .= (isset($this->addon->settings->box_height_sm) && $this->addon->settings->box_height_sm) ? 'height: ' . $this->addon->settings->box_height_sm  . 'px; ' : '';
        $style_box_height_xs .= (isset($this->addon->settings->box_height_xs) && $this->addon->settings->box_height_xs) ? 'height: ' . $this->addon->settings->box_height_xs  . 'px; ' : '';

        $heading_selector = (isset($this->addon->settings->heading_selector) && $this->addon->settings->heading_selector) ? $this->addon->settings->heading_selector : 'h2';

        $title_icon = (isset($this->addon->settings->title_icon) && $this->addon->settings->title_icon) ? $this->addon->settings->title_icon : '';
        $title_icon_color = (isset($this->addon->settings->title_icon_color) && $this->addon->settings->title_icon_color) ? $this->addon->settings->title_icon_color : '';

        if (isset($this->addon->settings->title_text_shadow) && is_object($this->addon->settings->title_text_shadow)) {
            $ho = (isset($this->addon->settings->title_text_shadow->ho) && $this->addon->settings->title_text_shadow->ho != '') ? $this->addon->settings->title_text_shadow->ho . 'px' : '0px';
            $vo = (isset($this->addon->settings->title_text_shadow->vo) && $this->addon->settings->title_text_shadow->vo != '') ? $this->addon->settings->title_text_shadow->vo . 'px' : '0px';
            $blur = (isset($this->addon->settings->title_text_shadow->blur) && $this->addon->settings->title_text_shadow->blur != '') ? $this->addon->settings->title_text_shadow->blur . 'px' : '0px';
            $color = (isset($this->addon->settings->title_text_shadow->color) && $this->addon->settings->title_text_shadow->color != '') ? $this->addon->settings->title_text_shadow->color : '';

            if (!empty($color)) {
                $style .= "text-shadow: {$ho} {$vo} {$blur} {$color};";
            }
        }

        $style .= (isset($this->addon->settings->title_text_transform) && $this->addon->settings->title_text_transform) ? 'text-transform: ' . $this->addon->settings->title_text_transform  . '; ' : '';
        $style_box_height .= (isset($this->addon->settings->box_height) && $this->addon->settings->box_height) ? 'height: ' . $this->addon->settings->box_height  . 'px; ' : '';

        $css = '';
        if ($style) {
            $css .= $addon_id . ' ' . $heading_selector . '.sppb-addon-title {' . $style . '}';
        }
        if ($style_box_height) {
            $css .= $addon_id . ' ' . '.sppb-addon-rental-feature-details {' . $style_box_height . '}';
        }

        if ($title_icon && $title_icon_color) {
            $css .= $addon_id . ' ' . $heading_selector . '.sppb-addon-title .sppb-addon-title-icon {color: ' . $title_icon_color . '}';
        }

        if ($style_sm) {
            $css .= '@media (min-width: 768px) and (max-width: 991px) {';
            $css .= $addon_id . ' ' . $heading_selector . '.sppb-addon-title {' . $style_sm . '}';
            $css .= '}';
        }

        if ($style_xs) {
            $css .= '@media (max-width: 767px) {';
            $css .= $addon_id . ' ' . $heading_selector . '.sppb-addon-title {' . $style_xs . '}';
            $css .= '}';
        }

        if ($style_box_height_sm) {
            $css .= '@media (min-width: 768px) and (max-width: 991px) {';
            $css .= $addon_id . ' ' . '.sppb-addon-rental-feature-details {' . $style_box_height_sm . '}';
            $css .= '}';
        }

        if ($style_box_height_xs) {
            $css .= '@media (max-width: 767px) {';
            $css .= $addon_id . ' ' . '.sppb-addon-rental-feature-details {' . $style_box_height_xs . '}';
            $css .= '}';
        }

        return $css;
    }

    public static function getTemplate()
    {
        $output = '
        <#
            var reverse_layout = (data.reverse_layout) ? "reverse-layout" : "";
            var link_target = (data.link_new_tab) ? \'target="_blank"\' : "";
            var layout = (data.layout) ? data.layout : "";

            var layout_class = "";
            if(layout == ""){
                layout_class = "layout-default";
            } else if(layout == "basic"){
                layout_class = "layout-basic";
            } else if(layout == "advanced"){
                layout_class = "layout-advanced";
            } else if(layout == "pro"){
                layout_class = "layout-pro";
            } else if(layout == "offer_deal"){
                layout_class = "layout-offers";
            }
            var box_height = "";
			var box_height_sm = "";
			var box_height_xs = "";
			if(data.box_height){
				if(_.isObject(data.box_height)){
                    if(data.box_height.md.trim() != ""){
                        box_height = data.box_height.md.split(" ").map(item => {
                            if(_.isEmpty(item)){
                                return "0";
                            }
                            return item;
                        }).join(" ")
                    }
                    if(data.box_height.sm.trim() != ""){
                        box_height_sm = data.box_height.sm.split(" ").map(item => {
                            if(_.isEmpty(item)){
                                return "0";
                            }
                            return item;
                        }).join(" ")
                    }
                    if(data.box_height.xs.trim() != ""){
                        box_height_xs = data.box_height.xs.split(" ").map(item => {
                            if(_.isEmpty(item)){
                                return "0";
                            }
                            return item;
                        }).join(" ")
                    }
				} else {
                    if(data.box_height.trim() != ""){
                        box_height = data.box_height.split(" ").map(item => {
                            if(_.isEmpty(item)){
                                return "0";
                            }
                            return item;
                        }).join(" ")
                    }
				}

            }
            
            var margin = "";
			var margin_sm = "";
			var margin_xs = "";
			if(data.title_margin){
				if(_.isObject(data.title_margin)){
                    if(data.title_margin.md.trim() != ""){
                        margin = data.title_margin.md.split(" ").map(item => {
                            if(_.isEmpty(item)){
                                return "0";
                            }
                            return item;
                        }).join(" ")
                    }
                    if(data.title_margin.sm.trim() != ""){
                        margin_sm = data.title_margin.sm.split(" ").map(item => {
                            if(_.isEmpty(item)){
                                return "0";
                            }
                            return item;
                        }).join(" ")
                    }
                    if(data.title_margin.xs.trim() != ""){
                        margin_xs = data.title_margin.xs.split(" ").map(item => {
                            if(_.isEmpty(item)){
                                return "0";
                            }
                            return item;
                        }).join(" ")
                    }
				} else {
                    if(data.title_margin.trim() != ""){
                        margin = data.title_margin.split(" ").map(item => {
                            if(_.isEmpty(item)){
                                return "0";
                            }
                            return item;
                        }).join(" ")
                    }
				}

			}

			var padding = "";
			var padding_sm = "";
			var padding_xs = "";
			if(data.title_padding){
				if(_.isObject(data.title_padding)){
					if(data.title_padding.md.trim() !== ""){
						padding = data.title_padding.md.split(" ").map(item => {
							if(_.isEmpty(item)){
								return "0";
							}
							return item;
						}).join(" ")
					}

					if(data.title_padding.sm.trim() !== ""){
						padding_sm = data.title_padding.sm.split(" ").map(item => {
							if(_.isEmpty(item)){
								return "0";
							}
							return item;
						}).join(" ")
					}

					if(data.title_padding.xs.trim() !== ""){
						padding_xs = data.title_padding.xs.split(" ").map(item => {
							if(_.isEmpty(item)){
								return "0";
							}
							return item;
						}).join(" ")
					}
				} else {
					padding = data.title_padding.split(" ").map(item => {
						if(_.isEmpty(item)){
							return "0";
						}
						return item;
					}).join(" ")
				}

            }
            
            var titleTextShadow = "";
			if(_.isObject(data.title_text_shadow)){
				let ho = data.title_text_shadow.ho || 0,
					vo = data.title_text_shadow.vo || 0,
					blur = data.title_text_shadow.blur || 0,
					color = data.title_text_shadow.color || 0;

                titleTextShadow = ho+\'px \'+vo+\'px \'+blur+\'px \'+color;
			}
        #>
        <style type="text/css">
            #sppb-addon-{{ data.id }} {{ data.heading_selector }}.sppb-addon-title{
                margin: {{ margin }};
                padding: {{ padding }};
                text-shadow: {{ titleTextShadow }};
                text-transform: {{ data.title_text_transform }};
            }

            #sppb-addon-{{ data.id }} .sppb-addon-rental-feature-details{
                height: {{ box_height }}px;
            }

            <# if(data.title_icon && data.title_icon_color) { #>
                #sppb-addon-{{ data.id }} {{ data.heading_selector }}.sppb-addon-title .sppb-addon-title-icon {
                    color: {{ data.title_icon_color }}
                }
            <# } #>

            @media (min-width: 768px) and (max-width: 991px) {
                #sppb-addon-{{ data.id }} .sppb-addon-rental-feature-details{
                    height: {{ box_height_sm }}px;
                }
                #sppb-addon-{{ data.id }} {{ data.heading_selector }}.sppb-addon-title{
                    margin: {{ margin_sm }};
                    padding: {{ padding_sm }};
                }
            }
            @media (max-width: 767px) {
                #sppb-addon-{{ data.id }} .sppb-addon-rental-feature-details{
                    height: {{ box_height_xs }}px;
                }
                #sppb-addon-{{ data.id }} {{ data.heading_selector }}.sppb-addon-title{
                    margin: {{ margin_xs }};
                    padding: {{ padding_xs }};
                }
            }
        </style>
        
        <div class="sppb-addon sppb-addon-rental-feature {{data.class}} {{layout_class}}">
        <# 

        let image = "";
        if(typeof data.image !== "undefined") {
            if(typeof data.image === "object"){
                if(data.image.src.indexOf("http://") === 0 || data.image.src.indexOf("https://") === 0){
                    image = `src=${data.image.src}`;
                } else {
                    image = `src=${pagebuilder_base + data.image.src}`;
                }
            } else {
                if(data.image.indexOf("http://") === 0 || data.image.indexOf("https://") === 0){
                    image = `src=${data.image}`;
                } else {
                    image = `src=${pagebuilder_base + data.image}`;
                }
            }
        }

        if(image){ #>
            <div class="sppb-addon-rental-img-wrap">
            <img class="sppb-img-responsive" {{image}} alt="{{data.alt_text}}">
            <# if(layout_class == "layout-advanced"){ #>
                <div class="sppb-addon-rental-info-overlay">
                <# if(data.list_item){ #>
                    <ul class="feature-list-items">
                    <# _.each (data.list_item, function(item, key) { #>
                        <li>
                        <# if(item.icon) { #>
                            <i class="fa {{item.icon}}"></i>
                        <# }
                        if(item.title) { #>
                            <p class="list-title">{{{item.title}}}</p>
                        <# } #>
                        </li>
                    <# }) #>
                    </ul>
                <# } #>
                <# if(data.text){ #>
                    <div class="sppb-addon-content {{data.text_alignment}}">
                    {{{data.text}}}
                    </div>
                <# } #>
                </div>
            <# } #>
            </div>
        <# } #>
        <div class="sppb-addon-rental-feature-details {{reverse_layout}}">
        <# if(layout_class == "layout-pro"){ #>
        <div class="sppb-addon-title-wrapper">
        <# }
        if(layout_class == "layout-basic"){ #>
            <div class="sppb-addon-title-wrap">
        <# }
        if(data.title) { #>
            <# if(data.use_link && data.title_link){ #><a {{ link_target }} href=\'{{ data.title_link }}\'><# } #>
                <{{ data.heading_selector }} class="sppb-addon-title">
                <# if(data.title_icon && data.title_icon_position == "before"){ #><span class="fa {{ data.title_icon }} sppb-addon-title-icon"></span> <# } #>
                {{{ data.title }}}
                <# if(data.title_icon && data.title_icon_position == "after"){ #> <span class="fa {{ data.title_icon }} sppb-addon-title-icon"></span><# } #>
                </{{ data.heading_selector }}>
            <# if(data.use_link && data.title_link){ #></a><# } #>
        <# }
        if(layout_class != "layout-advanced"){
            if(layout_class != "layout-pro"){
            if(data.text || data.list_item && layout_class != "layout-pro"){ #>
                <div class="sppb-addon-content {{data.text_alignment}}">
                {{{data.text}}}
                </div>
                <# if(layout_class == "layout-default"){ #>
                    <div class="feature-list-items-wrapper">
                <# }
                if(data.list_item){ #>
                    <ul class="feature-list-items">
                    <# _.each (data.list_item, function(item, key) { #>
                        <li>
                        <# if(item.icon) { #>
                            <i class="fa {{item.icon}}"></i> 
                        <# } #>
                        <p class="list-title">{{{item.title}}}</p>
                        </li>
                    <# }) #>
                    </ul>
                <# } #>
            <# }
            }
            if(layout_class == "layout-basic"){ #>
                </div>
            <# } #>
            <div class="sppb-addon-rental-price">
            <# if(layout_class == "layout-basic"){ #>
                <span class="price-info">{{{data.rental_price_info}}}</span>
            <# } #>
            <span class="rental-numbers">{{data.rental_price}}</span>
            <# if(layout_class != "layout-basic"){ #>
                <span class="price-info">{{{data.rental_price_info}}}</span>
            <# } #>
            </div>
            <# if(layout_class == "layout-default"){ #>
                </div>
            <# } #>
            <# if(layout_class == "layout-pro"){ #>
            </div>
            <# } #>
            <# if(data.text && layout_class == "layout-pro"){ #>
                <div class="sppb-addon-content {{data.text_alignment}}">
                {{{data.text}}}
                </div>
            <# } #>
            <# if(layout_class == "layout-pro"){ #>
                <# if(data.list_item){ #>
                    <ul class="feature-list-items">
                    <# _.each (data.list_item, function( item, key) { #>
                        <li>
                        <# if(item.icon) { #>
                            <i class="fa {{item.icon}}"></i>
                        <# } #>
                        <# if(item.title) { #>
                            <p class="list-title">{{{item.title}}}</p>
                        <# } #>
                        </li>
                    <# }) #>
                    </ul>
                <# } #>
            <# } #>
        <# } #>
        <# if(layout_class == "layout-advanced"){ #>
            <div class="sppb-addon-rental-price">
            <span class="rental-numbers">{{data.rental_price}}</span>
            <span class="price-info">{{{data.rental_price_info}}}</span>
            </div>
        <# } #>
        </div>
        </div>
        ';

        return $output;
    }
}
