<?php
/**
* @package com_spproperty
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2018 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

// No Direct Access
defined ('_JEXEC') or die('Resticted Aceess');


$doc = JFactory::getDocument();
$doc->addScriptdeclaration('var spproperty_url="' . JURI::base() . 'index.php?option=com_spproperty";');
$emi_calculation = $doc->countModules('spproperty-details-emi-calculator');
?>


<div id="spproperty" class="spproperty spproperty-view-property">
    <?php if ($this->carousel == 'alternative') { ?>
    <div class="owl-carousel owl-theme" id="spproperty-slider">
        <?php if (!empty($this->item->gallery)) { ?>
            <?php foreach ($this->item->gallery as $key => $image) { ?>
                <div class="spproperty-img item">
                    <img alt="<?php echo $image['alt_text'] ?>" src="<?php echo SppropertyHelper::getThumbs($image['photo'], 'property_thumbnail_tower', '640x715'); ?>">
                </div>
            <?php } ?>
        <?php } ?>
    </div><!-- /.spproperty-slider -->
    <?php } else { ?>
    <div class="owl-carousel owl-theme" id="spproperty-slider-alt">
        <?php if (!empty($this->item->gallery)) { ?>
            <?php foreach ($this->item->gallery as $key => $image) { ?>
                <div data-dot="<button role='button' class='owl-dot' style='background-image: url(<?php echo SppropertyHelper::getThumbs($image['photo'], 'property_thumbnail', '640x715') ?>); width: 262px; height: 185px; background-repeat: round;' ></button>">
                    <img src="<?php echo JURI::root() . $image['photo']; ?>" alt="<?php echo $image['alt_text'] ?>">
                </div>
            <?php } ?>
        <?php } ?>
    </div><!-- /.spproperty-slider -->
    <div>
        <div class="property-dots-container"></div>
    </div>
    <?php } ?>

    <div class="container">
        <div class="row">
            <div class="col-md-7 col-xs-12">
                <div class="spproperty-details-title-wrap">
                    <p class="spproperty-status-tag">
                        <?php 
                        $status_class = "";
                        $featured_class  = "";
                        if($this->item->property_status == "rent"){
                            $status_class = "badge-rent";
                        }
                        if ($this->item->featured == 1) {
                            $featured_class = "badge-featured";
                        }?>
                        <span class="badge badge-primary <?php echo $status_class; ?>"><?php echo $this->item->property_status_txt; ?></span>
                        <?php if ($this->item->featured == 1) { ?>
                            <span class="badge badge-primary <?php echo $featured_class; ?>"><?php echo JText::_('COM_SPPROPERTY_FEATURED'); ?></span>
                        <?php } ?>
                    </p>
                    <h4 class="spproperty-title">
                        <?php echo $this->item->title; ?>
                    </h4>
                    <h5 class="spproperty-location">
                        <i class="fa fa-map-marker"></i> <?php echo $this->item->city; ?>
                        <p class="loc-info"><?php echo $this->item->address; ?></p>
                    </h5>
                    <?php if ($this->item->psize) { ?>
                        <div class="spproperty-sqft-info d-flex">
                            <img src="<?php echo JURI::base() . '/images/estate/icon_sqf.svg'?>" alt="sqf">
                            <span>
                                <?php echo $this->item->psize; ?> <?php echo empty(trim($this->cParams['measurement'])) ?  JText::_('COM_SPPROPERTY_PROPERTIES_SQFT') : $this->cParams['measurement']; ?>
                            </span>
                        </div>
                    <?php } ?>
                </div><!-- /.spproperty-details-title -->
                <?php if (!empty($this->item->lvl_fltno) ||
                    !empty($this->item->beds) ||
                    !empty($this->item->baths) ||
                    !empty($this->item->garages)
                ) { ?>
                    <div class="spproperty-overview-list">
                        <?php if ($this->item->lvl_fltno) { ?>
                            <div>
                                <i class="fa fa-building" aria-hidden="true"></i>
                                <?php echo $this->item->lvl_fltno; ?>
                            </div>
                        <?php } if ($this->item->beds) { ?>
                            <div>
                                <i class="fa fa-bed" aria-hidden="true"></i>
                                <?php echo $this->item->beds . ' ' . JText::_('COM_SPPROPERTY_PROPERTIES_BEDROOMS'); ?>
                            </div>
                        <?php } if ($this->item->baths) { ?>
                            <div>
                                <i class="fa fa-sign-language" aria-hidden="true"></i>
                                <?php echo $this->item->baths . ' ' . JText::_('COM_SPPROPERTY_PROPERTIES_BATHS'); ?>
                            </div>
                        <?php } if ($this->item->garages) { ?>
                            <div>
                                <i class="fa fa-bus" aria-hidden="true"></i>
                                <?php echo $this->item->garages . ' ' . JText::_('COM_SPPROPERTY_PROPERTIES_PARKING'); ?>
                            </div>
                        <?php } ?>
                    </div>
                <?php } ?>

                <div class="spproperty-short-info">
                    <div class="spproperty-short-overview-wrap">
                        <?php if ($this->item->description) { ?>
                            <div class="spproperty-short-overview-text">
                                <?php echo $this->item->description; ?>
                            </div>
                        <?php } ?>
                    </div>
                </div>

                <?php if (count($this->featureinfos) && $this->featureinfos) {
                    ?>
                    <div class="spproperty-feature-overview-wrap d-flex spproperty-feature-item">
                        <div class="title-wrapper">
                            <h3 class="spproperty-title"><?php echo JText::_('COM_SPPROPERTY_ALL_AMENITIES') ?></h3>
                            <p>
                                <?php echo $this->item->features_text; ?>
                            </p>
                        </div>
                        <ul class="spproperty-feature-overview-list second-child">
                            <?php foreach ($this->featureinfos as $featureinfo) { ?>
                                <li>
                                    <div class="spproperty-feature-overview-signle-list">
                                        <?php if ($featureinfo->icon_type == 0) { ?>
                                            <?php if (!empty($featureinfo->icon)) { ?>
                                                <i class="<?php echo $featureinfo->icon; ?>" aria-hidden="true"></i>
                                            <?php } else { ?>
                                                <i class="fa fa-check" aria-hidden="true"></i>
                                            <?php } ?>
                                        <?php } else { ?>
                                            <?php if (!empty($featureinfo->image)) { ?>
                                                <img src="<?php echo $featureinfo->image; ?>" alt="" class="spproperty-features-image">
                                            <?php } else { ?>
                                                <i class="fa fa-check" aria-hidden="true"></i>
                                            <?php } ?>
                                        <?php } ?>
                                        <span><?php echo $featureinfo->title; ?></span>
                                    </div>
                                </li>
                            <?php } ?>
                        </ul> <!-- /.spproperty-feature-overview-list -->
                    </div>
                <?php } // has features  ?>
                
                <?php if ($this->item->address) { ?>
                    <div class="spproperty-map-widget d-flex spproperty-feature-item">
                        <div class="title-wrapper">
                            <h3 class="spproperty-title"><?php echo JText::_('COM_SPPROPERTY_MAP') ?></h3>
                        </div>
                        <div class="spproperty-map-wrap second-child">
                            <div class="spproperty-map-content">
                                <p class="spproperty-project-address">
                                    <?php echo $this->item->address; ?>
                                </p>
                            </div>
                            <div class="spproperty-map">
                                <?php if ($this->map_type == 'google'){ ?>
                                    <div class="spproperty-property-map">
                                        <div id="spproperty-property-map" class="spproperty-gmap-canvas" data-lat="<?php echo $this->map[0]; ?>" data-lng="<?php echo $this->map[1]; ?>" style="height:300px">
                                        </div>
                                    </div>
                                <?php }else{ ?>
                                    <div id="map"></div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                <?php } ?>

                <?php if (filter_var($this->item->video, FILTER_VALIDATE_URL)) { ?>
                    <!-- Featue Video Overview -->
                    <div class="spproperty-video-overview-wrap d-flex spproperty-feature-item">
                        <div class="title-wrapper">
                            <h3 class="spproperty-title"><?php echo JText::_('COM_PROPERTY_PROPERTY_VIDEO_TITLE_TEXT'); ?></h3>
                            <p>
                                <?php echo $this->item->video_text; ?>
                            </p>
                        </div>
                        <div class="spproperty-video-overview second-child">
                            <div class="spproperty-video">
                                <iframe class="spproperty-embed-responsive-item" src="<?php echo $this->videosrc; ?>" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>
                                <div class="clearfix"></div>
                            </div><!-- /.spproperty-video -->
                        </div> <!-- /.spproperty-feature-overview -->
                    </div>
                <?php } ?>

                <?php if ($this->item->floor_plans && count($this->item->floor_plans)) { ?>
                    <div class="spproperty-floor-plan-wrap d-flex spproperty-feature-item">
                        <div class="title-wrapper">
                            <h3 class="spproperty-title"><?php echo JText::_('COM_SPPROPERTY_FLOOR_PLAN'); ?></h3>
                            <p><?php echo $this->item->fp_text; ?></p>
                        </div>
                        <div class="spproperty-floor-plan second-child">
                            <div class="spproperty-floor-plan-tab">
                            <!-- Nav tabs -->
                            <ul class="spproperty-floor-tab-nav nav nav-tabs" role="tablist">
                                <?php
                                $i = 0;
                                foreach ($this->item->floor_plans as $key => $floor_plan) {
                                    $tav_active = ($i == 0) ? 'active' : '';
                                    ?>
                                    <li role="presentation"><a href="#layout-<?php echo $key; ?>" class="<?php echo $tav_active; ?>" aria-controls="layout-<?php echo $key; ?>" role="tab" data-toggle="tab">
                                            <?php echo $floor_plan['layout_name']; ?>
                                        </a></li>
                                <?php $i++; } ?>
                            </ul>
                            <div class="tab-content">
                                <?php
                                $i = 0;
                                foreach ($this->item->floor_plans as $key => $floor_plan) {
                                    $tav_active = ($i == 0) ? 'active show' : '';
                                    ?>
                                    <div role="tabpanel" class="tab-pane fade in <?php echo $tav_active; ?>" id="layout-<?php echo $key; ?>">
                                        <div class="spproperty-floor-img">
                                            <img alt="" src="<?php echo JUri::root() . $floor_plan['img']; ?>">
                                        </div>
    
                                        <div class="spproperty-floor-text">
                                            <?php echo $floor_plan['text']; ?>
                                        </div>
                                    </div> <!-- /.tab-pane -->
                                <?php $i++;} ?>
                            </div> <!-- /.tab-content -->
    
                            <!-- if data in new format -->
                            <?php if (!array_key_exists('layout_name', $this->item->floor_plans) && !array_key_exists('img', $this->item->floor_plans) && !array_key_exists('text', $this->item->floor_plans)){ ?>
                                
                            <?php } ?>
                            </div> <!-- /.spproperty-floor-plan-tab -->
                        </div> <!-- /.spproperty-floor-plan -->
                    </div>
                <?php } // has floor plans   ?>
                
                <?php if ($emi_calculation) { ?>
                <div class="spproperty-emi-calculation d-flex spproperty-feature-item">
                    <div class="title-wrapper">
                        <h3 class="spproperty-title"><?php echo JText::_('COM_SPPROPERTY_EMI_CALCULATOR'); ?></h3>
                    </div>
                    <div class="second-child">
                    <?php
                        jimport('joomla.application.module.helper');
                        $modules = JModuleHelper::getModules('spproperty-details-emi-calculator');
                        $attribs['style'] = 'sp_xhtml';

                        foreach ($modules as $key => $module) {
                                echo JModuleHelper::renderModule($module, $attribs);
                        }
                    ?>
                    </div>
                </div>
                <?php } ?>
                
            </div> <!-- /.col-sm-8 -->

            <div class="col-md-5 col-xs-12 spproperty-sidebar">
                <aside class="spproperty-call-us-widget">
                    <?php if (!is_null($this->item->price_request) && $this->item->price_request == 'request'){ ?>
                        <h3 class="spproperty-price-title">
                            <?php echo $this->item->property_status == 'rent' ? JText::_('COM_SPPROPERTY_PROPERTY_RENT') : JText::_('COM_SPPROPERTY_PROPERTY_PRICE'); ?>
                        </h3>
                        <small>
                            <a href="#" onclick="return false" data-toggle="modal" data-target="#request-for-price-form" class="sppb-btn sppb-btn-success sppb-btn-xs">
                                <span class="request-title" data-pid="<?php echo $this->item->id; ?>">
                                    <?php echo JText::_('COM_SPPROPERTY_REQUEST_PRICE'); ?>
                                </span>
                            </a>
                        </small>
                        
                        <form class="spproperty-widget-form-request">
                            <div class="modal fade" tabindex="-1" role="dialog" id="request-for-price-form">
                                <div class="modal-dialog" role="document">
                                    <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                        <h4 class="modal-title"><?php echo JText::_('COM_SPPROPERTY_REQUEST_PRICE'); ?></h4>
                                    </div>
                                    <div class="modal-body">
                                        <div class="content-body">
                                            <div class="row mb-0">
                                                <div class="form-group col-md-6">
                                                    <input type="text" class="form-control" name="name" placeholder="<?php echo JText::_('COMPROPERTY_PLACEHOLDER_FULLNAME'); ?>" required="required">
                                                </div>
                                                <div class="form-group col-md-6">
                                                    <input type="tel" class="form-control" name="phone" placeholder="<?php echo JText::_('COMPROPERTY_PLACEHOLDER_PHONE'); ?>" required="required">
                                                </div>
                                            </div>
                                        <div class="form-group">
                                            <input type="email" class="form-control" name="email" placeholder="<?php echo JText::_('COMPROPERTY_PLACEHOLDER_EMAIL'); ?>" required="required">
                                        </div>
                                        <div class="form-group">
                                            <textarea name="message" class="form-control" rows="10" cols="5" placeholder="<?php echo JText::_('COMPROPERTY_PLACEHOLDER_MESSAGE'); ?>" required="required"><?php echo JText::sprintf('COM_SPPROPERTY_PRICE_REQ_MESSGE',$this->item->agent->title, $this->item->title, !empty($this->item->property_id) ? $this->item->property_id : '');?></textarea>
                                        </div>

                                        <input type="hidden" name="sender" value="<?php echo base64_encode($this->recipient); ?>">
                                        <input type="hidden" name="pid" value="<?php echo $this->item->id; ?>">
                                        <input type="hidden" name="visitor_ip" value="<?php echo $this->visitorip; ?>">
                                        <input type="hidden" name="pname" value="<?php echo $this->item->title; ?>">
                                        <input type="hidden" name="request_type" value="price" >
                                        <input type="hidden" name="agent_email" value="<?php echo base64_encode($this->item->agent->email); ?>" >
                                        <input type="hidden" name="property_id" value="<?php echo isset($this->item->property_id) ? $this->item->property_id : ''; ?>" >

                                        <div class="spproperty-captcha">
                                            <input type="hidden" id="showcaptcha" name="showcaptcha" value="<?php echo $this->captcha; ?>">
                                            <?php if($this->captcha) { ?>
                                                <div class="input-field">
                                                    <?php
                                                        JPluginHelper::importPlugin('captcha', 'recaptcha');
                                                        $dispatcher = JDispatcher::getInstance();
                                                        $dispatcher->trigger('onInit', 'dynamic_recaptcha_spmedical');
                                                        $recaptcha = $dispatcher->trigger('onDisplay', array(null, 'dynamic_recaptcha_spmedical', 'class="spproperty-dynamic-recaptcha"'));
                                                        
                                                        echo (isset($recaptcha[0])) ? $recaptcha[0] : '<p class="spproperty-alert-warning">' . JText::_('COM_SPMEDICAL_CAPTCHA_NOT_INSTALLED') . '</p>';
                                                    ?>
                                                </div>
                                            <?php } ?>
                                        </div>
                                        
                                        <?php if($this->contact_tac) { ?>
                                            <div class="input-field">
                                                <label class="form-checkbox">
                                                    <input type="checkbox" id="tac" name="tac" value="tac" required="true" data-apptac="true">
                                                    <?php echo empty(trim($this->contact_tac_text)) ?  JText::_('COM_SPPROPERTY_TERMS_AND_CONDITIONS') : $this->contact_tac_text; ?>
                                                </label>
                                            </div>
                                        <?php } ?>
                                        </div>
                                        <div class="spproperty-display-tick" style="display: none;">
                                            <div class="circle-loader">
                                                <div class="checkmark draw"></div>
                                            </div>
                                        </div>
                                        <div style="display:none;margin-top:10px;" class="spproperty-req-status-price"></div>
                                    </div>
                                    
                                    <div class="modal-footer">
                                        <button type="submit" class="sppb-btn sppb-btn-success sppb-btn-sm spproperty-req-submit-price"><?php echo JText::_('COM_PROPERTY_FORMBTN_SUBMIT'); ?></button>
                                        <button type="button" class="sppb-btn sppb-btn-primary sppb-btn-sm" data-dismiss="modal">Close</button>
                                    </div>
                                    </div><!-- /.modal-content -->
                                </div><!-- /.modal-dialog -->
                            </div><!-- /.modal -->
                        </form>
                    <?php } else{ ?>
                        <?php if ($this->item->price) { ?>
                            <?php
                                $calc_price = (int)$this->item->solid_price * (int)$this->item->psize;
                                if ($calc_price == 0) {
                                    $calc_price = $this->item->solid_price;
                                }
                                $total_price = SppropertyHelper::generateCurrency($calc_price, $this->item->currency, $this->item->currency_position, $this->item->currency_format);
                            ?>
                            <h3 class="spproperty-price-title"><?php echo $this->item->property_status == 'rent' ? JText::_('COM_SPPROPERTY_PROPERTY_RENT') : JText::_('COM_SPPROPERTY_PROPERTY_PRICE'); ?></h3>
                            
                            <!-- If fixed price given -->
                        
                            <?php if ($this->item->fixed_price) { ?>
                                <?php if ($this->item->property_status == 'rent') { ?>
                                    <p class="spproperty-total-price"><?php echo $total_price . ' / ' . (!empty($this->item->rent_period) ? $this->item->rent_period : JText::_('COM_SPPROPERTY_RENT_PERIOD_DEFAULT')) ; ?></p>
                                <?php } else { ?>
                                    <p class="spproperty-total-price"><?php echo $total_price ; ?></p>
                                <?php } ?>
                            <?php } else { ?>
                                <?php if ($this->item->property_status == 'rent') { ?>
                                    <p class="spproperty-total-price"><?php echo $total_price . ' / ' . (!empty($this->item->rent_period) ? $this->item->rent_period : JText::_('COM_SPPROPERTY_RENT_PERIOD_DEFAULT')) ; ?></p>
                                <?php } else { ?>
                                    <p class="spproperty-total-price"><?php echo $total_price ; ?></p>
                                <?php } ?>
                                <p class="spproperty-per-sft">
                                    <?php echo $this->item->price . ' / ' ; ?>
                                    <?php echo empty(trim($this->cParams['measurement'])) ?  JText::_('COM_SPPROPERTY_PROPERTIES_SQFT') : $this->cParams['measurement']; ?>
                                </p>
                            <?php } ?>
                        <?php } ?>
                    <?php } ?>
                    <?php if (!is_null($this->item->property_id) && $this->cParams->get('show_property_id', true)){ ?>
                        <h4 class="spproperty-id">
                            <span><?php echo JText::_('COM_SPPROPERTY_PROPERTY_ID'); ?>: </span>
                            <small><?php echo $this->item->property_id; ?></small>    
                        </h4>
                    <?php } ?>

                    <?php if ((isset($this->item->agent->phone) && $this->item->agent->phone) || (isset($this->item->agent->mobile) && $this->item->agent->mobile)) { ?>
                        <p class="spproperty-call-for-booking"><?php echo JText::_('COM_SPPROPERTY_AGENT_CALL_FOR_BOOKING'); ?></p>
                            <?php if ($this->item->agent->phone) { ?>
                                <a href="tel: <?php echo $this->item->agent->phone ? $this->item->agent->phone : $this->item->agent->mobile; ?>" class="sppb-btn sppb-btn-default sppb-btn-block"><span><?php echo $this->item->agent->phone; ?></span></i>
                            <?php } else { ?>
                                <span class="sppb-btn sppb-btn-default sppb-btn-block"><?php echo $this->item->agent->mobile; ?></span>
                            <?php } ?>
                        </a>
                    <?php } ?>

                </aside>

               

                <?php if ($this->cParams->get('req_visit', 1)) { ?>
                    <aside class="spproperty-contact-us-widget">
                        <h3>
                            <span><?php echo JText::_('COM_SPPROPERTY_CONTACT_FOR_ENQUIRY'); ?></span>
                        </h3>
                        <p><?php echo JText::_('COM_SPPROPERTY_PROPERTY_REQUREST_FOR_VISIT_DESC'); ?></p>
                        <form class="spproperty-contact-us-form spproperty-widget-form">
                            <input type="text" name="name" placeholder="<?php echo JText::_('COMPROPERTY_PLACEHOLDER_FULLNAME'); ?>" required="required">
                            <input type="email" name="email" placeholder="<?php echo JText::_('COMPROPERTY_PLACEHOLDER_EMAIL'); ?>" required="required">
                            <input type="tel" name="phone" placeholder="<?php echo JText::_('COMPROPERTY_PLACEHOLDER_PHONE'); ?>" required="required">
                            <textarea name="message" placeholder="<?php echo JText::_('COMPROPERTY_PLACEHOLDER_MESSAGE'); ?>" required="required"></textarea>
                            <input type="hidden" name="sender" value="<?php echo base64_encode($this->recipient); ?>">
                            <input type="hidden" name="pid" value="<?php echo $this->item->id; ?>">
                            <input type="hidden" name="visitor_ip" value="<?php echo $this->visitorip; ?>">
                            <input type="hidden" name="pname" value="<?php echo $this->item->title; ?>">
                            <input type="hidden" name="request_type" value="visit" >

                            <div class="spproperty-captcha">
                                <input type="hidden" id="showcaptcha" name="showcaptcha" value="<?php echo $this->captcha; ?>">
                                <?php if($this->captcha) { ?>
                                    <div class="input-field">
                                        <?php
                                            JPluginHelper::importPlugin('captcha', 'recaptcha');
                                            $dispatcher = JDispatcher::getInstance();
                                            $dispatcher->trigger('onInit', 'dynamic_recaptcha_spmedical');
                                            $recaptcha = $dispatcher->trigger('onDisplay', array(null, 'dynamic_recaptcha_spmedical', 'class="spproperty-dynamic-recaptcha"'));
                                            
                                            echo (isset($recaptcha[0])) ? $recaptcha[0] : '<p class="spproperty-alert-warning">' . JText::_('COM_SPMEDICAL_CAPTCHA_NOT_INSTALLED') . '</p>';
                                        ?>
                                    </div>
                                <?php } ?>
                            </div>
                            
                            <?php if($this->contact_tac) { ?>
								<div class="input-field">
									<label class="form-checkbox">
										<input type="checkbox" id="tac" name="tac" value="tac" required="true" data-apptac="true">
                                        <?php echo empty(trim($this->contact_tac_text)) ?  JText::_('COM_SPPROPERTY_TERMS_AND_CONDITIONS') : $this->contact_tac_text; ?>
									</label>
								</div>
							<?php } ?>
                            <button type="submit" class="sppb-btn sppb-btn-primary sppb-btn-sm sppb-btn-block"><?php echo JText::_('COM_PROPERTY_FORMBTN_SUBMIT'); ?></button>
                        </form>
                        <div style="display:none;margin-top:10px;" class="spproperty-req-status"></div>
                    </aside>
                <?php } ?>

            </div>
        </div>
    </div>
</div> <!-- /.spproperty -->
<?php if ($this->map_type == 'leaflet'){ ?>
<script>
    jQuery(function($){
        var lat = "<?php echo $this->map[0];?>";
        var lon = "<?php echo $this->map[1];?>";
        var mapbox_token = "<?php echo $this->mapbox_token; ?>";
        var map_view    = "<?php echo $this->map_view; ?>";
        var title = "<?php echo $this->item->title; ?>";

        $("#map").spleaflet({
            'markers': [
                {
                    'lat': lat,
                    'lon': lon,
                    'text': title
                }
            ],
            'token' : mapbox_token,
            'view'  : map_view
        });
    });
</script>
<?php } ?>

<script>
    jQuery(function($){
        $("#request-for-price-form").on('show.bs.modal', function(e){
            $('#sp-header-sticky-wrapper').css('z-index', '0');
        });

        $("#request-for-price-form").on('hide.bs.modal', function(e){
            $('#sp-header-sticky-wrapper').css('z-index', '999');
        });
    });
    
</script>