jQuery(function ($) {
    function createAnimatedScroller(selector, gap) {
        const scroller = document.querySelector(selector);
        if (scroller) {
            let currentLeftValue = 0;
            let interval = null;

            // Style the wrapper and scroller
            scroller.style.display = "flex";
            scroller.style.whiteSpace = "nowrap";
            scroller.style.position = "relative";

            // Duplicate content for seamless scrolling
            const content = scroller.innerHTML;
            scroller.innerHTML = content + content;

            function animationStart() {
                interval = setInterval(animationLoop, 20);
            }

            function animationStop() {
                clearInterval(interval);
            }

            function resetPosition() {
                const firstChild = scroller.firstElementChild;
                if (firstChild) {
                    currentLeftValue = 0;
                    scroller.style.transform = `translateX(0)`;
                }
            }

            function animationLoop() {
                const firstChild = scroller.firstElementChild;
                if (!firstChild) return;

                currentLeftValue -= 1;

                // Reset position when first item is fully scrolled
                if (Math.abs(currentLeftValue) >= firstChild.offsetWidth) {
                    scroller.appendChild(firstChild);
                    currentLeftValue = 0;
                }

                scroller.style.transform = `translateX(${currentLeftValue}px)`;
            }
            
            // Event listeners
            scroller.addEventListener("mouseover", animationStop);
            scroller.addEventListener("mouseout", animationStart);
            window.addEventListener("resize", resetPosition);

            // Start animation
            animationStart();
        }
    }
    // Initialize the scroller
    createAnimatedScroller(".animated-scroller", 0);
});