<?php

/**
 * @package Finatic
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2019 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */
//no direct accees
defined('_JEXEC') or die('resticted access');

class SppagebuilderAddonFinatic_services extends SppagebuilderAddons
{

	public function render()
	{
		$class = (isset($this->addon->settings->class) && $this->addon->settings->class) ? $this->addon->settings->class : '';
		$columns 		= (isset($this->addon->settings->columns) && $this->addon->settings->columns) ? $this->addon->settings->columns : 3;

		$grid_layout = isset($this->addon->settings->finatic_service_grid_layout) ? $this->addon->settings->finatic_service_grid_layout : '';
		$grid_layout_active = $grid_layout != '' ? 'gird-layout' : '';
		$output = '<div class="finatic-services ' . $class . ' ' . $grid_layout_active . '">';
		if ($this->addon->settings->finatic_service_carousel) {
			$output .= '<div id="finatic-services-carousel" class="owl-carousel" data-carouselid="">';
		}
		if ($grid_layout) {
			$output .= '<div class="sppb-row">';
		}
		foreach ($this->addon->settings->finatic_service as $key => $service) {
			$service_img = "";
			$service_img_alt = "";
	
			if (isset($service->finatic_service_image)) {
				if (is_object($service->finatic_service_image)) {
					$service_img = $service->finatic_service_image->src;
					$service_img_alt = $service->finatic_service_image->alt;
				} elseif (is_string($service->finatic_service_image)) {
					$service_img = $service->finatic_service_image;
				}
				if(strpos($service_img, "http://") === 0 || strpos($service_img, "https://") === 0){
					$service_img = $service_img;
				} else {
					$service_img = JURI::base() . $service_img;
				}
			}

			if ($grid_layout) {
				$output .= '<div class="sppb-col-6 sppb-col-12 sppb-col-sm-' . round(12 / $columns) . '">';
			}
			$output .= '<div class="item">';
			$service_title = isset($service->finatic_service_title) ? $service->finatic_service_title : '';
			$service_btn_content = isset($service->finatic_service_btn_content) ? $service->finatic_service_btn_content : '';
			if ($service_img) {
				$output .= '<img src="' . $service_img . '" alt="' . $service_img_alt . '">';
			}
			$output .= '<div class="item-info">';
			if ($service_title) {
				$output .= '<h3>' . $service_title . '</h3>';
			}
			if(isset($service->finatic_service_items)){
				$output .= '<ul class="finatic-service-items">';
				foreach ($service->finatic_service_items as $key => $item) {
					$item_image = "";
					if (isset($item->item_image)) {
						if (is_object($item->item_image)) {
							$item_image = $item->item_image->src;
						} elseif (is_string($item->item_image)) {
							$item_image = $item->item_image;
						}
						if(strpos($item_image, "http://") === 0 || strpos($item_image, "https://") === 0){
							$item_image = $item_image;
						} else {
							$item_image = JURI::base() . $item_image;
						}
					}
	
					$output .= '<li>';
					if ($item->choose_option == 'image') {
						$output .= '<img src="' . $item_image . '">';
					} else if ($item->choose_option == 'icon') {
						$output .= '<i class="fa ' . $item->item_icon . '"></i>';
					} else if ($item->choose_option == 'custom_icon') {
						$output .= '<i class="' . $item->item_custom_icon . '"></i>';
					}
					if (isset($item->item_title) && $item->item_title) {
						$output .= '<p>' . $item->item_title . '</p>';
					}
					if (isset($item->item_link) && $item->item_link) {
						$output .= '<a href="' . $item->item_link . '" class="full-link"></a>';
					}
					$output .= '</li>';
				}
				$output .= '</ul>';
			}
			if ($service_btn_content) {
				$output .= '<a class="sppb-btn sppb-btn-link" href="' . $service->finatic_service_button_url . '">' . $service_btn_content . '<i class="fn-next"></i></a>';
			}
			$output .= '</div>';
			$output .= '</div>';
			if ($grid_layout) {
				$output .= '</div>'; //col
			}
		}
		if ($grid_layout) {
			$output .= '</div>'; //row
		}
		if ($this->addon->settings->finatic_service_carousel) {
			$output .= '</div>';
		}
		$output .= '</div>';

		return $output;
	}

	public function scripts()
	{
		$app = JFactory::getApplication();
		$base_path = JURI::base() . '/templates/' . $app->getTemplate() . '/js/';
		return array($base_path . 'owl.carousel.min.js', $base_path . 'addon.slider.js');
	}

	public function js()
	{
		$addon_id = '#sppb-addon-' . $this->addon->id;
		return '
            jQuery(document).ready(function($){"use strict";

            $("' . $addon_id . ' #finatic-services-carousel").owlCarousel({
                margin: 30,
                loop: true,
                video:true,
                autoplay: true,
								dots: false,
								nav: true,
                autoplaySpeed: 800,
								navText: ["<i class=\"fa fa-angle-left\"></i>", "<i class=\"fa fa-angle-right\"></i>"],
                responsive: {
										0: {
											items: 1
										},
                    768: {
											items: 2
                    },
										999: {
											items: 3
                    },
										1800: {
											items: 4
                    }
                },
								onInitialized: function() {
										$(".owl-item.active").last().addClass("last-owl-active-item");
								},
								onTranslated: function() {
										$(event.target).find(".last-owl-active-item").removeClass("last-owl-active-item");
										$(event.target).find(".active").last().addClass("last-owl-active-item");
								}
            });
        });
        ';
	}

	public function stylesheets()
	{
		$app = JFactory::getApplication();
		$base_path = JURI::base() . '/templates/' . $app->getTemplate() . '/css/';
		return array($base_path . 'owl.carousel.min.css');
	}

	public static function getTemplate()
	{
		$output = '
					<# let grid_layout_active = data.finatic_service_grid_layout != "" ? "gird-layout" : ""; 
						 let columns =  Math.round(12/data.columns);
						 #>
					<div class="finatic-services {{data.class}} {{grid_layout_active}}">
						<# if(data.finatic_service_carousel){ #>
							<div id="finatic-services-carousel" class="owl-carousel">
						<# }
						if(data.finatic_service_grid_layout){ #>
						<div class="sppb-row">
						<# }
							_.each (data.finatic_service, function(service){ #>
								<# if(data.finatic_service_grid_layout){ #>
							<div class="sppb-col-sm-{{columns}}">
								<# } #>
								<div class="item">
									<# 
									let finatic_service_image = "";
									if(typeof service.finatic_service_image !== "undefined") {
										if(typeof service.finatic_service_image === "object"){
											if(service.finatic_service_image.src.indexOf("http://") === 0 || service.finatic_service_image.src.indexOf("https://") === 0){
												finatic_service_image = `src=${service.finatic_service_image.src}`;
											} else {
												finatic_service_image = `src=${pagebuilder_base + service.finatic_service_image.src}`;
											}
										} else {
											if(service.finatic_service_image.indexOf("http://") === 0 || service.finatic_service_image.indexOf("https://") === 0){
												finatic_service_image = `src=${service.finatic_service_image}`;
											} else {
												finatic_service_image = `src=${pagebuilder_base + service.finatic_service_image}`;
											}
										}
									}
									
									
									if(finatic_service_image){ #>
										<img {{finatic_service_image}}>
									<# } #>
									<div class="item-info">
									<# if(service.finatic_service_title){ #>
											<h3>{{{service.finatic_service_title}}}</h3>
									<# } #>
									<ul class="finatic-service-items">
									<# _.each (service.finatic_service_items, function(item) { #>
										<li>
											<#
											let item_image = "";
											if(typeof item.item_image !== "undefined") {
												if(typeof item.item_image === "object"){
													if(item.item_image.src.indexOf("http://") === 0 || item.item_image.src.indexOf("https://") === 0){
														item_image = `src=${item.item_image.src}`;
													} else {
														item_image = `src=${pagebuilder_base + item.item_image.src}`;
													}
												} else {
													if(item.item_image.indexOf("http://") === 0 || item.item_image.indexOf("https://") === 0){
														item_image = `src=${item.item_image}`;
													} else {
														item_image = `src=${pagebuilder_base + item.item_image}`;
													}
												}
											}

											if(item.choose_option == "image"){ #>
													<img {{item_image}}>
											<# } else if(item.choose_option == "icon"){ #>
													<i class="fa {{item.item_icon}}"></i>
											<# } else if(item.choose_option == "custom_icon"){ #>
													<i class="{{item.item_custom_icon}}"></i>
											<# } #>
											<p>{{{item.item_title}}}</p>
											<# if(item.item_link){ #>
												<a href="{{item.item_link}}" class="full-link"></a>
											<# } #>
										</li>
									<# }) #>
									</ul>
									<# if(service.finatic_service_btn_content){ #>
										<a class="sppb-btn sppb-btn-link" href="{{service.finatic_service_button_url}}">{{{service.finatic_service_btn_content}}}<i class="fn-next"></i></a>
									<# } #>
									</div>
								</div>
								<# if(data.finatic_service_grid_layout){ #>
								</div>
								<# } #>
							<# });
						if(data.finatic_service_grid_layout){ #>
						</div>
						<# }
						if(data.finatic_service_carousel){ #>
							</div>
						<# } #>
					</div>
					';
		return $output;
	}
}
