<?php

/**
 * @package SP Page Builder
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2022 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */
//no direct accees
defined('_JEXEC') or die('restricted access');

use Joomla\CMS\Language\Text;

SpAddonsConfig::addonConfig([
	'type'       => 'content',
	'addon_name' => 'sp_feature',
	'title'      => Text::_('COM_SPPAGEBUILDER_ADDON_FEATURE_BOX'),
	'desc'       => Text::_('COM_SPPAGEBUILDER_ADDON_FEATURE_BOX_DESC'),
	'category'   => 'Content',
	'attr'       => [
		'general' => [

			'admin_label' => [
				'type'  => 'text',
				'title' => Text::_('COM_SPPAGEBUILDER_ADDON_ADMIN_LABEL'),
				'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_ADMIN_LABEL_DESC'),
				'std'   => ''
			],

			'title' => [
				'type'  => 'text',
				'title' => Text::_('COM_SPPAGEBUILDER_ADDON_TITLE'),
				'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_TITLE_DESC'),
				'std'   => 'Feature Box'
			],

			'heading_selector' => [
				'type'    => 'select',
				'title'   => Text::_('COM_SPPAGEBUILDER_ADDON_HEADINGS'),
				'desc'    => Text::_('COM_SPPAGEBUILDER_ADDON_HEADINGS_DESC'),
				'values'  => [
					'h1' => Text::_('COM_SPPAGEBUILDER_ADDON_HEADINGS_H1'),
					'h2' => Text::_('COM_SPPAGEBUILDER_ADDON_HEADINGS_H2'),
					'h3' => Text::_('COM_SPPAGEBUILDER_ADDON_HEADINGS_H3'),
					'h4' => Text::_('COM_SPPAGEBUILDER_ADDON_HEADINGS_H4'),
					'h5' => Text::_('COM_SPPAGEBUILDER_ADDON_HEADINGS_H5'),
					'h6' => Text::_('COM_SPPAGEBUILDER_ADDON_HEADINGS_H6'),
				],
				'std'     => 'h3',
				'depends' => [['title', '!=', '']],
			],

			'title_font_family' => [
				'type'    => 'fonts',
				'title'   => Text::_('COM_SPPAGEBUILDER_ADDON_TITLE_FONT_FAMILY'),
				'desc'    => Text::_('COM_SPPAGEBUILDER_ADDON_TITLE_FONT_FAMILY_DESC'),
				'depends' => [['title', '!=', '']],
				'selector' => [
					'type' => 'font',
					'font' => '{{ VALUE }}',
					'css'  => '.sppb-addon-title { font-family: {{ VALUE }}; }'
				]
			],

			'title_position' => [
				'type'    => 'select',
				'title'   => Text::_('COM_SPPAGEBUILDER_ADDON_FEATURE_BOX_ICON_IMAGE_POSITION'),
				'desc'    => Text::_('COM_SPPAGEBUILDER_ADDON_FEATURE_BOX_ICON_IMAGE_POSITION_DESC'),
				'values'  => [
					'after'  => Text::_('COM_SPPAGEBUILDER_ADDON_FEATURE_BOX_TITLE_POSITION_BEFORE_TITLE'),
					'before' => Text::_('COM_SPPAGEBUILDER_ADDON_FEATURE_BOX_TITLE_POSITION_AFTER_TITLE'),
					'left'   => Text::_('COM_SPPAGEBUILDER_ADDON_FEATURE_BOX_TITLE_POSITION_LEFT'),
					'right'  => Text::_('COM_SPPAGEBUILDER_ADDON_FEATURE_BOX_TITLE_POSITION_RIGHT'),
				],
				'std'     => 'after',
				'depends' => [['title', '!=', '']],
			],

			'title_fontsize' => [
				'type'       => 'slider',
				'title'      => Text::_('COM_SPPAGEBUILDER_ADDON_TITLE_FONT_SIZE'),
				'desc'       => Text::_('COM_SPPAGEBUILDER_ADDON_TITLE_FONT_SIZE_DESC'),
				'std'        => ['md' => 16],
				'depends'    => [['title', '!=', '']],
				'responsive' => true,
				'max'        => 400,
			],

			'title_lineheight' => [
				'type'       => 'slider',
				'title'      => Text::_('COM_SPPAGEBUILDER_ADDON_TITLE_LINE_HEIGHT'),
				'std'        => ['md' => 22],
				'depends'    => [['title', '!=', '']],
				'responsive' => true,
				'max'        => 400,
			],

			'title_font_style' => [
				'type'    => 'fontstyle',
				'title'   => Text::_('COM_SPPAGEBUILDER_ADDON_TITLE_FONT_STYLE'),
				'depends' => [['title', '!=', '']],
			],

			'title_letterspace' => [
				'type'    => 'select',
				'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_LETTER_SPACING'),
				'values'  => [
					'0'    => 'Default',
					'1px'  => '1px',
					'2px'  => '2px',
					'3px'  => '3px',
					'4px'  => '4px',
					'5px'  => '5px',
					'6px'  => '6px',
					'7px'  => '7px',
					'8px'  => '8px',
					'9px'  => '9px',
					'10px' => '10px'
				],
				'std'     => '0',
				'depends' => [['title', '!=', '']],
			],

			'title_text_color' => [
				'type'    => 'color',
				'title'   => Text::_('COM_SPPAGEBUILDER_ADDON_TITLE_TEXT_COLOR'),
				'desc'    => Text::_('COM_SPPAGEBUILDER_ADDON_TITLE_TEXT_COLOR_DESC'),
				'std'     => '#4A4A4A',
				'depends' => [['title', '!=', '']],
			],

			'title_margin_top' => [
				'type'       => 'slider',
				'title'      => Text::_('COM_SPPAGEBUILDER_ADDON_TITLE_MARGIN_TOP'),
				'desc'       => Text::_('COM_SPPAGEBUILDER_ADDON_TITLE_MARGIN_TOP_DESC'),
				'placeholder' => '10',
				'depends'    => [['title', '!=', '']],
				'responsive' => true,
				'max'        => 400,
			],

			'title_margin_bottom' => [
				'type'       => 'slider',
				'title'      => Text::_('COM_SPPAGEBUILDER_ADDON_TITLE_MARGIN_BOTTOM'),
				'desc'       => Text::_('COM_SPPAGEBUILDER_ADDON_TITLE_MARGIN_BOTTOM_DESC'),
				'placeholder' => '10',
				'depends'    => [['title', '!=', '']],
				'responsive' => true,
				'max'        => 400,
			],

			'title_url' => [
				'type'    => 'link',
				'title'   => Text::_('COM_SPPAGEBUILDER_ADDON_FEATURE_BOX_TITLE_URL'),
				'desc'    => Text::_('COM_SPPAGEBUILDER_ADDON_FEATURE_BOX_TITLE_URL_DESC'),
				'std'     => '',
				'depends' => [['title', '!=', '']],
			],

			'feature_type' => [
				'type'    => 'select',
				'title'   => Text::_('COM_SPPAGEBUILDER_ADDON_FEATURE_BOX_LAYOUT_TYPE'),
				'desc'    => Text::_('COM_SPPAGEBUILDER_ADDON_FEATURE_BOX_LAYOUT_TYPE_DESC'),
				'values'  => [
					'icon'  => Text::_('COM_SPPAGEBUILDER_ADDON_FEATURE_BOX_LAYOUT_TYPE_ICON'),
					'image' => Text::_('COM_SPPAGEBUILDER_ADDON_FEATURE_BOX_LAYOUT_TYPE_IMAGE'),
				],
				'std' => 'icon'
			],

			'separator_image_options' => [
				'type'    => 'separator',
				'title'   => Text::_('COM_SPPAGEBUILDER_ADDON_IMAGE_OPTIONS'),
				'depends' => ['feature_type' => 'image']
			],

			'separator_icon_options' => [
				'type'    => 'separator',
				'title'   => Text::_('COM_SPPAGEBUILDER_ADDON_ICON_OPTIONS'),
				'depends' => ['feature_type' => 'icon']
			],

			'feature_image' => [
				'type'    => 'media',
				'title'   => Text::_('COM_SPPAGEBUILDER_ADDON_FEATURE_BOX_IMAGE'),
				'desc'    => Text::_('COM_SPPAGEBUILDER_ADDON_FEATURE_BOX_IMAGE_DESC'),
				'std'     => '',
				'depends' => ['feature_type' => 'image']
			],

			'icon_name' => [
				'type'    => 'icon',
				'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_ICON_NAME'),
				'std'     => 'fa-trophy',
				'depends' => ['feature_type' => 'icon']
			],

			'icon_size' => [
				'type'       => 'slider',
				'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_ICON_SIZE'),
				'placeholder' => 36,
				'std'        => ['md' => 36],
				'depends'    => ['feature_type' => 'icon'],
				'responsive' => true,
				'max'        => 400,
			],

			'icon_color' => [
				'type'    => 'color',
				'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_COLOR'),
				'std'     => '#0080FE',
				'depends' => ['feature_type' => 'icon']
			],

			'icon_background' => [
				'type'    => 'color',
				'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BACKGROUND_COLOR'),
				'depends' => ['feature_type' => 'icon']
			],

			'icon_border_color' => [
				'type'    => 'color',
				'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BORDER_COLOR'),
				'depends' => ['feature_type' => 'icon']
			],

			'icon_border_width' => [
				'type'       => 'slider',
				'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_BORDER_WIDTH'),
				'depends'    => ['feature_type' => 'icon'],
				'responsive' => true,
				'max'        => 400,
			],

			'icon_border_radius' => [
				'type'       => 'slider',
				'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_BORDER_RADIUS'),
				'depends'    => ['feature_type' => 'icon'],
				'responsive' => true,
				'max'        => 400,
			],

			'icon_margin_top' => [
				'type'       => 'slider',
				'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_MARGIN_TOP'),
				'depends'    => ['feature_type' => 'icon'],
				'responsive' => true,
				'max'        => 400,
			],

			'icon_margin_bottom' => [
				'type'       => 'slider',
				'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_MARGIN_BOTTOM'),
				'depends'    => ['feature_type' => 'icon'],
				'responsive' => true,
				'max'        => 400,
			],

			'icon_padding' => [
				'type'       => 'padding',
				'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_PADDING'),
				'desc'       => Text::_('COM_SPPAGEBUILDER_GLOBAL_PADDING_DESC'),
				'depends'    => ['feature_type' => 'icon'],
				'responsive' => true
			],

			'separator_addon_options' => [
				'type'  => 'separator',
				'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_ADDON_OPTIONS')
			],

			'text' => [
				'type'  => 'editor',
				'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_CONTENT'),
				'std'   => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer adipiscing erat eget risus sollicitudin pellentesque et non erat.'
			],

			'text_font_family' => [
				'type'    => 'fonts',
				'title'   => Text::_('COM_SPPAGEBUILDER_ADDON_CONTENT_FONT_FAMILY'),
				'desc'    => Text::_('COM_SPPAGEBUILDER_ADDON_CONTENT_FONT_FAMILY_DESC'),
				'depends' => [['text', '!=', '']],
				'selector' => [
					'type' => 'font',
					'font' => '{{ VALUE }}',
					'css'  => '.sppb-addon-content .sppb-addon-text { font-family: {{ VALUE }}; }'
				]
			],

			'text_fontsize' => [
				'type'       => 'slider',
				'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_CONTENT_FONT_SIZE'),
				'std'        => '',
				'max'        => 400,
				'responsive' => true
			],

			'text_lineheight' => [
				'type'       => 'slider',
				'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_CONTENT_LINE_HEIGHT'),
				'std'        => '',
				'max'        => 400,
				'responsive' => true
			],

			// Start Button Fields
			'button_text' => [
				'type'  => 'text',
				'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_TEXT'),
				'desc'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_TEXT_DESC'),
				'std'   => 'Button',
			],

			'fontstyle' => [
				'type'     => 'select',
				'title'    => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_FONT_STYLE'),
				'values'   => [
					'underline' => Text::_('COM_SPPAGEBUILDER_GLOBAL_FONT_STYLE_UNDERLINE'),
					'uppercase' => Text::_('COM_SPPAGEBUILDER_GLOBAL_FONT_STYLE_UPPERCASE'),
					'italic'    => Text::_('COM_SPPAGEBUILDER_GLOBAL_FONT_STYLE_ITALIC'),
					'lighter'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_FONT_STYLE_LIGHTER'),
					'normal'    => Text::_('COM_SPPAGEBUILDER_GLOBAL_FONT_STYLE_NORMAL'),
					'bold'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_FONT_STYLE_BOLD'),
					'bolder'    => Text::_('COM_SPPAGEBUILDER_GLOBAL_FONT_STYLE_BOLDER'),
				],
				'multiple' => true,
				'std'      => ''
			],

			'letterspace' => [
				'type'  => 'select',
				'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_LETTER_SPACING'),
				'values' => [
					'0'    => 'Default',
					'1px'  => '1px',
					'2px'  => '2px',
					'3px'  => '3px',
					'4px'  => '4px',
					'5px'  => '5px',
					'6px'  => '6px',
					'7px'  => '7px',
					'8px'  => '8px',
					'9px'  => '9px',
					'10px' => '10px'
				],
				'std' => '0'
			],

			'url' => [
				'type'  => 'link',
				'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_URL'),
				'desc'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_URL_DESC'),
				'std'   => '',
			],

			'type' => [
				'type'  => 'select',
				'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_STYLE'),
				'desc'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_STYLE_DESC'),
				'values' => [
					'default' => Text::_('COM_SPPAGEBUILDER_GLOBAL_DEFAULT'),
					'primary' => Text::_('COM_SPPAGEBUILDER_GLOBAL_PRIMARY'),
					'success' => Text::_('COM_SPPAGEBUILDER_GLOBAL_SUCCESS'),
					'info'    => Text::_('COM_SPPAGEBUILDER_GLOBAL_INFO'),
					'warning' => Text::_('COM_SPPAGEBUILDER_GLOBAL_WARNING'),
					'danger'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_DANGER'),
					'link'    => Text::_('COM_SPPAGEBUILDER_GLOBAL_LINK'),
					'custom'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_CUSTOM'),
				],
				'std' => 'default',
			],

			'appearance' => [
				'type'  => 'select',
				'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_APPEARANCE'),
				'desc'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_APPEARANCE_DESC'),
				'values' => [
					''        => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_APPEARANCE_FLAT'),
					'outline' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_APPEARANCE_OUTLINE'),
					'3d'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_APPEARANCE_3D'),
				],
				'std' => 'flat',
			],

			'background_color' => [
				'type'    => 'color',
				'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_BACKGROUND_COLOR'),
				'desc'    => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_BACKGROUND_COLOR_DESC'),
				'std'     => '#444444',
				'depends' => ['type' => 'custom'],
			],

			'color' => [
				'type'    => 'color',
				'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_COLOR'),
				'desc'    => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_COLOR_DESC'),
				'std'     => '#fff',
				'depends' => ['type' => 'custom'],
			],

			'background_color_hover' => [
				'type'    => 'color',
				'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_BACKGROUND_COLOR_HOVER'),
				'desc'    => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_BACKGROUND_COLOR_HOVER_DESC'),
				'std'     => '#222',
				'depends' => ['type' => 'custom'],
			],

			'color_hover' => [
				'type'    => 'color',
				'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_COLOR_HOVER'),
				'desc'    => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_COLOR_HOVER_DESC'),
				'std'     => '#fff',
				'depends' => ['type' => 'custom'],
			],

			'size' => [
				'type'  => 'select',
				'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE'),
				'desc'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE_DESC'),
				'values' => [
					''    => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE_DEFAULT'),
					'lg'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE_LARGE'),
					'xlg' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE_XLARGE'),
					'sm'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE_SMALL'),
					'xs'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE_EXTRA_SAMLL'),
				],
			],

			'shape' => [
				'type'  => 'select',
				'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE'),
				'desc'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE_DESC'),
				'values' => [
					'rounded' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE_ROUNDED'),
					'square'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE_SQUARE'),
					'round'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE_ROUND'),
				],
			],

			'block' => [
				'type'  => 'select',
				'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_BLOCK'),
				'desc'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_BLOCK_DESC'),
				'values' => [
					''                => Text::_('JNO'),
					'sppb-btn-block' => Text::_('JYES'),
				]
			],

			'icon' => [
				'type'  => 'icon',
				'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_ICON'),
				'desc'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_ICON_DESC'),
			],

			'icon_position' => [
				'type'  => 'select',
				'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_ICON_POSITION'),
				'values' => [
					'left'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_LEFT'),
					'right' => Text::_('COM_SPPAGEBUILDER_GLOBAL_RIGHT'),
				],
			],
			// End Button Fields

			'alignment' => [
				'type'  => 'select',
				'title' => Text::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_CONTENT_ALIGNMENT'),
				'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_CONTENT_ALIGNMENT_DESC'),
				'values' => [
					'sppb-text-left'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_LEFT'),
					'sppb-text-center' => Text::_('COM_SPPAGEBUILDER_GLOBAL_CENTER'),
					'sppb-text-right'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_RIGHT'),
				],
				'std' => 'sppb-text-center',
			],

			'class' => [
				'type'  => 'text',
				'title' => Text::_('COM_SPPAGEBUILDER_ADDON_CLASS'),
				'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_CLASS_DESC'),
				'std'   => ''
			],
		],
	],
]);
